/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.AbstractWorkbench;
import com.flansmod.common.crafting.WorkbenchBlock;
import com.flansmod.common.crafting.recipes.GunFabricationRecipe;
import com.flansmod.common.types.crafting.WorkbenchDefinition;
import com.flansmod.common.types.crafting.elements.WorkbenchIOSettingDefinition;
import com.flansmod.common.types.crafting.elements.WorkbenchSideDefinition;
import com.flansmod.physics.common.util.Maths;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class WorkbenchBlockEntity
extends BlockEntity
implements WorldlyContainer,
MenuProvider,
Clearable,
ICapabilityProvider {
    public final WorkbenchDefinition Def;
    public final AbstractWorkbench Workbench;
    private final LazyOptional<IEnergyStorage> EnergyStorageLazyOptional;
    private ItemCapabilityMultiContainer[] DirectionalItemCaps;
    private final List<LazyOptional<IItemHandler>> DirectionalItemCapLazyOptionals;
    private static final double INTERACT_RANGE_SQ = 25.0;
    public final ContainerData DataAccess;
    private static final Component DISPLAY_NAME = Component.m_237115_((String)"workbench.title");

    public WorkbenchBlockEntity(ResourceLocation defLoc, BlockPos pos, BlockState state) {
        super((BlockEntityType)ForgeRegistries.BLOCK_ENTITY_TYPES.getValue(defLoc), pos, state);
        this.Def = (WorkbenchDefinition)FlansMod.WORKBENCHES.Get(defLoc);
        this.Workbench = new AbstractWorkbench(this.Def, player -> {
            if (this.m_58901_() || this.m_58904_().m_7702_(this.m_58899_()) != this) {
                return false;
            }
            if (this.m_58899_().m_203193_((Position)player.m_20318_(0.0f)) > 25.0) {
                return false;
            }
            return true;
        });
        this.DataAccess = this.Workbench.GetDataAccess();
        this.DirectionalItemCapLazyOptionals = new ArrayList<LazyOptional<IItemHandler>>(6);
        this.DirectionalItemCapLazyOptionals.add((LazyOptional<IItemHandler>)LazyOptional.of(() -> this.SupplyItemCapability(Direction.DOWN)));
        this.DirectionalItemCapLazyOptionals.add((LazyOptional<IItemHandler>)LazyOptional.of(() -> this.SupplyItemCapability(Direction.UP)));
        this.DirectionalItemCapLazyOptionals.add((LazyOptional<IItemHandler>)LazyOptional.of(() -> this.SupplyItemCapability(Direction.NORTH)));
        this.DirectionalItemCapLazyOptionals.add((LazyOptional<IItemHandler>)LazyOptional.of(() -> this.SupplyItemCapability(Direction.SOUTH)));
        this.DirectionalItemCapLazyOptionals.add((LazyOptional<IItemHandler>)LazyOptional.of(() -> this.SupplyItemCapability(Direction.WEST)));
        this.DirectionalItemCapLazyOptionals.add((LazyOptional<IItemHandler>)LazyOptional.of(() -> this.SupplyItemCapability(Direction.EAST)));
        this.EnergyStorageLazyOptional = this.Workbench.GetLazyOptionalEnergy();
    }

    @Nonnull
    public int[] m_7071_(@Nonnull Direction direction) {
        return new int[0];
    }

    public boolean m_7155_(int p_19235_, @Nonnull ItemStack stack, @Nullable Direction direction) {
        return false;
    }

    public boolean m_7157_(int p_19239_, @Nonnull ItemStack stack, @Nonnull Direction direction) {
        return false;
    }

    public int m_6643_() {
        return this.Workbench.m_6643_();
    }

    public boolean m_7983_() {
        return this.Workbench.m_7983_();
    }

    public boolean m_6542_(@Nonnull Player player) {
        return this.Workbench.m_6542_(player);
    }

    @Nonnull
    public Pair<Container, Integer> GetSubContainer(int slot) {
        return this.Workbench.GetSubContainer(slot);
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        return this.Workbench.m_8020_(slot);
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int count) {
        return this.Workbench.m_7407_(slot, count);
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        return this.Workbench.m_8016_(slot);
    }

    public void m_6836_(int slot, @Nonnull ItemStack stack) {
        this.Workbench.m_6836_(slot, stack);
    }

    protected void m_183515_(@Nonnull CompoundTag tags) {
        super.m_183515_(tags);
        this.Workbench.save(tags);
    }

    public void m_142466_(@Nonnull CompoundTag tags) {
        super.m_142466_(tags);
        this.Workbench.load(tags);
    }

    @Nonnull
    public Component m_5446_() {
        return DISPLAY_NAME;
    }

    public void m_6211_() {
        this.Workbench.m_6211_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, @Nonnull Inventory inventory, @Nonnull Player player) {
        return this.Workbench.m_7208_(containerID, inventory, player);
    }

    public static void serverTick(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull WorkbenchBlockEntity workbench) {
        if (workbench.Workbench.serverTick(level, pos.m_252807_())) {
            WorkbenchBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    @Nonnull
    public ItemCapabilityMultiContainer SupplyItemCapability(Direction worldSpaceDirection) {
        Direction frontFace = (Direction)this.m_58900_().m_61143_((Property)WorkbenchBlock.DIRECTION);
        Direction frontRelativeDirection = worldSpaceDirection;
        if (worldSpaceDirection == frontFace) {
            frontRelativeDirection = Direction.SOUTH;
        } else if (worldSpaceDirection == frontFace.m_122427_()) {
            frontRelativeDirection = Direction.WEST;
        } else if (worldSpaceDirection == frontFace.m_122428_()) {
            frontRelativeDirection = Direction.EAST;
        } else if (worldSpaceDirection == frontFace.m_122424_()) {
            frontRelativeDirection = Direction.NORTH;
        }
        if (this.Def.sides.length > 0) {
            WorkbenchIOSettingDefinition[] workbenchIOSettingDefinitionArray;
            int n;
            int n2;
            WorkbenchSideDefinition sideDef = this.Def.GetSideDef(frontRelativeDirection);
            if (sideDef != null && (n2 = 0) < (n = (workbenchIOSettingDefinitionArray = sideDef.ioSettings).length)) {
                WorkbenchIOSettingDefinition ioSetting = workbenchIOSettingDefinitionArray[n2];
                return new ItemCapabilityMultiContainer(this.Workbench.GetContainers(ioSetting.type), ioSetting.allowInput, ioSetting.allowExtract);
            }
            return ItemCapabilityMultiContainer.Invalid;
        }
        if (this.Def.partCrafting.isActive || this.Def.gunCrafting.isActive) {
            switch (frontRelativeDirection) {
                case UP: {
                    return new ItemCapabilityMultiContainer(new Container[]{this.Workbench.MaterialContainer, this.Workbench.PartCraftingInputContainer, this.Workbench.GunCraftingInputContainer}, true, true);
                }
                case DOWN: {
                    return new ItemCapabilityMultiContainer(new Container[]{this.Workbench.MaterialContainer, this.Workbench.PartCraftingOutputContainer, this.Workbench.GunCraftingOutputContainer}, true, true);
                }
                case NORTH: {
                    return new ItemCapabilityMultiContainer(new Container[]{this.Workbench.BatteryContainer}, true, true);
                }
                case SOUTH: {
                    return new ItemCapabilityMultiContainer(new Container[]{this.Workbench.FuelContainer}, true, true);
                }
                case EAST: {
                    return new ItemCapabilityMultiContainer(new Container[]{this.Workbench.PartCraftingOutputContainer, this.Workbench.GunCraftingOutputContainer}, false, true);
                }
                case WEST: {
                    return new ItemCapabilityMultiContainer(new Container[]{this.Workbench.PartCraftingInputContainer, this.Workbench.GunCraftingInputContainer}, true, false);
                }
            }
        } else if (this.Def.itemHolding.slots.length > 0) {
            return new ItemCapabilityMultiContainer(new Container[]{this.Workbench.MaterialContainer}, true, true);
        }
        return ItemCapabilityMultiContainer.Invalid;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (side == null) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            LazyOptional<IItemHandler> lazyOptional = this.DirectionalItemCapLazyOptionals.get(side.ordinal());
            if (lazyOptional != null) {
                return lazyOptional.cast();
            }
        } else if (cap == ForgeCapabilities.ENERGY) {
            return this.EnergyStorageLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<IItemHandler> lazy : this.DirectionalItemCapLazyOptionals) {
            lazy.invalidate();
        }
    }

    @Nullable
    public GunFabricationRecipe GetSelectedGunRecipe() {
        return this.f_58857_ != null ? this.Workbench.GetSelectedGunRecipe(this.f_58857_) : null;
    }

    public void UpdateGunCraftingOutputSlot() {
        if (this.f_58857_ != null) {
            this.Workbench.UpdateGunCraftingOutputSlot(this.f_58857_);
        }
    }

    public boolean IsGunCraftingFullyValid() {
        return this.f_58857_ != null && this.Workbench.IsGunCraftingFullyValid(this.f_58857_);
    }

    public void ConsumeGunCraftingInputs() {
        if (this.f_58857_ != null) {
            this.Workbench.ConsumeGunCraftingInputs(this.f_58857_);
        }
    }

    public void QueueCrafting(int count) {
        if (this.f_58857_ != null) {
            this.Workbench.QueueCrafting(this.f_58857_, count);
        }
    }

    public static class ItemCapabilityMultiContainer
    implements IItemHandler {
        public static final ItemCapabilityMultiContainer Invalid = new ItemCapabilityMultiContainer(new Container[0], false, false);
        private final Container[] Containers;
        private final boolean CanInsert;
        private final boolean CanExtract;

        public ItemCapabilityMultiContainer(Container[] containers, boolean canInsert, boolean canExtract) {
            this.Containers = containers;
            this.CanInsert = canInsert;
            this.CanExtract = canExtract;
        }

        public int getSlots() {
            int count = 0;
            for (Container container : this.Containers) {
                count += container.m_6643_();
            }
            return count;
        }

        private ItemStack PutStackInSlot(int slot, ItemStack stack, boolean simulate) {
            if (slot < 0) {
                return stack;
            }
            for (Container container : this.Containers) {
                if (slot < container.m_6643_()) {
                    int maxCount = Maths.min(container.m_6893_(), stack.m_41613_());
                    if (!simulate) {
                        container.m_6836_(slot, stack.m_255036_(maxCount));
                    }
                    return stack.m_255036_(stack.m_41613_() - maxCount);
                }
                slot -= container.m_6643_();
            }
            return stack;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot < 0) {
                return ItemStack.f_41583_;
            }
            for (Container container : this.Containers) {
                if (slot < container.m_6643_()) {
                    return container.m_8020_(slot);
                }
                slot -= container.m_6643_();
            }
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.CanInsert) {
                return stack;
            }
            ItemStack existingStack = this.getStackInSlot(slot);
            if (existingStack.m_41619_()) {
                return this.PutStackInSlot(slot, stack, simulate);
            }
            if (ItemStack.m_41656_((ItemStack)existingStack, (ItemStack)stack)) {
                return this.PutStackInSlot(slot, existingStack.m_255036_(existingStack.m_41613_() + stack.m_41613_()), simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.CanExtract) {
                return ItemStack.f_41583_;
            }
            ItemStack existingStack = this.getStackInSlot(slot);
            if (!existingStack.m_41619_()) {
                int amountToTake = Maths.min(existingStack.m_41613_(), amount);
                ItemStack returnStack = existingStack.m_255036_(amountToTake);
                if (!simulate) {
                    existingStack.m_41764_(existingStack.m_41613_() - amountToTake);
                }
                return returnStack;
            }
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            if (slot < 0) {
                return 0;
            }
            for (Container container : this.Containers) {
                if (slot < container.m_6643_()) {
                    return container.m_6893_();
                }
                slot -= container.m_6643_();
            }
            return 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot < 0) {
                return false;
            }
            for (Container container : this.Containers) {
                if (slot < container.m_6643_()) {
                    return container.m_7013_(slot, stack);
                }
                slot -= container.m_6643_();
            }
            return false;
        }
    }

    public static class WorkbenchBlockEntityTypeHolder
    implements BlockEntityType.BlockEntitySupplier<WorkbenchBlockEntity> {
        private final ResourceLocation DefLoc;

        public WorkbenchBlockEntityTypeHolder(ResourceLocation defLoc) {
            this.DefLoc = defLoc;
        }

        @Nonnull
        public WorkbenchBlockEntity create(@Nonnull BlockPos pos, @Nonnull BlockState state) {
            return new WorkbenchBlockEntity(this.DefLoc, pos, state);
        }

        public BlockEntityType<WorkbenchBlockEntity> CreateType() {
            return new BlockEntityType<WorkbenchBlockEntity>((BlockEntityType.BlockEntitySupplier)this, Set.of(), null){

                public boolean m_155262_(@Nonnull BlockState state) {
                    return state.m_60734_() instanceof WorkbenchBlock;
                }
            };
        }
    }
}

