/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting;

import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.WorkbenchBlockEntity;
import com.flansmod.common.types.crafting.WorkbenchDefinition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class WorkbenchBlock
extends BaseEntityBlock {
    protected static final VoxelShape DEFAULT_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    public static final DirectionProperty DIRECTION = BlockStateProperties.f_61374_;
    private final ResourceLocation definitionLocation;

    public WorkbenchDefinition Def() {
        return (WorkbenchDefinition)FlansMod.WORKBENCHES.Get(this.definitionLocation);
    }

    public WorkbenchBlock(@Nonnull ResourceLocation defLoc, @Nonnull BlockBehaviour.Properties props) {
        super(props);
        this.definitionLocation = defLoc;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return DEFAULT_SHAPE;
    }

    public MenuProvider m_7246_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos) {
        return new SimpleMenuProvider((containerID, inventory, playerEntity) -> {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof WorkbenchBlockEntity) {
                WorkbenchBlockEntity workbenchBlockEntity = (WorkbenchBlockEntity)blockEntity;
                return workbenchBlockEntity.m_7208_(containerID, inventory, playerEntity);
            }
            return null;
        }, (Component)Component.m_237115_((String)"menu.title.flansmod.gun_modification_menu"));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!level.f_46443_ && blockEntity != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this.m_7246_(state, level, pos), (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        BlockEntityType type = (BlockEntityType)ForgeRegistries.BLOCK_ENTITY_TYPES.getValue(this.definitionLocation);
        if (type != null) {
            return type.m_155264_(pos, state);
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIRECTION});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DIRECTION, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return level.f_46443_ ? null : (level1, pos1, state1, blockEntity) -> {
            if (blockEntity instanceof WorkbenchBlockEntity) {
                WorkbenchBlockEntity workbenchBlockEntity = (WorkbenchBlockEntity)blockEntity;
                WorkbenchBlockEntity.serverTick(level1, pos1, state1, workbenchBlockEntity);
            }
        };
    }

    public void m_6810_(@Nonnull BlockState blockState, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean flag) {
        if (!blockState.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof WorkbenchBlockEntity) {
                WorkbenchBlockEntity workbenchBlockEntity = (WorkbenchBlockEntity)blockentity;
                if (level instanceof ServerLevel) {
                    Containers.m_19002_((Level)level, (BlockPos)pos, (Container)workbenchBlockEntity);
                }
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(blockState, level, pos, newState, flag);
        }
    }
}

