/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.crafting;

import com.flansmod.common.FlansMod;
import com.flansmod.common.FlansModConfig;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.crafting.RestrictedContainer;
import com.flansmod.common.crafting.ingredients.StackedIngredient;
import com.flansmod.common.crafting.ingredients.TieredMaterialIngredient;
import com.flansmod.common.crafting.menus.WorkbenchMenuGunCrafting;
import com.flansmod.common.crafting.menus.WorkbenchMenuMaterials;
import com.flansmod.common.crafting.menus.WorkbenchMenuModification;
import com.flansmod.common.crafting.menus.WorkbenchMenuPainting;
import com.flansmod.common.crafting.menus.WorkbenchMenuPartCrafting;
import com.flansmod.common.crafting.menus.WorkbenchMenuPower;
import com.flansmod.common.crafting.recipes.GunFabricationRecipe;
import com.flansmod.common.crafting.recipes.PartFabricationRecipe;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.types.crafting.EWorkbenchInventoryType;
import com.flansmod.common.types.crafting.WorkbenchDefinition;
import com.flansmod.common.types.elements.MaterialSourceDefinition;
import com.flansmod.common.types.elements.PaintableDefinition;
import com.flansmod.common.types.elements.PaintjobDefinition;
import com.flansmod.common.types.magazines.MagazineDefinition;
import com.flansmod.physics.common.util.Maths;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class AbstractWorkbench
implements Container,
Clearable,
MenuProvider {
    public final WorkbenchDefinition Def;
    public final RestrictedContainer GunContainer;
    public final RestrictedContainer PaintCanContainer;
    public final RestrictedContainer MagUpgradeContainer;
    public final RestrictedContainer GunCraftingInputContainer;
    public final RestrictedContainer GunCraftingOutputContainer;
    public final RestrictedContainer PartCraftingInputContainer;
    public final RestrictedContainer PartCraftingOutputContainer;
    public final RestrictedContainer MaterialContainer;
    public final RestrictedContainer BatteryContainer;
    public final RestrictedContainer FuelContainer;
    private EnergyStorage EnergyStorage;
    public static final int NUM_CRAFTING_QUEUE_SLOTS = 4;
    public static final int DATA_LIT_TIME = 0;
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_FORGE_ENERGY = 2;
    public static final int DATA_CRAFT_TIME = 3;
    public static final int DATA_CRAFT_DURATION = 4;
    public static final int DATA_CRAFT_QUEUE_COUNT_0 = 5;
    public static final int DATA_CRAFT_QUEUE_COUNT_MAX = 9;
    public static final int DATA_CRAFT_SELECTION_0 = 10;
    public static final int DATA_CRAFT_SELECTION_MAX = 14;
    public static final int NUM_DATA_MEMBERS = 15;
    public static final int CRAFTING_NOTHING = -1;
    public int LitTime = 0;
    public int LitDuration = 0;
    public int CraftTime = 0;
    public int CraftDuration = 0;
    public int PlayerSelectedCraftingGun = -1;
    public int PlayerSelectedCraftingPart = -1;
    public int[] CraftQueueCount = new int[4];
    public int[] CraftingPart = new int[]{-1, -1, -1, -1};
    private static final Component DISPLAY_NAME = Component.m_237115_((String)"workbench.title");

    public LazyOptional<IEnergyStorage> GetLazyOptionalEnergy() {
        return LazyOptional.of(() -> {
            this.EnergyStorage = new EnergyStorage(this.Def.energy.maxFE);
            return this.EnergyStorage;
        });
    }

    public AbstractWorkbench(@Nonnull WorkbenchDefinition def, @Nonnull Function<Player, Boolean> stillValidFunc) {
        this.Def = def;
        this.GunContainer = this.Def.gunModifying.isActive || this.Def.painting.isActive ? new RestrictedContainer(1, 1, stack -> stack.m_41720_() instanceof GunItem, stillValidFunc) : new RestrictedContainer();
        this.PaintCanContainer = this.Def.painting.isActive ? new RestrictedContainer(1, 64, stack -> stack.m_41720_() == FlansMod.RAINBOW_PAINT_CAN_ITEM.get(), stillValidFunc) : new RestrictedContainer();
        this.MagUpgradeContainer = this.Def.gunModifying.isActive ? new RestrictedContainer(1, 64, stack -> stack.m_41720_() == FlansMod.MAG_UPGRADE_ITEM.get(), stillValidFunc) : new RestrictedContainer();
        if (this.Def.gunCrafting.isActive) {
            this.GunCraftingInputContainer = new RestrictedContainer(this.Def.gunCrafting.maxSlots, 64, stack -> true, stillValidFunc);
            this.GunCraftingOutputContainer = new RestrictedContainer(1, 64, ItemStack::m_41619_, stillValidFunc);
        } else {
            this.GunCraftingInputContainer = new RestrictedContainer();
            this.GunCraftingOutputContainer = new RestrictedContainer();
        }
        if (this.Def.partCrafting.isActive) {
            this.PartCraftingInputContainer = new RestrictedContainer(this.Def.partCrafting.inputSlots, 64, stack -> true, stillValidFunc);
            this.PartCraftingOutputContainer = new RestrictedContainer(this.Def.partCrafting.outputSlots, 64, ItemStack::m_41619_, stillValidFunc);
        } else {
            this.PartCraftingInputContainer = new RestrictedContainer();
            this.PartCraftingOutputContainer = new RestrictedContainer();
        }
        this.MaterialContainer = this.Def.itemHolding.slots.length > 0 ? new RestrictedContainer(this.Def.itemHolding.slots.length, this.Def.itemHolding.maxStackSize, stack -> true, stillValidFunc) : new RestrictedContainer();
        if (this.Def.energy.maxFE > 0) {
            this.EnergyStorage = new EnergyStorage(this.Def.energy.maxFE, this.Def.energy.acceptFEPerTick, this.Def.energy.disperseFEPerTick);
            this.BatteryContainer = new RestrictedContainer(this.Def.energy.numBatterySlots, this.Def.energy.batterySlotStackSize, stack -> stack.getCapability(ForgeCapabilities.ENERGY).isPresent(), stillValidFunc);
            this.FuelContainer = new RestrictedContainer(this.Def.energy.numSolidFuelSlots, 64, stack -> (float)ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0.0f, stillValidFunc);
        } else {
            this.EnergyStorage = null;
            this.BatteryContainer = new RestrictedContainer();
            this.FuelContainer = new RestrictedContainer();
        }
    }

    @Nonnull
    public ContainerData GetDataAccess() {
        return new ContainerData(){

            public int m_6413_(int id) {
                switch (id) {
                    case 0: {
                        return AbstractWorkbench.this.LitTime;
                    }
                    case 1: {
                        return AbstractWorkbench.this.LitDuration;
                    }
                    case 2: {
                        return AbstractWorkbench.this.EnergyStorage == null ? 0 : AbstractWorkbench.this.EnergyStorage.getEnergyStored();
                    }
                    case 3: {
                        return AbstractWorkbench.this.CraftTime;
                    }
                    case 4: {
                        return AbstractWorkbench.this.CraftDuration;
                    }
                }
                if (10 <= id && id < 14) {
                    return AbstractWorkbench.this.CraftingPart[id - 10];
                }
                if (5 <= id && id < 9) {
                    return AbstractWorkbench.this.CraftQueueCount[id - 5];
                }
                return 0;
            }

            public void m_8050_(int id, int value) {
                switch (id) {
                    case 0: {
                        AbstractWorkbench.this.LitTime = value;
                        break;
                    }
                    case 1: {
                        AbstractWorkbench.this.LitDuration = value;
                        break;
                    }
                    case 2: {
                        if (AbstractWorkbench.this.EnergyStorage == null) break;
                        AbstractWorkbench.this.EnergyStorage.receiveEnergy(value - AbstractWorkbench.this.EnergyStorage.getEnergyStored(), false);
                        break;
                    }
                    case 3: {
                        AbstractWorkbench.this.CraftTime = value;
                        break;
                    }
                    case 4: {
                        AbstractWorkbench.this.CraftDuration = value;
                        break;
                    }
                    default: {
                        if (10 <= id && id < 14) {
                            AbstractWorkbench.this.CraftingPart[id - 10] = value;
                        }
                        if (5 > id || id >= 9) break;
                        AbstractWorkbench.this.CraftQueueCount[id - 5] = value;
                    }
                }
            }

            public int m_6499_() {
                return 15;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, @Nonnull Inventory inventory, @Nonnull Player player) {
        if (this.Def.gunCrafting.isActive) {
            return new WorkbenchMenuGunCrafting(containerID, inventory, this);
        }
        if (this.Def.partCrafting.isActive) {
            return new WorkbenchMenuPartCrafting(containerID, inventory, this);
        }
        if (this.Def.gunModifying.isActive) {
            return new WorkbenchMenuModification(containerID, inventory, this);
        }
        if (this.Def.painting.isActive) {
            return new WorkbenchMenuPainting(containerID, inventory, this);
        }
        if ((float)this.Def.energy.maxFE > 0.0f) {
            return new WorkbenchMenuPower(containerID, inventory, this);
        }
        return new WorkbenchMenuMaterials(containerID, inventory, this);
    }

    @Nonnull
    public Component m_5446_() {
        return DISPLAY_NAME;
    }

    public int m_6643_() {
        return this.GunContainer.m_6643_() + this.PaintCanContainer.m_6643_() + this.MagUpgradeContainer.m_6643_() + this.GunCraftingInputContainer.m_6643_() + this.GunCraftingOutputContainer.m_6643_() + this.PartCraftingInputContainer.m_6643_() + this.PartCraftingOutputContainer.m_6643_() + this.MaterialContainer.m_6643_() + this.FuelContainer.m_6643_() + this.BatteryContainer.m_6643_();
    }

    public boolean m_7983_() {
        return this.GunContainer.m_7983_() && this.PaintCanContainer.m_7983_() && this.MagUpgradeContainer.m_7983_() && this.GunCraftingInputContainer.m_7983_() && this.GunCraftingOutputContainer.m_7983_() && this.PartCraftingInputContainer.m_7983_() && this.PartCraftingOutputContainer.m_7983_() && this.MaterialContainer.m_7983_() && this.FuelContainer.m_7983_() && this.BatteryContainer.m_7983_();
    }

    public boolean m_6542_(@Nonnull Player player) {
        return this.GunContainer.m_6542_(player) && this.PaintCanContainer.m_6542_(player) && this.MagUpgradeContainer.m_6542_(player) && this.GunCraftingInputContainer.m_6542_(player) && this.GunCraftingOutputContainer.m_6542_(player) && this.PartCraftingInputContainer.m_6542_(player) && this.PartCraftingOutputContainer.m_6542_(player) && this.MaterialContainer.m_6542_(player) && this.FuelContainer.m_6542_(player) && this.BatteryContainer.m_6542_(player);
    }

    public Pair<Container, Integer> GetSubContainer(int slot) {
        if (slot < this.GunContainer.m_6643_()) {
            return Pair.of((Object)this.GunContainer, (Object)slot);
        }
        if ((slot -= this.GunContainer.m_6643_()) < this.PaintCanContainer.m_6643_()) {
            return Pair.of((Object)this.PaintCanContainer, (Object)slot);
        }
        if ((slot -= this.PaintCanContainer.m_6643_()) < this.MagUpgradeContainer.m_6643_()) {
            return Pair.of((Object)this.MagUpgradeContainer, (Object)slot);
        }
        if ((slot -= this.MagUpgradeContainer.m_6643_()) < this.GunCraftingInputContainer.m_6643_()) {
            return Pair.of((Object)this.GunCraftingInputContainer, (Object)slot);
        }
        if ((slot -= this.GunCraftingInputContainer.m_6643_()) < this.GunCraftingOutputContainer.m_6643_()) {
            return Pair.of((Object)this.GunCraftingOutputContainer, (Object)slot);
        }
        if ((slot -= this.GunCraftingOutputContainer.m_6643_()) < this.PartCraftingInputContainer.m_6643_()) {
            return Pair.of((Object)this.PartCraftingInputContainer, (Object)slot);
        }
        if ((slot -= this.PartCraftingInputContainer.m_6643_()) < this.PartCraftingOutputContainer.m_6643_()) {
            return Pair.of((Object)this.PartCraftingOutputContainer, (Object)slot);
        }
        if ((slot -= this.PartCraftingOutputContainer.m_6643_()) < this.MaterialContainer.m_6643_()) {
            return Pair.of((Object)this.MaterialContainer, (Object)slot);
        }
        if ((slot -= this.MaterialContainer.m_6643_()) < this.FuelContainer.m_6643_()) {
            return Pair.of((Object)this.FuelContainer, (Object)slot);
        }
        if ((slot -= this.FuelContainer.m_6643_()) < this.BatteryContainer.m_6643_()) {
            return Pair.of((Object)this.BatteryContainer, (Object)slot);
        }
        return Pair.of(null, (Object)-1);
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        Pair<Container, Integer> adjustedSlot = this.GetSubContainer(slot);
        if ((Integer)adjustedSlot.getSecond() == -1) {
            return ItemStack.f_41583_;
        }
        return ((Container)adjustedSlot.getFirst()).m_8020_(((Integer)adjustedSlot.getSecond()).intValue());
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int count) {
        Pair<Container, Integer> adjustedSlot = this.GetSubContainer(slot);
        if ((Integer)adjustedSlot.getSecond() == -1) {
            return ItemStack.f_41583_;
        }
        return ((Container)adjustedSlot.getFirst()).m_7407_(((Integer)adjustedSlot.getSecond()).intValue(), count);
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        Pair<Container, Integer> adjustedSlot = this.GetSubContainer(slot);
        if ((Integer)adjustedSlot.getSecond() == -1) {
            return ItemStack.f_41583_;
        }
        return ((Container)adjustedSlot.getFirst()).m_8016_(((Integer)adjustedSlot.getSecond()).intValue());
    }

    public void m_6836_(int slot, @Nonnull ItemStack stack) {
        Pair<Container, Integer> adjustedSlot = this.GetSubContainer(slot);
        if ((Integer)adjustedSlot.getSecond() != -1) {
            ((Container)adjustedSlot.getFirst()).m_6836_(((Integer)adjustedSlot.getSecond()).intValue(), stack);
        }
    }

    public void m_6596_() {
    }

    public void m_6211_() {
        for (Container container : this.GetContainers(EWorkbenchInventoryType.AllTypes)) {
            container.m_6211_();
        }
    }

    @Nonnull
    public Container[] GetContainers(@Nonnull EWorkbenchInventoryType type) {
        Container[] containerArray;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case PartInput: {
                Container[] containerArray2 = new Container[1];
                containerArray = containerArray2;
                containerArray2[0] = this.PartCraftingInputContainer;
                break;
            }
            case PartOutput: {
                Container[] containerArray3 = new Container[1];
                containerArray = containerArray3;
                containerArray3[0] = this.PartCraftingOutputContainer;
                break;
            }
            case GunInput: {
                Container[] containerArray4 = new Container[1];
                containerArray = containerArray4;
                containerArray4[0] = this.GunCraftingInputContainer;
                break;
            }
            case GunOutput: {
                Container[] containerArray5 = new Container[1];
                containerArray = containerArray5;
                containerArray5[0] = this.GunCraftingOutputContainer;
                break;
            }
            case Material: {
                Container[] containerArray6 = new Container[1];
                containerArray = containerArray6;
                containerArray6[0] = this.MaterialContainer;
                break;
            }
            case Fuel: {
                Container[] containerArray7 = new Container[1];
                containerArray = containerArray7;
                containerArray7[0] = this.FuelContainer;
                break;
            }
            case Power: {
                Container[] containerArray8 = new Container[1];
                containerArray = containerArray8;
                containerArray8[0] = this.BatteryContainer;
                break;
            }
            case GunModification: {
                Container[] containerArray9 = new Container[1];
                containerArray = containerArray9;
                containerArray9[0] = this.GunContainer;
                break;
            }
            case Attachment: {
                Container[] containerArray10 = new Container[1];
                containerArray = containerArray10;
                containerArray10[0] = this.GunContainer;
                break;
            }
            case PaintCan: {
                Container[] containerArray11 = new Container[1];
                containerArray = containerArray11;
                containerArray11[0] = this.PaintCanContainer;
                break;
            }
            case MagUpgrade: {
                Container[] containerArray12 = new Container[1];
                containerArray = containerArray12;
                containerArray12[0] = this.MagUpgradeContainer;
                break;
            }
            case AllTypes: {
                Container[] containerArray13 = new Container[10];
                containerArray13[0] = this.PartCraftingInputContainer;
                containerArray13[1] = this.PartCraftingOutputContainer;
                containerArray13[2] = this.GunCraftingInputContainer;
                containerArray13[3] = this.GunCraftingOutputContainer;
                containerArray13[4] = this.MaterialContainer;
                containerArray13[5] = this.FuelContainer;
                containerArray13[6] = this.BatteryContainer;
                containerArray13[7] = this.GunContainer;
                containerArray13[8] = this.PaintCanContainer;
                containerArray = containerArray13;
                containerArray13[9] = this.MagUpgradeContainer;
            }
        }
        return containerArray;
    }

    public void save(@Nonnull CompoundTag tags) {
        tags.m_128365_("gun", (Tag)this.GunContainer.save(new CompoundTag()));
        tags.m_128365_("paintcans", (Tag)this.PaintCanContainer.save(new CompoundTag()));
        tags.m_128365_("magupgrades", (Tag)this.MagUpgradeContainer.save(new CompoundTag()));
        tags.m_128365_("gun_input", (Tag)this.GunCraftingInputContainer.save(new CompoundTag()));
        tags.m_128365_("gun_output", (Tag)this.GunCraftingOutputContainer.save(new CompoundTag()));
        tags.m_128365_("part_input", (Tag)this.PartCraftingInputContainer.save(new CompoundTag()));
        tags.m_128365_("part_output", (Tag)this.PartCraftingOutputContainer.save(new CompoundTag()));
        tags.m_128365_("materials", (Tag)this.MaterialContainer.save(new CompoundTag()));
        tags.m_128365_("battery", (Tag)this.BatteryContainer.save(new CompoundTag()));
        tags.m_128365_("fuel", (Tag)this.FuelContainer.save(new CompoundTag()));
        if (this.EnergyStorage != null) {
            tags.m_128365_("energy", this.EnergyStorage.serializeNBT());
        }
        tags.m_128405_("lit_time", this.LitTime);
        tags.m_128405_("lit_duration", this.LitDuration);
        for (int i = 0; i < 4; ++i) {
            tags.m_128405_("craft_queue_" + i, this.CraftQueueCount[i]);
            tags.m_128405_("craft_selection_" + i, this.CraftingPart[i]);
        }
        tags.m_128405_("craft_duration", this.CraftDuration);
        tags.m_128405_("craft_time", this.CraftTime);
    }

    public void load(@Nonnull CompoundTag tags) {
        this.GunContainer.load(tags.m_128469_("gun"));
        this.PaintCanContainer.load(tags.m_128469_("paintcans"));
        this.MagUpgradeContainer.load(tags.m_128469_("magupgrades"));
        this.GunCraftingInputContainer.load(tags.m_128469_("gun_input"));
        this.GunCraftingOutputContainer.load(tags.m_128469_("gun_output"));
        this.PartCraftingInputContainer.load(tags.m_128469_("part_input"));
        this.PartCraftingOutputContainer.load(tags.m_128469_("part_output"));
        this.MaterialContainer.load(tags.m_128469_("materials"));
        this.BatteryContainer.load(tags.m_128469_("battery"));
        this.FuelContainer.load(tags.m_128469_("fuel"));
        if (this.EnergyStorage != null) {
            this.EnergyStorage.deserializeNBT((Tag)tags.m_128469_("energy"));
        }
        this.LitTime = tags.m_128451_("lit_time");
        this.LitDuration = tags.m_128451_("lit_duration");
        this.CraftDuration = tags.m_128451_("craft_duration");
        this.CraftTime = tags.m_128451_("craft_time");
        for (int i = 0; i < 4; ++i) {
            this.CraftQueueCount[i] = tags.m_128451_("craft_queue_" + i);
            this.CraftingPart[i] = tags.m_128451_("craft_selection_" + i);
            if (this.CraftQueueCount[i] != 0) continue;
            this.CraftingPart[i] = -1;
        }
    }

    public boolean serverTick(@Nullable Level level, @Nullable Vec3 pos) {
        boolean changed = false;
        if (this.EnergyStorage != null) {
            int burnTime;
            if (this.LitTime > 0) {
                --this.LitTime;
                this.EnergyStorage.receiveEnergy(this.Def.energy.solidFEPerFuelTime, false);
                if (this.LitTime <= 0) {
                    this.LitDuration = 0;
                    changed = true;
                }
            }
            if (this.LitTime <= 0 && this.EnergyStorage.getEnergyStored() < this.EnergyStorage.getMaxEnergyStored() && this.FuelContainer.m_6643_() > 0 && (burnTime = ForgeHooks.getBurnTime((ItemStack)this.FuelContainer.m_8020_(0), (RecipeType)RecipeType.f_44108_)) > 0) {
                this.FuelContainer.m_7407_(0, 1);
                this.LitDuration = burnTime;
                this.LitTime = burnTime;
                changed = true;
            }
        }
        if (level != null && this.PartCraftingOutputContainer.m_6643_() > 0) {
            if (this.CraftTime > 0) {
                --this.CraftTime;
                if (this.CraftTime <= 0) {
                    this.CraftDuration = 0;
                    boolean success = this.CraftOnePart(level, pos != null ? pos : Vec3.f_82478_);
                    if (success) {
                        changed = true;
                    }
                }
            }
            if (this.CraftTime <= 0) {
                if (this.CraftQueueCount[0] == 0) {
                    for (int i = 0; i < 3; ++i) {
                        this.CraftQueueCount[i] = this.CraftQueueCount[i + 1];
                        this.CraftingPart[i] = this.CraftingPart[i + 1];
                    }
                    this.CraftQueueCount[3] = 0;
                    this.CraftingPart[3] = -1;
                }
                if (this.CraftQueueCount[0] != 0) {
                    int inputCount = this.GetMaxPartsCraftableFromInput(level, this.CraftingPart[0]);
                    boolean canOutput = this.GetOutputSlotToCraftPart(level) != -1;
                    boolean canPower = true;
                    if (this.Def.partCrafting.FECostPerCraft > 0.0f) {
                        boolean bl = canPower = (float)this.EnergyStorage.getEnergyStored() >= this.Def.partCrafting.FECostPerCraft;
                    }
                    if (inputCount > 0 && canOutput && canPower) {
                        this.CraftDuration = this.CraftTime = Maths.floor(this.Def.partCrafting.timePerCraft * 20.0f);
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }

    public boolean GunRecipeCanBeCraftedInThisWorkbench(@Nonnull ItemStack output) {
        if (!((Boolean)FlansModConfig.AllowGunCrafting.get()).booleanValue()) {
            return false;
        }
        if (this.Def.gunCrafting.isActive) {
            for (ItemStack stack : this.Def.gunCrafting.GetAllOutputs()) {
                if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)output)) continue;
                return true;
            }
        }
        return false;
    }

    public int GetSelectedGunRecipeIndex() {
        return this.PlayerSelectedCraftingGun;
    }

    public void SelectGunCraftingRecipe(@Nonnull Level level, int recipeIndex) {
        this.PlayerSelectedCraftingGun = 0 <= recipeIndex ? recipeIndex : -1;
        this.UpdateGunCraftingOutputSlot(level);
    }

    @Nullable
    public GunFabricationRecipe GetSelectedGunRecipe(@Nonnull Level level) {
        List<GunFabricationRecipe> recipes = this.GetAllGunRecipes(level);
        int recipeIndex = this.GetSelectedGunRecipeIndex();
        if (recipeIndex == -1 || recipeIndex >= recipes.size()) {
            return null;
        }
        return recipes.get(recipeIndex);
    }

    @Nonnull
    public List<GunFabricationRecipe> GetAllGunRecipes(@Nonnull Level level) {
        return this.Def.gunCrafting.GetAllRecipes(level);
    }

    public boolean MatchesGunRecipe(@Nonnull Level level, int recipeIndex) {
        List<GunFabricationRecipe> recipes = this.GetAllGunRecipes(level);
        if (recipeIndex == -1 || recipeIndex >= recipes.size()) {
            return false;
        }
        return recipes.get(recipeIndex).matches(this, level);
    }

    public boolean MatchesGunRecipe(@Nonnull Level level, @Nonnull GunFabricationRecipe recipe) {
        return recipe.matches(this, level);
    }

    public void AutoFillGunCraftingInputSlot(@Nonnull Player player, int ingredientIndex) {
        GunFabricationRecipe currentRecipe = this.GetSelectedGunRecipe(player.m_9236_());
        if (currentRecipe != null && 0 <= ingredientIndex && ingredientIndex < currentRecipe.InputIngredients.size()) {
            ItemStack stackInSlot = this.GunCraftingInputContainer.m_8020_(ingredientIndex);
            Ingredient ingredient = (Ingredient)currentRecipe.InputIngredients.get(ingredientIndex);
            boolean creative = player.m_7500_();
            if (creative) {
                ItemStack[] possibleItems = ingredient.m_43908_();
                if (possibleItems.length > 0) {
                    int existingIndex = -1;
                    for (int i = 0; i < possibleItems.length; ++i) {
                        if (!ItemStack.m_150942_((ItemStack)stackInSlot, (ItemStack)possibleItems[i])) continue;
                        existingIndex = i;
                    }
                    this.GunCraftingInputContainer.m_6836_(ingredientIndex, possibleItems[(existingIndex + 1) % possibleItems.length].m_41777_());
                    this.UpdateGunCraftingOutputSlot(player.m_9236_());
                }
            } else {
                int foundMatch = -1;
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    if (!ingredient.test(player.m_150109_().m_8020_(i))) continue;
                    foundMatch = i;
                    break;
                }
                if (foundMatch != -1) {
                    ItemStack playerStack = player.m_150109_().m_8020_(foundMatch);
                    ItemStack stackToAdd = playerStack.m_255036_(1);
                    boolean slotIsEmpty = stackInSlot.m_41619_();
                    if (!slotIsEmpty && player.m_150109_().m_36054_(stackInSlot.m_41777_())) {
                        this.GunCraftingInputContainer.m_6836_(ingredientIndex, ItemStack.f_41583_);
                        slotIsEmpty = true;
                    }
                    if (slotIsEmpty) {
                        this.GunCraftingInputContainer.m_6836_(ingredientIndex, stackToAdd);
                        player.m_150109_().m_7407_(foundMatch, 1);
                        this.UpdateGunCraftingOutputSlot(player.m_9236_());
                    }
                }
            }
        }
    }

    @Nonnull
    public List<GunFabricationRecipe> GetMatchingGunRecipes(@Nonnull Level level) {
        List<GunFabricationRecipe> all = this.GetAllGunRecipes(level);
        ArrayList<GunFabricationRecipe> matching = new ArrayList<GunFabricationRecipe>();
        for (GunFabricationRecipe gunFabricationRecipe : all) {
            if (!this.MatchesGunRecipe(level, gunFabricationRecipe)) continue;
            matching.add(gunFabricationRecipe);
        }
        return matching;
    }

    public boolean IsGunCraftingSlotValid(@Nonnull Level level, int ingredientIndex) {
        if (ingredientIndex < 0) {
            return false;
        }
        GunFabricationRecipe recipe = this.GetSelectedGunRecipe(level);
        if (recipe == null) {
            return false;
        }
        if (ingredientIndex >= recipe.InputIngredients.size() || ingredientIndex >= this.GunCraftingInputContainer.m_6643_()) {
            return false;
        }
        return ((Ingredient)recipe.InputIngredients.get(ingredientIndex)).test(this.GunCraftingInputContainer.m_8020_(ingredientIndex));
    }

    public boolean IsGunCraftingFullyValid(@Nonnull Level level) {
        if (!((Boolean)FlansModConfig.AllowGunCrafting.get()).booleanValue()) {
            return false;
        }
        GunFabricationRecipe recipe = this.GetSelectedGunRecipe(level);
        if (recipe == null) {
            return false;
        }
        for (int i = 0; i < recipe.InputIngredients.size(); ++i) {
            if (this.IsGunCraftingSlotValid(level, i)) continue;
            return false;
        }
        return true;
    }

    public void ConsumeGunCraftingInputs(@Nonnull Level level) {
        GunFabricationRecipe recipe = this.GetSelectedGunRecipe(level);
        if (recipe != null) {
            for (int i = 0; i < recipe.InputIngredients.size(); ++i) {
                ItemStack stack = this.GunCraftingInputContainer.m_8020_(i);
                stack.m_41764_(stack.m_41613_() - 1);
            }
        }
    }

    public void UpdateGunCraftingOutputSlot(@Nonnull Level level) {
        if (this.IsGunCraftingFullyValid(level)) {
            GunFabricationRecipe recipe = this.GetSelectedGunRecipe(level);
            if (recipe != null) {
                ItemStack output = recipe.assemble(this, (RegistryAccess)RegistryAccess.f_243945_);
                this.GunCraftingOutputContainer.m_6836_(0, output);
            } else {
                FlansMod.LOGGER.error("We think gun crafting is valid, but no recipe selection exists");
            }
        } else {
            this.GunCraftingOutputContainer.m_6836_(0, ItemStack.f_41583_);
        }
    }

    public boolean PartRecipeCanBeCraftedInThisWorkbench(@Nonnull ItemStack output) {
        if (this.Def.partCrafting.isActive) {
            for (ItemStack stack : this.Def.partCrafting.GetAllOutputs()) {
                if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)output)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public List<PartFabricationRecipe> GetAllPartRecipes(@Nonnull Level level) {
        return this.Def.partCrafting.GetAllRecipes(level);
    }

    public void SelectPartCraftingRecipe(@Nonnull Level level, int index) {
        this.PlayerSelectedCraftingPart = 0 <= index && index < this.GetAllPartRecipes(level).size() ? index : -1;
    }

    public int GetMaxPartsCraftableFromInput(@Nonnull Level level, int recipeIndex) {
        if (!((Boolean)FlansModConfig.AllowPartCrafting.get()).booleanValue()) {
            return 0;
        }
        if (recipeIndex == -1) {
            return 0;
        }
        if (recipeIndex >= this.GetAllPartRecipes(level).size()) {
            return 0;
        }
        PartFabricationRecipe recipe = this.GetAllPartRecipes(level).get(recipeIndex);
        if (recipe == null) {
            return 0;
        }
        int lowestMatch = Integer.MAX_VALUE;
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            int required;
            Ingredient ingredient = (Ingredient)recipe.m_7527_().get(i);
            int matching = this.CountInputMatching(ingredient);
            if (ingredient instanceof StackedIngredient) {
                StackedIngredient stacked = (StackedIngredient)ingredient;
                required = stacked.Count;
            } else {
                required = 1;
            }
            int maxProduction = matching / required;
            if (maxProduction >= lowestMatch) continue;
            lowestMatch = maxProduction;
        }
        return Maths.clamp(lowestMatch, 0, 999);
    }

    public int[] GetQuantityOfEachIngredientForRecipe(@Nonnull Level level, int recipeIndex) {
        if (recipeIndex == -1 || recipeIndex >= this.GetAllPartRecipes(level).size()) {
            return new int[0];
        }
        PartFabricationRecipe recipe = this.GetAllPartRecipes(level).get(recipeIndex);
        return recipe == null ? new int[]{} : recipe.GetMatchingOfEachIngredient(this.PartCraftingInputContainer);
    }

    public int[] GetRequiredOfEachIngredientForRecipe(@Nonnull Level level, int recipeIndex) {
        if (recipeIndex == -1 || recipeIndex >= this.GetAllPartRecipes(level).size()) {
            return new int[0];
        }
        PartFabricationRecipe recipe = this.GetAllPartRecipes(level).get(recipeIndex);
        return recipe == null ? new int[]{} : recipe.GetRequiredOfEachIngredient();
    }

    public int GetOutputSlotToCraftPart(@Nonnull Level level) {
        int i;
        if (this.CraftingPart[0] == -1) {
            return -1;
        }
        if (this.CraftingPart[0] >= this.GetAllPartRecipes(level).size()) {
            return -1;
        }
        PartFabricationRecipe recipe = this.GetAllPartRecipes(level).get(this.CraftingPart[0]);
        if (recipe == null) {
            return 0;
        }
        ItemStack result = recipe.Result;
        for (i = 0; i < this.PartCraftingOutputContainer.m_6643_(); ++i) {
            ItemStack stackInSlot = this.PartCraftingOutputContainer.m_8020_(i);
            if (!ItemStack.m_41656_((ItemStack)result, (ItemStack)stackInSlot) || stackInSlot.m_41613_() >= this.PartCraftingOutputContainer.m_6893_()) continue;
            return i;
        }
        for (i = 0; i < this.PartCraftingOutputContainer.m_6643_(); ++i) {
            if (!this.PartCraftingOutputContainer.m_8020_(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void QueueCrafting(@Nonnull Level level, int count) {
        for (int i = 0; i < 4; ++i) {
            if (this.CraftingPart[i] != this.PlayerSelectedCraftingPart && this.CraftingPart[i] != -1) continue;
            this.CraftingPart[i] = this.PlayerSelectedCraftingPart;
            if (count == -1) {
                this.CraftQueueCount[i] = -1;
                return;
            }
            int n = i;
            this.CraftQueueCount[n] = this.CraftQueueCount[n] + count;
            return;
        }
    }

    public void CancelQueue(int index) {
        if (0 <= index && index < 4) {
            int n = this.CraftQueueCount[index] = index == 0 && this.CraftDuration > 0 ? 1 : 0;
            if (index > 0) {
                for (int i = index; i < 3; ++i) {
                    this.CraftQueueCount[i] = this.CraftQueueCount[i + 1];
                    this.CraftingPart[i] = this.CraftingPart[i + 1];
                }
                this.CraftingPart[3] = -1;
                this.CraftQueueCount[3] = 0;
            }
        }
    }

    public int CountInputMatching(Ingredient ingredient) {
        int count = 0;
        for (int i = 0; i < this.PartCraftingInputContainer.m_6643_(); ++i) {
            ItemStack stack = this.PartCraftingInputContainer.m_8020_(i);
            if (ingredient instanceof StackedIngredient) {
                StackedIngredient stackedIngredient = (StackedIngredient)ingredient;
                count += stackedIngredient.Count(stack);
                continue;
            }
            if (!ingredient.test(stack)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private void ConsumeIngredient(@Nonnull Level level, @Nonnull Vec3 pos, Ingredient ingredient) {
        if (ingredient instanceof TieredMaterialIngredient) {
            TieredMaterialIngredient tiered = (TieredMaterialIngredient)ingredient;
            int count = 0;
            for (int i = 0; i < this.PartCraftingInputContainer.m_6643_(); ++i) {
                int matchCount = tiered.Count(this.PartCraftingInputContainer.m_8020_(i));
                if (matchCount <= 0) continue;
                count += matchCount;
                this.PartCraftingInputContainer.m_6836_(i, ItemStack.f_41583_);
            }
            int countAfterConsume = count - tiered.Count;
            List<Pair<MaterialSourceDefinition, Integer>> refundSplit = tiered.MaterialType().ResolveAmount(countAfterConsume);
            for (Pair<MaterialSourceDefinition, Integer> kvp : refundSplit) {
                if (((MaterialSourceDefinition)kvp.getFirst()).GetMatches().size() > 0) {
                    ItemStack leftover = this.TryAddStackToCraftingInput(((MaterialSourceDefinition)kvp.getFirst()).GetMatches().get(0).m_255036_(((Integer)kvp.getSecond()).intValue()));
                    if (leftover.m_41619_()) continue;
                    ItemEntity leftoverEntity = new ItemEntity(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, leftover);
                    level.m_7967_((Entity)leftoverEntity);
                    continue;
                }
                FlansMod.LOGGER.error("Could not refund " + kvp.getSecond() + "x " + kvp.getFirst());
            }
        }
    }

    private ItemStack TryAddStackToCraftingInput(ItemStack stack) {
        int maxStack = this.PartCraftingInputContainer.m_6893_();
        for (int i = 0; i < this.PartCraftingInputContainer.m_6643_(); ++i) {
            int countToAdd;
            ItemStack stackInSlot = this.PartCraftingInputContainer.m_8020_(i);
            if (stackInSlot.m_41619_()) {
                if (stack.m_41613_() > maxStack) {
                    this.PartCraftingInputContainer.m_6836_(i, stack.m_255036_(maxStack));
                    stack.m_41764_(stack.m_41613_() - maxStack);
                } else {
                    this.PartCraftingInputContainer.m_6836_(i, stack.m_41777_());
                    stack.m_41764_(0);
                }
            } else if (ItemStack.m_41656_((ItemStack)stackInSlot, (ItemStack)stack) && (countToAdd = Maths.min(stack.m_41613_(), maxStack - stackInSlot.m_41613_())) > 0) {
                stackInSlot.m_41764_(stackInSlot.m_41613_() + countToAdd);
                stack.m_41764_(stack.m_41613_() - countToAdd);
            }
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public boolean CraftOnePart(@Nonnull Level level, @Nonnull Vec3 pos) {
        if (!((Boolean)FlansModConfig.AllowPartCrafting.get()).booleanValue()) {
            return false;
        }
        int outputSlot = this.GetOutputSlotToCraftPart(level);
        if (outputSlot != -1) {
            PartFabricationRecipe recipe = this.GetAllPartRecipes(level).get(this.CraftingPart[0]);
            for (Ingredient ingredient : recipe.m_7527_()) {
                this.ConsumeIngredient(level, pos, ingredient);
            }
            if (this.CraftQueueCount[0] > 0) {
                this.CraftQueueCount[0] = this.CraftQueueCount[0] - 1;
            }
            ItemStack result = recipe.Result;
            ItemStack existing = this.PartCraftingOutputContainer.m_8020_(outputSlot);
            if (existing.m_41619_()) {
                this.PartCraftingOutputContainer.m_6836_(outputSlot, result.m_41777_());
            } else if (ItemStack.m_41656_((ItemStack)existing, (ItemStack)result)) {
                existing.m_41764_(existing.m_41613_() + result.m_41613_());
            } else {
                FlansMod.LOGGER.error("CraftOnePart tried to craft into invalid slot " + outputSlot);
            }
            level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_12010_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static int GetPaintUpgradeCost(Container gunContainer, int paintIndex) {
        FlanItem flanItem;
        PaintableDefinition paintableDefinition;
        int additionalCost = (Integer)FlansModConfig.AdditionalMagazineModifyCost.get();
        if (gunContainer.m_6643_() <= 0) {
            return 0;
        }
        if (paintIndex == 0) {
            return 0;
        }
        Item item = gunContainer.m_8020_(0).m_41720_();
        if (item instanceof FlanItem && (paintableDefinition = (flanItem = (FlanItem)item).GetPaintDef()).IsValid() && 0 <= paintIndex - 1 && paintIndex - 1 < paintableDefinition.paintjobs.length) {
            return paintableDefinition.paintjobs[paintIndex - 1].paintBucketsRequired + additionalCost;
        }
        return 0;
    }

    public static boolean CanPaintGun(Player player, Container gunContainer, Container paintCanContainer, int skinIndex) {
        if (!((Boolean)FlansModConfig.AllowPainting.get()).booleanValue()) {
            return false;
        }
        int additionalCost = (Integer)FlansModConfig.AdditionalPaintCanCost.get();
        if (skinIndex < 0) {
            return false;
        }
        if (gunContainer.m_6643_() <= 0) {
            return false;
        }
        if (gunContainer.m_8020_(0).m_41619_()) {
            return false;
        }
        Item item = gunContainer.m_8020_(0).m_41720_();
        if (item instanceof FlanItem) {
            FlanItem flanItem = (FlanItem)item;
            if (skinIndex == 0) {
                return true;
            }
            PaintableDefinition paintableDefinition = flanItem.GetPaintDef();
            if (!paintableDefinition.IsValid()) {
                return false;
            }
            if (skinIndex >= paintableDefinition.paintjobs.length + 1) {
                return false;
            }
            PaintjobDefinition paintjobDefinition = paintableDefinition.paintjobs[skinIndex - 1];
            if (paintjobDefinition == null) {
                return false;
            }
            if (!paintjobDefinition.entitlementKey.isEmpty()) {
                // empty if block
            }
            if (player.m_7500_()) {
                return true;
            }
            int paintCost = paintjobDefinition.paintBucketsRequired + additionalCost;
            return paintCanContainer.m_8020_(0).m_41613_() >= paintCost;
        }
        return false;
    }

    public void PaintGun(@Nonnull Player player, int skinIndex) {
        AbstractWorkbench.PaintGun(player, this.GunContainer, this.PaintCanContainer, skinIndex);
    }

    public static void PaintGun(@Nonnull Player player, @Nonnull Container gunContainer, @Nonnull Container paintCanContainer, int skinIndex) {
        PaintableDefinition paintableDefinition;
        GunContext gunContext;
        if (AbstractWorkbench.CanPaintGun(player, gunContainer, paintCanContainer, skinIndex) && gunContainer.m_6643_() > 0 && !gunContainer.m_8020_(0).m_41619_() && gunContainer.m_8020_(0).m_41720_() instanceof FlanItem && (gunContext = GunContext.of(gunContainer, 0, player.m_9236_().f_46443_)).IsValid() && (paintableDefinition = gunContext.Def.paints).IsValid()) {
            if (skinIndex == 0) {
                gunContext.SetPaintjobName("default");
            } else {
                PaintjobDefinition paintjobDefinition = paintableDefinition.paintjobs[skinIndex - 1];
                paintCanContainer.m_8020_(0).m_41764_(paintCanContainer.m_8020_(0).m_41613_() - paintjobDefinition.paintBucketsRequired);
                gunContext.SetPaintjobName(paintjobDefinition.textureName);
            }
        }
    }

    public static int GetMagUpgradeCost(@Nonnull Container gunContainer, int magIndex) {
        int additionalCost = (Integer)FlansModConfig.AdditionalMagazineModifyCost.get();
        if (gunContainer.m_6643_() <= 0) {
            return 0;
        }
        Item item = gunContainer.m_8020_(0).m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            List<MagazineDefinition> mags = gunItem.Def().GetMagazineSettings("primary_fire").GetMatchingMagazines();
            if (0 <= magIndex && magIndex < mags.size()) {
                return gunItem.Def().GetMagazineSettings((String)"primary_fire").baseCostToSwap + mags.get((int)magIndex).upgradeCost + additionalCost;
            }
            return gunItem.Def().GetMagazineSettings((String)"primary_fire").baseCostToSwap + additionalCost;
        }
        return 0;
    }

    public static boolean CanSelectMagazine(@Nonnull Player player, @Nonnull Container gunContainer, @Nonnull Container magUpgradeContainer, int magIndex) {
        if (!((Boolean)FlansModConfig.AllowMagazineModifying.get()).booleanValue()) {
            return false;
        }
        int additionalCost = (Integer)FlansModConfig.AdditionalMagazineModifyCost.get();
        if (magIndex < 0) {
            return false;
        }
        if (gunContainer.m_6643_() <= 0) {
            return false;
        }
        if (gunContainer.m_8020_(0).m_41619_()) {
            return false;
        }
        Item item = gunContainer.m_8020_(0).m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            ItemStack gunStack = gunContainer.m_8020_(0);
            List<MagazineDefinition> mags = gunItem.Def().GetMagazineSettings("primary_fire").GetMatchingMagazines();
            if (magIndex >= mags.size()) {
                return false;
            }
            MagazineDefinition mag = mags.get(magIndex);
            if (!mag.IsValid()) {
                return false;
            }
            if (player.m_7500_()) {
                return true;
            }
            int magCost = additionalCost + mag.upgradeCost + gunItem.Def().GetMagazineSettings((String)"primary_fire").baseCostToSwap;
            return magUpgradeContainer.m_8020_(0).m_41613_() >= magCost;
        }
        return false;
    }

    public void SelectMagazine(@Nonnull Player player, int magIndex) {
        AbstractWorkbench.SelectMagazine(player, this.GunContainer, this.MagUpgradeContainer, magIndex);
    }

    public static void SelectMagazine(@Nonnull Player player, @Nonnull Container gunContainer, @Nonnull Container magUpgradeContainer, int magIndex) {
        Item item;
        if (AbstractWorkbench.CanSelectMagazine(player, gunContainer, magUpgradeContainer, magIndex) && gunContainer.m_6643_() > 0 && !gunContainer.m_8020_(0).m_41619_() && (item = gunContainer.m_8020_(0).m_41720_()) instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            GunContext gunContext = GunContext.of(gunContainer, 0, player.m_9236_().f_46443_);
            if (gunContext.IsValid()) {
                List<MagazineDefinition> mags = gunItem.Def().GetMagazineSettings("primary_fire").GetMatchingMagazines();
                if (0 <= magIndex && magIndex < mags.size()) {
                    int magCost = mags.get((int)magIndex).upgradeCost + gunItem.Def().GetMagazineSettings((String)"primary_fire").baseCostToSwap;
                    magUpgradeContainer.m_8020_(0).m_41764_(magUpgradeContainer.m_8020_(0).m_41613_() - magCost);
                    gunContext.GetActionGroupContext("primary_fire").SetMagazineType(0, mags.get(magIndex));
                } else {
                    FlansMod.LOGGER.warn(player.m_7755_().getString() + " tried to set mag index " + magIndex + " on gun (" + gunItem.Def().Location + ") with only " + mags.size() + " mag options");
                }
            }
        }
    }
}

