/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.stats;

import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.Lazy;

public class StatCalculationContext {
    public final int Level;
    public final int StackCount;
    public final Lazy<Integer> NumAttachments;
    public final Lazy<Float> MagFullnessRatio;

    private StatCalculationContext(int level, int stackCount, @Nonnull Lazy<Integer> numAttachments, @Nonnull Lazy<Float> magFullnessRatio) {
        this.Level = level;
        this.StackCount = stackCount;
        this.NumAttachments = numAttachments;
        this.MagFullnessRatio = magFullnessRatio;
    }

    @Nonnull
    public static StatCalculationContext of(@Nonnull ShooterContext shooter) {
        return new StatCalculationContext(0, 0, (Lazy<Integer>)Lazy.of(() -> 0), (Lazy<Float>)Lazy.of(() -> Float.valueOf(0.0f)));
    }

    @Nonnull
    public static StatCalculationContext of(@Nonnull GunContext gun) {
        return StatCalculationContext.of(0, 0, gun);
    }

    @Nonnull
    public static StatCalculationContext of(@Nonnull GunContext gun, @Nullable AbilityStack stacks) {
        if (stacks != null) {
            return StatCalculationContext.of(stacks.Level, stacks.GetStackCount(), gun);
        }
        return StatCalculationContext.of(0, 0, gun);
    }

    @Nonnull
    public static StatCalculationContext of(int level, int stackCount, @Nonnull GunContext gun) {
        return new StatCalculationContext(level, stackCount, (Lazy<Integer>)Lazy.of(gun::GetNumAttachments), (Lazy<Float>)Lazy.of(() -> {
            ActionGroupContext groupContext = gun.GetActionGroupContext("primary_fire");
            if (groupContext.IsValid()) {
                return Float.valueOf(groupContext.GetMagFullnessRatio(0));
            }
            return Float.valueOf(0.0f);
        }));
    }
}

