/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.stats;

import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.stats.IModifierBaker;
import com.flansmod.common.actions.stats.StatAccumulator;
import com.flansmod.common.types.elements.ModifierDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class ModifierCache
implements IModifierBaker {
    private boolean IsCurrent = false;
    private final Map<String, StatAccumulator> ModifierFormulae = new HashMap<String, StatAccumulator>();
    private final Map<String, String> StringOverrides = new HashMap<String, String>();
    private final Consumer<IModifierBaker> BakeFunc;

    public ModifierCache(@Nonnull Consumer<IModifierBaker> bakeFunc) {
        this.BakeFunc = bakeFunc;
    }

    public boolean IsUpToDate() {
        return this.IsCurrent;
    }

    public void CheckBake() {
        if (!this.IsCurrent) {
            this.Clear();
            this.BakeFunc.accept(this);
            this.IsCurrent = true;
        }
    }

    @Nonnull
    public StatAccumulator GetModifierFormula(@Nonnull String stat) {
        this.CheckBake();
        return this.ModifierFormulae.getOrDefault(stat, StatAccumulator.EmptyAccumulator);
    }

    @Nonnull
    public Optional<String> GetStringOverride(@Nonnull String stat) {
        this.CheckBake();
        return Optional.ofNullable(this.StringOverrides.get(stat));
    }

    public void Clear() {
        this.ModifierFormulae.clear();
        this.StringOverrides.clear();
        this.IsCurrent = false;
    }

    @Override
    public void Bake(@Nonnull ModifierDefinition mod, int level, int stackCount) {
        if (!this.IsCurrent) {
            if (mod.accumulators.length > 0) {
                StatAccumulator existing = this.ModifierFormulae.get(mod.GetStatWithId());
                if (existing == null) {
                    existing = new StatAccumulator();
                    this.ModifierFormulae.put(mod.GetStatWithId(), existing);
                }
                existing.Stack(level, stackCount, mod.accumulators);
            }
            if (!mod.setValue.isEmpty()) {
                this.StringOverrides.put(mod.GetStatWithId(), mod.setValue);
                if (!mod.id.isEmpty()) {
                    String string = mod.GetStatWithId();
                }
            }
        } else {
            FlansMod.LOGGER.error("Can't modify a finished ModifierCache");
        }
    }
}

