/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.nodes;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.particle.GunshotHitBlockParticle;
import com.flansmod.common.FlansMod;
import com.flansmod.common.FlansModConfig;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.EActionResult;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunshotContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.gunshots.Gunshot;
import com.flansmod.common.gunshots.GunshotCollection;
import com.flansmod.common.gunshots.Raytracer;
import com.flansmod.common.gunshots.UnresolvedEntityHitResult;
import com.flansmod.common.item.BulletItem;
import com.flansmod.common.projectiles.BulletEntity;
import com.flansmod.common.types.abilities.elements.EAbilityTarget;
import com.flansmod.common.types.abilities.elements.EAbilityTrigger;
import com.flansmod.common.types.bullets.BulletDefinition;
import com.flansmod.common.types.bullets.elements.ImpactDefinition;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import com.flansmod.common.types.guns.elements.ESpreadPattern;
import com.flansmod.physics.common.util.EContextSide;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.common.util.TransformStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ShootAction
extends ActionInstance {
    private final HashMap<Integer, GunshotCollection> Results = new HashMap();
    private static final double RAYCAST_LENGTH = 500.0;

    public ShootAction(@Nonnull ActionGroupInstance group, @Nonnull ActionDefinition def) {
        super(group, def);
    }

    @Override
    @Nonnull
    public ActionInstance.NetData GetNetDataForTrigger(int triggerIndex) {
        if (this.Results.containsKey(triggerIndex)) {
            return new ShootNetData(this.Results.get(triggerIndex));
        }
        return ShootNetData.Invalid;
    }

    @Override
    public void UpdateFromNetData(ActionInstance.NetData netData, int triggerIndex) {
        if (netData instanceof ShootNetData) {
            ShootNetData shootNetData = (ShootNetData)netData;
            this.Results.put(triggerIndex, shootNetData.Results);
        }
    }

    @Override
    public boolean PropogateToServer() {
        return true;
    }

    @Override
    public boolean ShouldFallBackToReload() {
        return !this.Group.Context.CanShoot(0) && this.Group.Context.CanPerformReloadFromAttachedInventory(0);
    }

    @Override
    public EActionResult CanStart() {
        if (!((Boolean)FlansModConfig.AllowShootActions.get()).booleanValue()) {
            return EActionResult.TryNextAction;
        }
        if (!this.Group.Context.Gun.IsValid()) {
            return EActionResult.TryNextAction;
        }
        if (!this.Group.Context.Gun.GetShooter().IsValid()) {
            return EActionResult.TryNextAction;
        }
        if (this.Group.Context.Gun.GetActionStack().IsReloading()) {
            return EActionResult.TryNextAction;
        }
        if (!this.Group.Context.CanShoot(0)) {
            return EActionResult.TryNextAction;
        }
        return super.CanStart();
    }

    @Override
    public boolean CanRetrigger() {
        if (!this.Group.Context.CanShoot(0)) {
            return false;
        }
        if (this.Group.Context.IsReloadInProgress()) {
            return false;
        }
        ShooterContext shooter = this.Group.Context.Gun.GetShooter();
        return !shooter.IsValid() || shooter.GetSide() != EContextSide.Server || !shooter.IsPlayerOwner();
    }

    public boolean VerifyServer(GunshotCollection shots, int triggerIndex) {
        this.Results.put(triggerIndex, shots);
        return true;
    }

    public void SetResults(GunshotCollection shots, int triggerIndex) {
        this.Results.put(triggerIndex, shots);
    }

    public boolean ValidateAndSetResults(GunContext context, GunshotCollection shots, int triggerIndex) {
        this.Results.put(triggerIndex, shots);
        return true;
    }

    public GunshotCollection GetResults(int triggerIndex) {
        return this.Results.get(triggerIndex);
    }

    @Override
    public double GetPropogationRadius() {
        return this.Group.Context.Loudness();
    }

    @Override
    public void AddExtraPositionsForNetSync(int triggerIndex, List<Vec3> positions) {
        if (this.Results.containsKey(triggerIndex)) {
            GunshotCollection shots = this.Results.get(triggerIndex);
            for (int i = 0; i < shots.Count(); ++i) {
                positions.add(shots.Get(i).Endpoint());
            }
        }
    }

    public void Calculate(int repeatIndex) {
        GunshotCollection shots = null;
        if (this.Results.containsKey(repeatIndex)) {
            shots = this.Results.get(repeatIndex);
        } else {
            shots = new GunshotCollection().FromActionGroup(this.Group.Context.GroupPath).WithGun(this.Group.Context.Gun.Def).FiredOnTick(this.Group.GetProgressTicks());
            this.Results.put(repeatIndex, shots);
        }
        int requestedShotsFired = 1;
        ArrayList<Pair<ItemStack, Integer>> shotsFired = new ArrayList<Pair<ItemStack, Integer>>();
        for (int i = 0; i < requestedShotsFired; ++i) {
            Pair<ItemStack, Integer> bulletCheck = this.Group.Context.ConsumeOneBullet(0);
            if (((ItemStack)bulletCheck.getFirst()).m_41619_()) continue;
            shotsFired.add(bulletCheck);
        }
        for (int j = 0; j < shotsFired.size(); ++j) {
            GunshotContext[] gunshotContexts;
            Item item = ((ItemStack)((Pair)shotsFired.get(j)).getFirst()).m_41720_();
            if (!(item instanceof BulletItem)) continue;
            BulletItem bulletItem = (BulletItem)item;
            for (GunshotContext gunshotContext : gunshotContexts = GunshotContext.forBullet(this.Group.Context, bulletItem.Def())) {
                float bulletSpread = 1.25f * this.Group.Context.Spread();
                for (int i = 0; i < gunshotContext.BulletCount(); ++i) {
                    TransformStack transformStack = TransformStack.empty();
                    transformStack.add(this.Group.Context.Gun.GetShootOrigin());
                    this.RandomizeVectorDirection(transformStack, this.Group.Context.Gun.GetShooter().Level().f_46441_, bulletSpread, this.Group.Context.SpreadPattern());
                    Transform randomizedDirection = transformStack.top();
                    float penetrationPower = gunshotContext.PenetrationPower();
                    if (gunshotContext.IsProjectile) {
                        shots.AddShot(new Gunshot().FromShot(repeatIndex).FromBulletIndex((Integer)((Pair)shotsFired.get(j)).getSecond()).FromProjectile(gunshotContext.DefIndex).WithOrigin(randomizedDirection.positionVec3()).WithTrajectory(randomizedDirection.forward().m_82490_((double)gunshotContext.LaunchSpeed())).WithBullet(gunshotContext.Bullet));
                        continue;
                    }
                    ArrayList<HitResult> hits = new ArrayList<HitResult>(8);
                    Raytracer.ForLevel((LevelAccessor)this.Group.Context.Gun.GetShooter().Level()).CastBullet(this.Group.Context.Gun.GetShooter().Entity(), randomizedDirection.positionVec3(), randomizedDirection.forward().m_82490_(500.0), penetrationPower, penetrationPower, hits);
                    HitResult[] hitArray = new HitResult[hits.size()];
                    hits.toArray(hitArray);
                    shots.AddShot(new Gunshot().FromShot(repeatIndex).FromBulletIndex((Integer)((Pair)shotsFired.get(j)).getSecond()).FromHitscan(gunshotContext.DefIndex).WithOrigin(randomizedDirection.positionVec3()).WithTrajectory(randomizedDirection.forward().m_82490_(500.0)).WithHits(hitArray).WithBullet(gunshotContext.Bullet));
                }
            }
        }
    }

    private void RandomizeVectorDirection(@Nonnull TransformStack transformStack, @Nonnull RandomSource rand, float spread, @Nonnull ESpreadPattern spreadPattern) {
        float yComponent;
        float xComponent;
        switch (spreadPattern) {
            case Circle: 
            case FilledCircle: {
                float theta = rand.m_188501_() * ((float)Math.PI * 2);
                float radius = (spreadPattern == ESpreadPattern.Circle ? 1.0f : rand.m_188501_()) * spread;
                xComponent = radius * Maths.sinF(theta);
                yComponent = radius * Maths.cosF(theta);
                break;
            }
            case Horizontal: {
                xComponent = spread * (rand.m_188501_() * 2.0f - 1.0f);
                yComponent = 0.0f;
                break;
            }
            case Vertical: {
                xComponent = 0.0f;
                yComponent = spread * (rand.m_188501_() * 2.0f - 1.0f);
                break;
            }
            case Triangle: {
                xComponent = rand.m_188501_() * 2.0f - 1.0f;
                yComponent = rand.m_188501_() * 2.0f - 1.0f;
                if (xComponent > 0.0f) {
                    if (!(yComponent > 1.0f - xComponent * 2.0f)) break;
                    yComponent = -yComponent;
                    xComponent = 1.0f - xComponent;
                    break;
                }
                if (!(yComponent > xComponent * 2.0f + 1.0f)) break;
                yComponent = -yComponent;
                xComponent = -1.0f - xComponent;
                break;
            }
            default: {
                xComponent = 0.0f;
                yComponent = 0.0f;
            }
        }
        float yaw = Maths.atanF(xComponent);
        float pitch = Maths.atanF(yComponent);
        transformStack.add(Transform.fromEuler(pitch, yaw, 0.0f));
    }

    @Override
    public void OnTriggerServer(int triggerIndex) {
        float loudness;
        if (!this.Group.Context.Gun.GetShooter().IsValid()) {
            this.Group.SetFinished();
            return;
        }
        if (this.Results.isEmpty() && !this.Group.Context.Gun.GetShooter().IsPlayerOwner()) {
            this.Calculate(triggerIndex);
        }
        Level level = this.Group.Context.Gun.GetLevel();
        GunshotCollection shotCollection = this.Results.get(triggerIndex);
        if (shotCollection != null && !shotCollection.Processed) {
            shotCollection.Processed = true;
            HashMap<Integer, BulletDefinition> bulletsToConsume = new HashMap<Integer, BulletDefinition>();
            for (Gunshot gunshot : shotCollection.Shots) {
                if (bulletsToConsume.containsKey(gunshot.fromBulletIndex)) continue;
                bulletsToConsume.put(gunshot.fromBulletIndex, gunshot.bulletDef);
            }
            for (Map.Entry entry : bulletsToConsume.entrySet()) {
                int bulletIndex = (Integer)entry.getKey();
                BulletDefinition bulletDef = (BulletDefinition)entry.getValue();
                ItemStack bulletStackAtIndex = this.Group.Context.GetBulletAtIndex(0, bulletIndex);
                Item item = bulletStackAtIndex.m_41720_();
                if (item instanceof BulletItem) {
                    BulletItem bulletItem = (BulletItem)item;
                    int bulletCount = this.Group.Context.GetNumBulletsInMag(0);
                    int magSize = this.Group.Context.GetMagazineSize(0);
                    EAbilityTrigger consumeTrigger = EAbilityTrigger.BulletConsumed;
                    if (bulletCount == 1) {
                        consumeTrigger = EAbilityTrigger.LastBulletConsumed;
                    }
                    if (bulletCount == magSize) {
                        consumeTrigger = EAbilityTrigger.FirstBulletConsumed;
                    }
                    this.Group.Context.Gun.GetActionStack().EvaluateTrigger(consumeTrigger, this.Group.Context.Gun, TriggerContext.self(this.Group.Context));
                    if (bulletItem.Def() == bulletDef) {
                        this.Group.Context.ConsumeBulletAtIndex(0, bulletIndex);
                        continue;
                    }
                    FlansMod.LOGGER.warn("Player claimed they had bullet type " + bulletDef + " at slot " + bulletIndex + " but we found " + bulletItem.Def());
                    this.Group.Context.ConsumeBulletAtIndex(0, bulletIndex);
                    continue;
                }
                FlansMod.LOGGER.warn("Player tried to shoot bullet type " + bulletDef + " in slot " + bulletIndex + " but server found it to be empty");
            }
            for (Gunshot gunshot : shotCollection.Shots) {
                if (gunshot.IsProjectile()) {
                    GunshotContext projectileContext = GunshotContext.projectile(this.Group.Context, gunshot.bulletDef, gunshot.ProjectileIndex());
                    if (projectileContext.IsValid()) {
                        this.ServerSpawnBullet(level, gunshot, projectileContext);
                        continue;
                    }
                    FlansMod.LOGGER.error("Invalid projectile shot with bullet " + gunshot.bulletDef);
                    continue;
                }
                GunshotContext hitscanContext = GunshotContext.hitscan(this.Group.Context, gunshot.bulletDef, gunshot.HitscanIndex());
                if (hitscanContext.IsValid()) {
                    this.ServerProcessImpact(level, gunshot, hitscanContext);
                    continue;
                }
                FlansMod.LOGGER.error("Invalid hitscan shot with bullet " + gunshot.bulletDef);
            }
        }
        if ((loudness = this.Group.Context.Loudness()) >= 30.0f) {
            level.m_142346_(this.Group.Context.Gun.GetShooter().Entity(), GameEvent.f_157812_, this.Group.Context.Gun.GetShootOrigin().blockPos());
        }
    }

    private void ServerSpawnBullet(Level level, Gunshot shot, GunshotContext gunshotContext) {
        BulletEntity bullet = new BulletEntity((EntityType<? extends BulletEntity>)((EntityType)FlansMod.ENT_TYPE_BULLET.get()), level);
        bullet.InitContext(gunshotContext);
        bullet.SetVelocity(shot.trajectory.m_82490_((double)gunshotContext.LaunchSpeed() / 20.0));
        bullet.m_146884_(shot.origin);
        bullet.m_7618_(EntityAnchorArgument.Anchor.FEET, shot.trajectory);
        level.m_7967_((Entity)bullet);
    }

    private void ServerProcessImpact(Level level, Gunshot shot, GunshotContext gunshotContext) {
        gunshotContext.ProcessShot(shot);
    }

    @Override
    public void OnTriggerClient(int triggerIndex) {
        GunshotCollection shots;
        if (this.Group.Context.Gun.GetShooter().IsLocalPlayerOwner()) {
            this.Calculate(triggerIndex);
        }
        if ((shots = this.Results.get(triggerIndex)) != null) {
            boolean hitEntity = false;
            boolean hitMLG = false;
            boolean hitFatal = false;
            float verticalRecoil = 0.0f;
            float horizontalRecoil = 0.0f;
            for (Gunshot shot : shots.Shots) {
                GunshotContext gunshotContext = GunshotContext.of(this.Group.Context, shot);
                verticalRecoil = Maths.max(verticalRecoil, this.Group.Context.VerticalRecoil());
                horizontalRecoil = Maths.max(horizontalRecoil, this.Group.Context.HorizontalRecoil());
                if (!gunshotContext.IsHitscan()) continue;
                if (this.Group.Context.Gun.GetShooter().IsLocalPlayerOwner()) {
                    FlansModClient.SpawnLocalMuzzleParticles(shot.origin, gunshotContext, gunshotContext.ActionGroup.Gun.Def.particleCount);
                    if (shot.bulletDef.hitscans.length > 0) {
                        FlansModClient.SHOT_RENDERER.AddLocalPlayerTrail(shot.origin, shot.Endpoint(), gunshotContext);
                    }
                } else {
                    FlansModClient.SpawnMuzzleParticles(shot.origin, gunshotContext, gunshotContext.ActionGroup.Gun.Def.particleCount);
                    if (shot.bulletDef.hitscans.length > 0) {
                        FlansModClient.SHOT_RENDERER.AddTrail(shot.origin, shot.Endpoint());
                    }
                }
                Vec3 vel = new Vec3(shot.origin.m_7096_() - shot.Endpoint().m_7096_(), shot.origin.m_7098_() - shot.Endpoint().m_7098_(), shot.origin.m_7094_() - shot.Endpoint().m_7094_());
                vel.m_82541_();
                for (HitResult hit : shot.hits) {
                    float damage;
                    if (hit.m_6662_() != HitResult.Type.ENTITY) continue;
                    Entity entity = null;
                    if (hit instanceof EntityHitResult) {
                        EntityHitResult entityHitResult = (EntityHitResult)hit;
                        entity = entityHitResult.m_82443_();
                    } else if (hit instanceof UnresolvedEntityHitResult) {
                        UnresolvedEntityHitResult unresolved = (UnresolvedEntityHitResult)hit;
                        entity = this.Group.Context.Gun.GetLevel().m_6815_(unresolved.EntityID());
                    }
                    if (entity == null || !entity.m_6097_()) continue;
                    hitEntity = true;
                    if (entity instanceof EnderDragon) {
                        EnderDragon dragon = (EnderDragon)entity;
                        damage = gunshotContext.EstimateImpactDamage(EAbilityTarget.ShotEntity);
                        damage = damage / 4.0f + Math.min(damage, 1.0f);
                        if (!(dragon.m_21223_() <= damage)) continue;
                        hitMLG = true;
                        hitFatal = true;
                        continue;
                    }
                    if (entity instanceof EnderDragonPart) {
                        EnderDragonPart part = (EnderDragonPart)entity;
                        damage = gunshotContext.EstimateImpactDamage(EAbilityTarget.ShotEntity);
                        if (part != part.f_31010_.f_31080_) {
                            damage = damage / 4.0f + Math.min(damage, 1.0f);
                        }
                        if (!(part.f_31010_.m_21223_() <= damage)) continue;
                        hitMLG = true;
                        hitFatal = true;
                        continue;
                    }
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    damage = gunshotContext.EstimateImpactDamage(EAbilityTarget.ShotEntity);
                    if (!(living.m_21223_() < damage)) continue;
                    hitFatal = true;
                }
            }
            if (this.Group.Context.Gun.GetShooter().IsLocalPlayerOwner()) {
                Entity entity;
                if (hitEntity) {
                    FlansModClient.CLIENT_OVERLAY_HOOKS.ApplyHitMarker(hitMLG ? 100.0f : 10.0f, hitFatal, hitMLG);
                }
                if ((entity = this.Group.Context.Gun.GetShooter().Entity()) instanceof Player) {
                    Player player = (Player)entity;
                    FlansModClient.RECOIL.AddRecoil(horizontalRecoil * (float)player.m_217043_().m_188583_(), verticalRecoil * (0.125f + 0.375f * Maths.expF((float)(-triggerIndex) * 0.125f)));
                }
            }
        }
    }

    @Override
    public void OnTickClient() {
        super.OnTickClient();
        int tickAfter = this.GetProgressTicks();
        int tickBefore = tickAfter - 1;
        boolean playedASoundThisTick = false;
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        ActionDefinition shootActionDef = this.Group.Context.GetShootActionDefinition();
        for (GunshotCollection shotCollection : this.Results.values()) {
            for (Gunshot shot : shotCollection.Shots) {
                double t0 = shotCollection.FiredTick;
                GunshotContext gunshotContext = GunshotContext.of(this.Group.Context, shot);
                block6: for (HitResult hit : shot.hits) {
                    double t = Maths.calculateParameter(shot.origin, shot.Endpoint(), hit.m_82450_()) * (double)this.GetDurationPerTriggerTicks() + t0;
                    if (!((double)tickBefore <= t) || !(t < (double)tickAfter)) continue;
                    gunshotContext.ProcessImpact(hit);
                    switch (hit.m_6662_()) {
                        case BLOCK: {
                            int i;
                            ClientLevel level = Minecraft.m_91087_().f_91073_;
                            BlockHitResult blockHit = (BlockHitResult)hit;
                            List<ImpactDefinition> impactEffects = gunshotContext.GetImpactEffects(EAbilityTarget.ShotBlock);
                            Vec3[] motions = new Vec3[3];
                            motions[0] = Maths.reflect(shot.trajectory.m_82541_(), blockHit.m_82434_());
                            Vec3i normal = blockHit.m_82434_().m_122436_();
                            for (i = 1; i < motions.length; ++i) {
                                motions[i] = new Vec3((double)normal.m_123341_() + level.f_46441_.m_188583_() * 0.2, (double)normal.m_123342_() + level.f_46441_.m_188583_() * 0.2, (double)normal.m_123343_() + level.f_46441_.m_188583_() * 0.2);
                                motions[i] = motions[i].m_82541_().m_82490_(0.3);
                            }
                            for (i = 0; i < motions.length; ++i) {
                                BlockState state = level.m_8055_(blockHit.m_82425_());
                                particleEngine.m_107344_(new GunshotHitBlockParticle(level, hit.m_82450_().f_82479_, hit.m_82450_().f_82480_, hit.m_82450_().f_82481_, motions[i].f_82479_, motions[i].f_82480_, motions[i].f_82481_, state, blockHit.m_82425_()).updateSprite(state, blockHit.m_82425_()).m_6569_(0.5f));
                            }
                            continue block6;
                        }
                        case ENTITY: {
                            Entity entity = null;
                            if (hit instanceof EntityHitResult) {
                                EntityHitResult entityHitResult = (EntityHitResult)hit;
                                entity = entityHitResult.m_82443_();
                            } else if (hit instanceof UnresolvedEntityHitResult) {
                                UnresolvedEntityHitResult unresolved = (UnresolvedEntityHitResult)hit;
                                entity = this.Group.Context.Gun.GetLevel().m_6815_(unresolved.EntityID());
                            }
                            if (entity == null || !entity.m_6097_()) continue block6;
                            Vec3 shotMotion = shot.trajectory.m_82541_().m_82490_((double)this.GetDurationPerTriggerTicks());
                            particleEngine.m_107370_((ParticleOptions)ParticleTypes.f_123798_, hit.m_82450_().f_82479_, hit.m_82450_().f_82480_, hit.m_82450_().f_82481_, shotMotion.f_82479_, shotMotion.f_82480_, shotMotion.f_82481_);
                        }
                    }
                }
            }
        }
    }

    public Vec3 GetPlayerMuzzlePosition(int nTicksAgo) {
        Object object = this.Group.Context.Gun.GetShooter().Entity();
        if (object instanceof Player) {
            Player player = (Player)object;
            object = Raytracer.ForLevel((LevelAccessor)player.m_9236_()).GetSnapshot(player, nTicksAgo);
        } else {
            object = this.Group.Context.Gun.GetShooter().Entity();
            if (object instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)object;
                return living.m_146892_();
            }
        }
        return this.Group.Context.Gun.GetShooter().Entity().m_146892_();
    }

    public static class ShootNetData
    extends ActionInstance.NetData {
        public static final int ID = 1;
        public static final ShootNetData Invalid = new ShootNetData();
        public final GunshotCollection Results;

        public ShootNetData() {
            this.Results = new GunshotCollection();
        }

        public ShootNetData(GunshotCollection results) {
            this.Results = results;
        }

        @Override
        public int GetID() {
            return 1;
        }

        @Override
        public void Encode(FriendlyByteBuf buf) {
            GunshotCollection.Encode(this.Results, buf);
        }

        @Override
        public void Decode(FriendlyByteBuf buf) {
            GunshotCollection.Decode(this.Results, buf);
        }
    }
}

