/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.nodes;

import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import com.flansmod.physics.common.util.Maths;
import org.jetbrains.annotations.NotNull;

public class CookGrenadeAction
extends ActionInstance {
    public int TotalTicks;
    public int TicksRemaining;

    public CookGrenadeAction(@NotNull ActionGroupInstance group, @NotNull ActionDefinition def) {
        super(group, def);
    }

    @Override
    public void SkipTicks(int ticks) {
        this.TicksRemaining -= ticks;
    }

    @Override
    public void OnStartClient() {
        super.OnStartClient();
        this.TotalTicks = this.TicksRemaining = Maths.ceil(this.Fuse() * 20.0f);
    }

    @Override
    public void OnTickClient() {
        super.OnTickClient();
        --this.TicksRemaining;
        if (this.TicksRemaining <= 0) {
            this.Group.SetFinished();
        }
    }

    @Override
    public void OnFinishClient() {
        ActionGroupContext otherActionContext = this.Group.Context.Gun.GetActionGroupContext(this.OtherActionName());
        ActionStack actionStack = this.Group.Context.Gun.GetActionStack();
        ActionGroupInstance groupInstance = actionStack.GetOrCreateGroupInstance(otherActionContext);
        actionStack.Server_TryStartGroupInstance(otherActionContext);
        groupInstance.SkipTicks(this.TotalTicks - this.TicksRemaining);
    }

    @Override
    public void OnStartServer() {
        super.OnStartServer();
        this.TotalTicks = this.TicksRemaining = Maths.ceil(this.Fuse() * 20.0f);
    }

    @Override
    public void OnTickServer() {
        super.OnTickServer();
        --this.TicksRemaining;
        if (this.TicksRemaining <= 0) {
            this.Group.SetFinished();
        }
    }

    @Override
    public void OnFinishServer() {
        ActionGroupContext otherActionContext = this.Group.Context.Gun.GetActionGroupContext(this.OtherActionName());
        ActionStack actionStack = this.Group.Context.Gun.GetActionStack();
        ActionGroupInstance groupInstance = actionStack.GetOrCreateGroupInstance(otherActionContext);
        actionStack.Server_TryStartGroupInstance(otherActionContext);
        groupInstance.SkipTicks(this.TotalTicks - this.TicksRemaining);
    }

    @Override
    public void OnTriggerClient(int triggerIndex) {
    }

    @Override
    public void OnTriggerServer(int triggerIndex) {
    }

    public String OtherActionName() {
        return this.ModifyString("action_key", "primary_fire");
    }

    public float Fuse() {
        return this.ModifyFloat("duration", this.Def.duration);
    }
}

