/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.ShooterBlockEntity;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.stats.IModifierBaker;
import com.flansmod.physics.common.util.EContextSide;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ShooterContextBlockEntity
extends ShooterContext {
    @Nonnull
    public EContextSide Side;
    @Nonnull
    public ResourceKey<Level> Dimension;
    @Nonnull
    public BlockPos Pos;
    @Nonnull
    private final UUID ShooterID;

    @Override
    @Nonnull
    public UUID ShooterID() {
        return this.ShooterID;
    }

    @Nonnull
    public static UUID GenerateBlockEntityShooterID(@Nonnull ResourceKey<Level> dimension, @Nonnull BlockPos pos) {
        long a = (long)dimension.m_135782_().hashCode() << 32 | (long)pos.m_123341_();
        long b = (long)pos.m_123342_() << 32 | (long)pos.m_123343_();
        return new UUID(a, b);
    }

    @Nonnull
    public static Pair<Integer, BlockPos> ConvertShooterIDToCoords(@Nonnull UUID shooterID) {
        long a = shooterID.getMostSignificantBits();
        int dimHash = (int)(a >> 32);
        int x = (int)a;
        long b = shooterID.getLeastSignificantBits();
        int y = (int)(b >> 32);
        int z = (int)b;
        return Pair.of((Object)dimHash, (Object)new BlockPos(x, y, z));
    }

    public ShooterContextBlockEntity(@Nonnull ResourceKey<Level> dimension, @Nonnull EContextSide side, @Nonnull BlockPos pos) {
        this.Dimension = dimension;
        this.Side = side;
        this.Pos = pos;
        this.ShooterID = ShooterContextBlockEntity.GenerateBlockEntityShooterID(dimension, pos);
    }

    public ShooterContextBlockEntity(@Nonnull Level level, @Nonnull BlockPos pos) {
        this((ResourceKey<Level>)level.m_46472_(), level.f_46443_ ? EContextSide.Client : EContextSide.Server, pos);
    }

    public ShooterContextBlockEntity(@Nonnull ShooterBlockEntity blockEntity) {
        this((ResourceKey<Level>)blockEntity.m_58904_().m_46472_(), blockEntity.m_58904_().f_46443_ ? EContextSide.Client : EContextSide.Server, blockEntity.m_58899_());
    }

    @Override
    @Nonnull
    public EContextSide GetSide() {
        return this.Side;
    }

    @Override
    @Nonnull
    public ResourceKey<Level> Dimension() {
        return this.Dimension;
    }

    @Override
    @Nullable
    public Level Level() {
        return MinecraftHelpers.getLevel(this.Dimension);
    }

    @Nonnull
    public Optional<ShooterBlockEntity> GetBlockEntity() {
        return this.GetBlockEntity(false);
    }

    @Nonnull
    public Optional<ShooterBlockEntity> GetBlockEntity(boolean canLoadChunks) {
        ShooterBlockEntity shooterBlockEntity;
        Level level = this.Level();
        if (level == null) {
            return Optional.empty();
        }
        if (!canLoadChunks && !level.m_46749_(this.Pos)) {
            return Optional.empty();
        }
        BlockEntity blockEntity = level.m_7702_(this.Pos);
        if (blockEntity instanceof ShooterBlockEntity && !(shooterBlockEntity = (ShooterBlockEntity)blockEntity).m_58901_()) {
            return Optional.of(shooterBlockEntity);
        }
        return Optional.empty();
    }

    @Override
    public int GetNumValidContexts() {
        return this.GetBlockEntity().map(ShooterBlockEntity::GetNumValidContexts).orElse(0);
    }

    @Override
    @Nonnull
    public UUID[] GetAllGunIDs() {
        return this.GetBlockEntity().map(ShooterBlockEntity::GetAllGunIDs).orElse(new UUID[0]);
    }

    @Override
    @Nonnull
    public UUID GetGunIDForSlot(int gunSlotIndex) {
        return this.GetBlockEntity().map(block -> block.GetGunIDForSlot(gunSlotIndex)).orElse(GunContext.INVALID.GetUUID());
    }

    @Override
    @Nonnull
    public GunContext CreateContext(@Nonnull UUID gunID) {
        return this.GetBlockEntity().map(block -> block.CreateContext(gunID)).orElse(GunContext.INVALID);
    }

    @Override
    @Nullable
    public Entity Entity() {
        return null;
    }

    @Override
    @Nullable
    public Entity Owner() {
        return this.GetBlockEntity().map(ShooterBlockEntity::Owner).orElse(null);
    }

    @Override
    @Nullable
    public Container GetAttachedInventory() {
        return this.GetBlockEntity().map(blockEntity -> {
            if (blockEntity instanceof WorldlyContainer) {
                WorldlyContainer container = (WorldlyContainer)blockEntity;
                return container;
            }
            return null;
        }).orElse(null);
    }

    @Override
    @Nonnull
    public Transform GetShootOrigin(float deltaTick) {
        return this.GetBlockEntity().map(block -> block.GetShootOrigin(deltaTick)).orElse(Transform.IDENTITY);
    }

    @Override
    public boolean IsValid() {
        return this.GetBlockEntity().isPresent();
    }

    @Override
    public boolean IsCreative() {
        return false;
    }

    @Override
    public void BakeModifiers(@Nonnull IModifierBaker baker) {
    }

    @Override
    @Nonnull
    public UUID OwnerUUID() {
        return this.GetBlockEntity().map(ShooterBlockEntity::OwnerUUID).orElse(ShooterContext.InvalidID);
    }

    @Override
    public String toString() {
        return "ShooterContext (BlockEntity@" + this.Dimension + ":" + this.Pos + ")";
    }
}

