/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.ShooterBlockEntity;
import com.flansmod.common.actions.stats.IModifierBaker;
import com.flansmod.common.actions.stats.IStatCalculatorContext;
import com.flansmod.common.actions.stats.ModifierCache;
import com.flansmod.common.actions.stats.StatAccumulator;
import com.flansmod.common.item.FlanItem;
import com.flansmod.physics.common.util.EContextSide;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.util.formulae.FloatAccumulation;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public abstract class ShooterContext {
    public static ResourceKey<Level> DimensionUnknown = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("flansmod", "null"));
    public static final UUID InvalidID = new UUID(0L, 0L);
    public static final ShooterContext INVALID = new ShooterContext(){

        @Override
        @Nonnull
        public UUID ShooterID() {
            return InvalidID;
        }

        @Override
        public int GetNumValidContexts() {
            return 0;
        }

        @Override
        @Nonnull
        public UUID[] GetAllGunIDs() {
            return new UUID[0];
        }

        @Override
        @Nonnull
        public UUID GetGunIDForSlot(int gunSlotIndex) {
            return FlanItem.InvalidGunUUID;
        }

        @Override
        @Nonnull
        public GunContext CreateContext(@Nonnull UUID gunID) {
            return GunContext.INVALID;
        }

        @Override
        @Nullable
        public Entity Entity() {
            return null;
        }

        @Override
        @Nullable
        public Entity Owner() {
            return null;
        }

        @Override
        @Nonnull
        public Transform GetShootOrigin(float deltaTick) {
            return Transform.IDENTITY;
        }

        @Override
        public boolean IsValid() {
            return false;
        }

        @Override
        public boolean IsCreative() {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        @Override
        @Nullable
        public Container GetAttachedInventory() {
            return null;
        }

        @Override
        public void BakeModifiers(@Nonnull IModifierBaker baker) {
        }
    };
    private boolean IsCurrent = true;
    private final ModifierCache ModCache = new ModifierCache(this::BakeModifiers);
    private static final HashMap<String, RegistryObject<RangedAttribute>> StatToAttribute = new HashMap();

    @Nonnull
    public static ShooterContext of(@Nullable Entity shooter) {
        if (shooter != null) {
            if (shooter.m_9236_().f_46443_) {
                return ShooterContext.client(shooter);
            }
            return ShooterContext.server(shooter);
        }
        return INVALID;
    }

    @Nonnull
    public static ShooterContext of(@Nullable ShooterBlockEntity shooter) {
        if (shooter != null) {
            if (shooter.m_58904_().f_46443_) {
                return ShooterContext.client(shooter);
            }
            return ShooterContext.server(shooter);
        }
        return INVALID;
    }

    @Nonnull
    public static ShooterContext of(@Nullable Entity shooter, @Nullable Entity owner) {
        if (shooter != null) {
            if (shooter.m_9236_().f_46443_) {
                return ShooterContext.client(shooter, owner);
            }
            return ShooterContext.server(shooter, owner);
        }
        return INVALID;
    }

    @Nonnull
    public static ShooterContext of(@Nonnull UUID shooterID, @Nonnull UUID ownerID, boolean isClient) {
        return isClient ? ShooterContext.client(shooterID, ownerID) : ShooterContext.server(shooterID, ownerID);
    }

    @Nonnull
    public static ShooterContext of(@Nonnull UUID shooterID, @Nonnull UUID ownerID) {
        return MinecraftHelpers.isClientThread() ? ShooterContext.client(shooterID, ownerID) : ShooterContext.server(shooterID, ownerID);
    }

    @Nonnull
    public static ShooterContext server(@Nonnull Entity shooter) {
        return FlansMod.CONTEXT_CACHE.GetShooter(shooter);
    }

    @Nonnull
    public static ShooterContext server(@Nonnull ShooterBlockEntity shooter) {
        return FlansMod.CONTEXT_CACHE.GetShooter(shooter);
    }

    @Nonnull
    public static ShooterContext server(@Nonnull Entity shooter, @Nullable Entity owner) {
        return FlansMod.CONTEXT_CACHE.GetShooter(shooter, owner);
    }

    @Nonnull
    public static ShooterContext server(@Nonnull UUID shooterID, @Nonnull UUID ownerID) {
        return FlansMod.CONTEXT_CACHE.GetShooter(shooterID, ownerID, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static ShooterContext client(@Nonnull Entity shooter) {
        return FlansModClient.CONTEXT_CACHE.GetShooter(shooter);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static ShooterContext client(@Nonnull ShooterBlockEntity shooter) {
        return FlansModClient.CONTEXT_CACHE.GetShooter(shooter);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static ShooterContext client(@Nonnull Entity shooter, @Nullable Entity owner) {
        return FlansModClient.CONTEXT_CACHE.GetShooter(shooter, owner);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public static ShooterContext client(@Nonnull UUID shooterID, @Nonnull UUID ownerID) {
        return FlansModClient.CONTEXT_CACHE.GetShooter(shooterID, ownerID, MinecraftHelpers.clientGetCurrentLevel());
    }

    @Nonnull
    public abstract UUID ShooterID();

    public boolean IsPlayerOwner() {
        boolean bl;
        Entity entity;
        if (this.Owner() != null && (entity = this.Owner()) instanceof Player) {
            Player player = (Player)entity;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean IsLocalPlayerOwner() {
        Player player;
        Entity entity;
        return this.Owner() != null && (entity = this.Owner()) instanceof Player && (player = (Player)entity).m_7578_();
    }

    @Nonnull
    public EContextSide GetSide() {
        return EContextSide.of(this.Entity());
    }

    @Nonnull
    public ResourceKey<Level> Dimension() {
        Level level = this.Level();
        return level != null ? level.m_46472_() : DimensionUnknown;
    }

    @Nullable
    public Level Level() {
        return this.Entity() != null ? this.Entity().m_9236_() : null;
    }

    @Nonnull
    public UUID EntityUUID() {
        return this.Entity() != null ? this.Entity().m_20148_() : InvalidID;
    }

    @Nonnull
    public UUID OwnerUUID() {
        return this.Owner() != null ? this.Owner().m_20148_() : InvalidID;
    }

    public void MarkAsOld() {
        this.IsCurrent = false;
    }

    @Nonnull
    public StatAccumulator GetModifierFormula(@Nonnull String stat) {
        return this.ModCache.GetModifierFormula(stat);
    }

    @Nonnull
    public Optional<String> GetStringOverride(@Nonnull String stat) {
        return this.ModCache.GetStringOverride(stat);
    }

    @Nonnull
    public FloatAccumulation ModifyFloat(@Nonnull String stat) {
        Entity entity = this.Owner();
        if (entity instanceof LivingEntity) {
            AttributeInstance attribMulti;
            LivingEntity living = (LivingEntity)entity;
            RegistryObject<RangedAttribute> attrib = StatToAttribute.get(stat);
            if (attrib != null && (attribMulti = living.m_21051_((Attribute)attrib.get())) != null) {
                return FloatAccumulation.compose(this.GetModifierFormula(stat).Calculate(IStatCalculatorContext.Invalid), FloatAccumulation.of(0.0f, 0.0f, (float)attribMulti.m_22135_(), 0.0f));
            }
        }
        return FloatAccumulation.compose(this.GetModifierFormula(stat).Calculate(IStatCalculatorContext.Invalid));
    }

    @Nonnull
    public String ModifyString(@Nonnull String stat, @Nonnull String defaultValue) {
        return this.GetStringOverride(stat).orElse(defaultValue);
    }

    public void Save(@Nonnull CompoundTag tags) {
        tags.m_128362_("owner", this.OwnerUUID());
        tags.m_128362_("entity", this.EntityUUID());
    }

    @Nonnull
    public static ShooterContext Load(@Nonnull CompoundTag tags, boolean client) {
        if (!tags.m_128403_("owner")) {
            return null;
        }
        UUID ownerID = tags.m_128342_("owner");
        UUID entityID = tags.m_128342_("entity");
        return ShooterContext.of(ownerID, entityID, client);
    }

    @Nonnull
    public GunContext GetGunContextForSlot(int gunSlotIndex, boolean client) {
        UUID gunID = this.GetGunIDForSlot(gunSlotIndex);
        if (gunID != FlanItem.InvalidGunUUID) {
            return GunContext.of(this, gunID);
        }
        return GunContext.INVALID;
    }

    @Nonnull
    public GunContext[] GetAllGunContexts() {
        UUID[] ids = this.GetAllGunIDs();
        GunContext[] contexts = new GunContext[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            contexts[i] = GunContext.of(this, ids[i]);
            contexts[i].UpdateFromItemStack();
        }
        return contexts;
    }

    public abstract int GetNumValidContexts();

    @Nonnull
    public abstract UUID[] GetAllGunIDs();

    @Nonnull
    public abstract UUID GetGunIDForSlot(int var1);

    @Nonnull
    public abstract GunContext CreateContext(@Nonnull UUID var1);

    public abstract Entity Entity();

    public abstract Entity Owner();

    public abstract Container GetAttachedInventory();

    @Nonnull
    public abstract Transform GetShootOrigin(float var1);

    public abstract boolean IsValid();

    public abstract boolean IsCreative();

    public abstract void BakeModifiers(@Nonnull IModifierBaker var1);

    public String toString() {
        return "ShooterContext (Shooter:" + this.EntityUUID() + ", Owner:" + this.OwnerUUID() + ")";
    }

    static {
        StatToAttribute.put("impact_damage", FlansMod.IMPACT_DAMAGE_MULTIPLIER);
        StatToAttribute.put("splash_radius", FlansMod.SPLASH_RADIUS_MULTIPLIER);
        StatToAttribute.put("repeat_delay", FlansMod.TIME_BETWEEN_SHOTS_MULTIPLIER);
        StatToAttribute.put("spread", FlansMod.SHOT_SPREAD_MULTIPLIER);
        StatToAttribute.put("vertical_recoil", FlansMod.VERTICAL_RECOIL_MULTIPLIER);
        StatToAttribute.put("horizontal_recoil", FlansMod.HORIZONTAL_RECOIL_MULTIPLIER);
    }
}

