/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.FlansMod;
import com.flansmod.common.abilities.AbilityEffectApplyDamage;
import com.flansmod.common.abilities.IAbilityEffect;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.TargetsContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.gunshots.EPlayerHitArea;
import com.flansmod.common.gunshots.Gunshot;
import com.flansmod.common.gunshots.PlayerHitResult;
import com.flansmod.common.gunshots.UnresolvedEntityHitResult;
import com.flansmod.common.projectiles.BulletGuidance;
import com.flansmod.common.types.JsonDefinition;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import com.flansmod.common.types.abilities.elements.EAbilityEffect;
import com.flansmod.common.types.abilities.elements.EAbilityTarget;
import com.flansmod.common.types.abilities.elements.EAbilityTrigger;
import com.flansmod.common.types.bullets.BulletDefinition;
import com.flansmod.common.types.bullets.elements.EProjectileResponseType;
import com.flansmod.common.types.bullets.elements.HitscanDefinition;
import com.flansmod.common.types.bullets.elements.ImpactDefinition;
import com.flansmod.common.types.bullets.elements.ProjectileDefinition;
import com.flansmod.physics.common.util.Maths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GunshotContext {
    public static final GunshotContext INVALID = new GunshotContext(ActionGroupContext.INVALID, BulletDefinition.INVALID, false, 0){

        @Override
        public boolean IsValid() {
            return false;
        }
    };
    public final ActionGroupContext ActionGroup;
    public final BulletDefinition Bullet;
    public final boolean IsProjectile;
    public final int DefIndex;

    @Nullable
    public ProjectileDefinition GetProjectileDef() {
        if (this.IsProjectile && this.DefIndex < this.Bullet.projectiles.length) {
            return this.Bullet.projectiles[this.DefIndex];
        }
        return null;
    }

    @Nullable
    public HitscanDefinition GetHitscanDef() {
        if (!this.IsProjectile && this.DefIndex < this.Bullet.hitscans.length) {
            return this.Bullet.hitscans[this.DefIndex];
        }
        return null;
    }

    @Nonnull
    public static GunshotContext of(@Nonnull GunshotContext other) {
        return new GunshotContext(other.ActionGroup, other.Bullet, other.IsProjectile, other.DefIndex);
    }

    @Nonnull
    public static GunshotContext empty(@Nonnull ActionGroupContext actionGroupContext) {
        return new GunshotContext(actionGroupContext, BulletDefinition.INVALID, false, 0);
    }

    @Nonnull
    public static GunshotContext hitscan(@Nonnull ActionGroupContext actionGroupContext, @Nonnull BulletDefinition bulletFired, int hitscanIndex) {
        return new GunshotContext(actionGroupContext, bulletFired, false, hitscanIndex);
    }

    @Nonnull
    public static GunshotContext projectile(@Nonnull ActionGroupContext actionGroupContext, @Nonnull BulletDefinition bulletFired, int projectileIndex) {
        return new GunshotContext(actionGroupContext, bulletFired, true, projectileIndex);
    }

    @Nonnull
    public static GunshotContext of(@Nonnull ActionGroupContext actionGroupContext, @Nonnull Gunshot hitscanData) {
        return new GunshotContext(actionGroupContext, hitscanData.bulletDef, false, hitscanData.fromShotDefIndex);
    }

    @Nonnull
    public static GunshotContext[] forBullet(@Nonnull ActionGroupContext actionGroupContext, @Nonnull BulletDefinition bulletFired) {
        GunshotContext[] gunshots = new GunshotContext[bulletFired.hitscans.length + bulletFired.projectiles.length];
        for (int i = 0; i < bulletFired.hitscans.length; ++i) {
            gunshots[i] = GunshotContext.hitscan(actionGroupContext, bulletFired, i);
        }
        for (int j = 0; j < bulletFired.projectiles.length; ++j) {
            gunshots[bulletFired.hitscans.length + j] = GunshotContext.projectile(actionGroupContext, bulletFired, j);
        }
        return gunshots;
    }

    private GunshotContext(@Nonnull ActionGroupContext actionGroupContext, @Nonnull BulletDefinition bullet, boolean isProjectile, int defIndex) {
        this.ActionGroup = actionGroupContext;
        this.Bullet = bullet;
        this.IsProjectile = isProjectile;
        this.DefIndex = defIndex;
    }

    public boolean IsValid() {
        return this.ActionGroup.IsValid() && this.Bullet.IsValid();
    }

    public boolean IsHitscan() {
        return !this.IsProjectile;
    }

    public void ProcessShot(@Nonnull Gunshot shotData) {
        for (HitResult hit : shotData.hits) {
            this.ProcessImpact(hit);
        }
    }

    public void ProcessImpact(@Nonnull HitResult hit) {
        TriggerContext impactContext = this.GetImpactContext(hit);
        this.ApplyImpactEffects(impactContext);
        switch (hit.m_6662_()) {
            case BLOCK: {
                this.ActionGroup.Gun.GetActionStack().EvaluateTrigger(EAbilityTrigger.ShotBlock, this.ActionGroup, impactContext);
                break;
            }
            case ENTITY: {
                if (hit instanceof PlayerHitResult) {
                    PlayerHitResult playerHit = (PlayerHitResult)hit;
                    if (playerHit.GetHitbox().area == EPlayerHitArea.HEAD) {
                        this.ActionGroup.Gun.GetActionStack().EvaluateTrigger(EAbilityTrigger.ShotHeadshot, this.ActionGroup, impactContext);
                        break;
                    }
                }
                this.ActionGroup.Gun.GetActionStack().EvaluateTrigger(EAbilityTrigger.ShotEntity, this.ActionGroup, impactContext);
            }
        }
    }

    @Nonnull
    public TriggerContext GetImpactContext(@Nonnull HitResult hit) {
        Entity targetEntity = null;
        Level level = this.ActionGroup.Gun.GetLevel();
        if (level != null) {
            List<Object> splashedEntities;
            UnresolvedEntityHitResult unresolved;
            Entity entity;
            HitResult toProcess = hit;
            if (hit instanceof UnresolvedEntityHitResult && (entity = level.m_6815_((unresolved = (UnresolvedEntityHitResult)hit).EntityID())) != null) {
                toProcess = new EntityHitResult(entity);
            }
            Vec3 center = toProcess.m_82450_();
            float splashRadius = this.SplashDamageRadius();
            if (splashRadius > 0.0f) {
                Vec3 halfExtents = new Vec3((double)splashRadius, (double)splashRadius, (double)splashRadius);
                splashedEntities = level.m_45933_(targetEntity, new AABB(center.m_82546_(halfExtents), center.m_82549_(halfExtents)));
            } else {
                splashedEntities = new ArrayList<Entity>();
            }
            return TriggerContext.hitWithSplash(this.ActionGroup, toProcess, splashedEntities);
        }
        return TriggerContext.empty();
    }

    public void ApplyImpactEffects(@Nonnull TriggerContext impactContext) {
        for (ImpactDefinition impact : this.GetAllImpactEffects()) {
            if (!impactContext.CanTriggerFor(impact.targetType)) continue;
            TargetsContext targets = TargetsContext.of(impactContext, impact.targetType);
            block5: for (AbilityEffectDefinition effectDef : impact.impactEffects) {
                switch (this.ActionGroup.Gun.GetShooter().GetSide()) {
                    case Client: {
                        effectDef.GetEffectProcessor().TriggerClient(this.ActionGroup, impactContext, targets, null);
                        continue block5;
                    }
                    case Server: {
                        effectDef.GetEffectProcessor().TriggerServer(this.ActionGroup, impactContext, targets, null);
                    }
                }
            }
        }
    }

    public float ModifyFloat(@Nonnull String stat, float defaultValue) {
        return this.ActionGroup.ModifyFloat(stat).apply(defaultValue);
    }

    @Nonnull
    public String ModifyString(@Nonnull String stat, @Nonnull String defaultValue) {
        return this.ActionGroup.ModifyString(stat, defaultValue);
    }

    public boolean ModifyBoolean(@Nonnull String stat, boolean defaultValue) {
        return this.ActionGroup.ModifyBoolean(stat, defaultValue);
    }

    @Nonnull
    public <T extends Enum<T>> Enum<T> ModifyEnum(@Nonnull String stat, @Nonnull T defaultValue, @Nonnull Class<T> clazz) {
        return this.ActionGroup.ModifyEnum(stat, defaultValue, clazz);
    }

    public int BulletCount() {
        return Maths.ceil(this.ModifyFloat("shot_count", this.BaseBulletCount()));
    }

    private float BaseBulletCount() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        HitscanDefinition hitscanDef = this.GetHitscanDef();
        return projectileDef != null ? (float)projectileDef.shotCount : (hitscanDef != null ? (float)hitscanDef.shotCount : 0.0f);
    }

    public float SplashDamageRadius() {
        return this.ModifyFloat("splash_radius", this.BaseSplashRadius());
    }

    private float BaseSplashRadius() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        HitscanDefinition hitscanDef = this.GetHitscanDef();
        return projectileDef != null ? projectileDef.splashRadius : (hitscanDef != null ? hitscanDef.splashRadius : 0.0f);
    }

    public float PenetrationPower() {
        return this.ModifyFloat("penetration_power", this.BasePenetrationPower());
    }

    private float BasePenetrationPower() {
        HitscanDefinition hitscanDef = this.GetHitscanDef();
        return hitscanDef != null ? hitscanDef.penetrationPower : 0.0f;
    }

    public float FuseTimeSeconds() {
        return this.ModifyFloat("fuse_time", this.BaseFuseTime());
    }

    public float LaunchSpeed() {
        return this.ModifyFloat("launch_speed", this.BaseLaunchSpeed());
    }

    public float Acceleration() {
        return this.ModifyFloat("acceleration", this.BaseAcceleration());
    }

    public float MaxSpeed() {
        return this.ModifyFloat("max_speed", this.BaseMaxSpeed());
    }

    public float GravityFactor() {
        return this.ModifyFloat("gravity_factor", this.BaseGravityFactor());
    }

    @Nonnull
    public EProjectileResponseType ResponseToBlock() {
        return (EProjectileResponseType)this.ModifyEnum("response_to_block", this.BaseResponseToBlock(), EProjectileResponseType.class);
    }

    @Nonnull
    public EProjectileResponseType ResponseToEntity() {
        return (EProjectileResponseType)this.ModifyEnum("response_to_entity", this.BaseResponseToEntity(), EProjectileResponseType.class);
    }

    @Nonnull
    public EProjectileResponseType ResponseToVehicle() {
        return (EProjectileResponseType)this.ModifyEnum("response_to_vehicle", this.BaseResponseToVehicle(), EProjectileResponseType.class);
    }

    public float LockRange() {
        return this.ModifyFloat("lock_range", this.BaseLockTime());
    }

    public float LockTime() {
        return this.ModifyFloat("track_cone", this.BaseLockTime());
    }

    public float LockCone() {
        return this.ModifyFloat("lock_cone", this.BaseLockCone());
    }

    public float TrackCone() {
        return this.ModifyFloat("track_cone", this.BaseTrackCone());
    }

    public float TurnRate() {
        return this.ModifyFloat("turn_rate", this.BaseTurnRate());
    }

    public float DragInWater() {
        return this.ModifyFloat("drag_in_water", this.BaseDragInWater());
    }

    public float DragInAir() {
        return this.ModifyFloat("drag_in_air", this.BaseDragInAir());
    }

    public BulletGuidance.GuidanceType GuidanceType() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        if (projectileDef == null) {
            return BulletGuidance.GuidanceType.NONE;
        }
        return switch (projectileDef.guidanceType) {
            case "beam_riding" -> BulletGuidance.GuidanceType.BEAM_RIDING;
            case "lock_on" -> BulletGuidance.GuidanceType.LOCKON_SIMPLE;
            case "lock_on_predictive" -> BulletGuidance.GuidanceType.LOCKON_LEADING;
            default -> BulletGuidance.GuidanceType.NONE;
        };
    }

    private float BaseFuseTime() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.fuseTime : 0.0f;
    }

    private float BaseLaunchSpeed() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.launchSpeed : 0.0f;
    }

    private float BaseAcceleration() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.acceleration : 0.0f;
    }

    private float BaseMaxSpeed() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.maxSpeed : 0.0f;
    }

    private float BaseGravityFactor() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.gravityFactor : 0.0f;
    }

    @Nonnull
    private EProjectileResponseType BaseResponseToBlock() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.responseToBlock : EProjectileResponseType.Detonate;
    }

    @Nonnull
    private EProjectileResponseType BaseResponseToEntity() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.responseToEntity : EProjectileResponseType.Detonate;
    }

    @Nonnull
    private EProjectileResponseType BaseResponseToVehicle() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.responseToVehicle : EProjectileResponseType.Detonate;
    }

    private float BaseLockRange() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.lockRange : 0.0f;
    }

    private float BaseLockTime() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.lockTime : 0.0f;
    }

    private float BaseLockCone() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.lockCone : 0.0f;
    }

    private float BaseTrackCone() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.trackCone : 0.0f;
    }

    private float BaseTurnRate() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.turnRate : 0.0f;
    }

    private float BaseDragInWater() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.dragInWater : 0.0f;
    }

    private float BaseDragInAir() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? projectileDef.dragInAir : 0.0f;
    }

    @Nonnull
    public ResourceLocation WaterParticles() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? new ResourceLocation(projectileDef.waterParticles) : JsonDefinition.InvalidLocation;
    }

    @Nonnull
    public ResourceLocation AirParticles() {
        ProjectileDefinition projectileDef = this.GetProjectileDef();
        return projectileDef != null ? new ResourceLocation(projectileDef.airParticles) : JsonDefinition.InvalidLocation;
    }

    public float EstimateImpactDamage(@Nonnull EAbilityTarget targetType) {
        for (ImpactDefinition impact : this.GetAllImpactEffects()) {
            if (impact.targetType != targetType) continue;
            for (AbilityEffectDefinition effectDef : impact.impactEffects) {
                IAbilityEffect iAbilityEffect;
                if (effectDef.effectType != EAbilityEffect.ApplyDamage || !((iAbilityEffect = effectDef.GetEffectProcessor()) instanceof AbilityEffectApplyDamage)) continue;
                AbilityEffectApplyDamage dmgAbility = (AbilityEffectApplyDamage)iAbilityEffect;
                return dmgAbility.DamageAmount(this.ActionGroup, null);
            }
        }
        return 0.0f;
    }

    @Nonnull
    public List<ImpactDefinition> GetImpactEffects(@Nonnull EAbilityTarget targetType) {
        ArrayList<ImpactDefinition> matches = new ArrayList<ImpactDefinition>();
        for (ImpactDefinition impact : this.GetAllImpactEffects()) {
            if (impact.targetType != targetType) continue;
            matches.add(impact);
        }
        return matches;
    }

    @Nonnull
    private ImpactDefinition[] GetAllImpactEffects() {
        ProjectileDefinition projectile = this.GetProjectileDef();
        if (projectile != null) {
            return projectile.impacts;
        }
        HitscanDefinition hitscanDef = this.GetHitscanDef();
        if (hitscanDef != null) {
            return hitscanDef.impacts;
        }
        return new ImpactDefinition[0];
    }

    public void Save(CompoundTag tags) {
        CompoundTag actionGroupTags = new CompoundTag();
        this.ActionGroup.Save(actionGroupTags);
        tags.m_128365_("action", (Tag)actionGroupTags);
        tags.m_128405_("bullet", this.Bullet.hashCode());
        tags.m_128379_("proj", this.IsProjectile);
        tags.m_128405_("index", this.DefIndex);
    }

    public static GunshotContext Load(CompoundTag tags, boolean client) {
        BulletDefinition bullet = (BulletDefinition)FlansMod.BULLETS.ByHash(tags.m_128451_("bullet"));
        ActionGroupContext actionGroup = ActionGroupContext.Load(tags.m_128469_("action"), client);
        boolean isProj = tags.m_128471_("proj");
        int defIndex = tags.m_128451_("index");
        if (actionGroup.IsValid()) {
            return new GunshotContext(actionGroup, bullet, isProj, defIndex);
        }
        return INVALID;
    }
}

