/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.actions.ActionManager;
import com.flansmod.common.actions.ActionStack;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextInventoryItem;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.ShooterContextLiving;
import com.flansmod.common.actions.stats.IModifierBaker;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GunContextLiving
extends GunContextInventoryItem {
    protected final ShooterContextLiving ShooterContext;
    protected final InteractionHand Hand;

    public GunContextLiving(@Nonnull ShooterContextLiving shooterContext, @Nonnull InteractionHand hand) {
        super(shooterContext.GetAttachedInventory(), hand == InteractionHand.MAIN_HAND ? 0 : 1);
        this.ShooterContext = shooterContext;
        this.Hand = hand;
    }

    public GunContextLiving(@Nonnull ShooterContextLiving shooterContext, @Nonnull InteractionHand hand, int slotIndex) {
        super(shooterContext.GetAttachedInventory(), slotIndex);
        this.ShooterContext = shooterContext;
        this.Hand = hand;
    }

    @Override
    public void OnItemStackChanged(@Nonnull ItemStack stack) {
        this.ShooterContext.Shooter.m_21008_(this.Hand, stack);
    }

    @Override
    @Nonnull
    public GunContext.EItemStackLinkage CheckItemStackLink() {
        return this.ShooterContext.IsValid() ? GunContext.EItemStackLinkage.Connected : GunContext.EItemStackLinkage.LostConnection;
    }

    @Override
    @Nonnull
    public ItemStack GetLinkedItemStack() {
        return this.Hand == InteractionHand.MAIN_HAND ? this.ShooterContext.Shooter.m_21205_() : this.ShooterContext.Shooter.m_21206_();
    }

    @Override
    @Nullable
    public Container GetAttachedInventory() {
        return this.ShooterContext.GetAttachedInventory();
    }

    @Override
    @Nullable
    public DamageSource CreateDamageSource() {
        LivingEntity lv;
        Entity entity;
        return this.ShooterContext.Level().m_269111_().m_269299_((Entity)this.ShooterContext.Shooter, (entity = this.ShooterContext.Owner()) instanceof LivingEntity ? (lv = (LivingEntity)entity) : null);
    }

    @Override
    @Nonnull
    public ShooterContext GetShooter() {
        return this.ShooterContext;
    }

    @Override
    public boolean CanPerformActions() {
        return true;
    }

    @Override
    @Nonnull
    public ActionStack GetActionStack() {
        return ActionManager.SafeGetActionStack(this);
    }

    @Override
    public boolean CanPerformTwoHandedAction() {
        return this.ShooterContext.CanPerformTwoHandedAction();
    }

    @Override
    public int GetInventorySlotIndex() {
        return this.Hand == InteractionHand.MAIN_HAND ? 0 : 1;
    }

    public InteractionHand GetHand() {
        return this.Hand;
    }

    @Override
    public void BakeModifiers(@Nonnull IModifierBaker baker) {
    }

    @Override
    @Nullable
    public Level GetLevel() {
        return this.ShooterContext.Level();
    }

    @Override
    @Nonnull
    public String toString() {
        return this.GetShooter() + " holding [" + this.GetItemStack() + "] " + (this.Hand == InteractionHand.MAIN_HAND ? "(Main)" : "(Off)");
    }
}

