/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions.contexts;

import com.flansmod.common.FlansMod;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class ContextHistory<T> {
    @Nonnull
    protected final UUID ID;
    @Nonnull
    private final List<ContextEntry<T>> History;

    public ContextHistory(@Nonnull UUID id) {
        this.ID = id;
        this.History = new ArrayList<ContextEntry<T>>();
    }

    @Nullable
    public T GetMostRecentValidContext(@Nonnull Function<T, Boolean> validatorFunc) {
        for (int i = this.History.size() - 1; i >= 0; --i) {
            if (!validatorFunc.apply(this.History.get((int)i).Context).booleanValue()) continue;
            return this.History.get((int)i).Context;
        }
        return null;
    }

    @Nonnull
    public T GetOrCreate(@Nonnull Function<T, Boolean> validatorFunc, @Nonnull NonNullSupplier<T> creatorFunc, @Nonnull NonNullSupplier<Long> timeFunc) {
        Object match = this.GetMostRecentContext();
        if (match == null || !this.BasicValidation(match) || !validatorFunc.apply(match).booleanValue()) {
            match = creatorFunc.get();
            if (!this.BasicValidation(match) || !validatorFunc.apply(match).booleanValue()) {
                return this.GetInvalidContext();
            }
            this.History.add(new ContextEntry<T>(match, (Long)timeFunc.get()));
            if (this.History.size() == 1) {
                FlansMod.LOGGER.info("Context[" + this.ID + "] seen for the first time as '" + match + "'");
            } else {
                ContextEntry<T> previous = this.History.get(this.History.size() - 2);
                this.MarkContextAsOld(previous.Context);
                FlansMod.LOGGER.info("Context[" + this.ID + "] updated from '" + previous.Context + "' to '" + match + "'");
                if (this.History.size() > 100) {
                    FlansMod.LOGGER.error("ContextHistory of [" + this.ID + "] is overflowing?");
                    this.History.remove(0);
                }
            }
        }
        return match;
    }

    @Nullable
    public T GetMostRecentContext() {
        return this.History.isEmpty() ? null : (T)this.History.get((int)(this.History.size() - 1)).Context;
    }

    @Nonnull
    protected abstract T GetInvalidContext();

    protected abstract void MarkContextAsOld(@Nonnull T var1);

    protected abstract boolean BasicValidation(@Nonnull T var1);

    public String toString() {
        StringBuilder sb = new StringBuilder("History of [").append(this.ID).append("]:\n");
        if (this.History.size() == 0) {
            sb.append("~ No Records ~");
        }
        for (ContextEntry<T> tContextEntry : this.History) {
            sb.append(tContextEntry.toString()).append("\n");
        }
        return sb.toString();
    }

    private static class ContextEntry<T> {
        @Nonnull
        private final T Context;
        private final long CreatedTick;

        public ContextEntry(@Nonnull T context, long tick) {
            this.Context = context;
            this.CreatedTick = tick;
        }

        public String toString() {
            return this.CreatedTick + ": " + this.Context;
        }
    }
}

