/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.actions;

import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.nodes.AbilityOnSelfAction;
import com.flansmod.common.actions.nodes.AimDownSightAction;
import com.flansmod.common.actions.nodes.AnimationAction;
import com.flansmod.common.actions.nodes.AttachEffectAction;
import com.flansmod.common.actions.nodes.CookGrenadeAction;
import com.flansmod.common.actions.nodes.DropAction;
import com.flansmod.common.actions.nodes.EjectCasingAction;
import com.flansmod.common.actions.nodes.LaserAction;
import com.flansmod.common.actions.nodes.PlaySoundAction;
import com.flansmod.common.actions.nodes.RaycastAction;
import com.flansmod.common.actions.nodes.ScopeAction;
import com.flansmod.common.actions.nodes.ShootAction;
import com.flansmod.common.actions.nodes.SpawnParticleAction;
import com.flansmod.common.actions.nodes.SwitchModeAction;
import com.flansmod.common.types.guns.elements.ActionDefinition;
import javax.annotation.Nonnull;

public class Actions {
    public static final String DefaultPrimaryActionKey = "primary_fire";

    public static ActionInstance InstanceAction(@Nonnull ActionGroupInstance group, @Nonnull ActionDefinition def) {
        switch (def.actionType) {
            case Animation: {
                return new AnimationAction(group, def);
            }
            case Shoot: {
                return new ShootAction(group, def);
            }
            case Scope: {
                return new ScopeAction(group, def);
            }
            case AimDownSights: {
                return new AimDownSightAction(group, def);
            }
            case PlaySound: {
                return new PlaySoundAction(group, def);
            }
            case CookGrenade: {
                return new CookGrenadeAction(group, def);
            }
            case Raycast: {
                return new RaycastAction(group, def);
            }
            case Drop: {
                return new DropAction(group, def);
            }
            case Axe: 
            case Pickaxe: 
            case Hoe: 
            case Shovel: 
            case Shear: 
            case Flatten: 
            case Strip: 
            case Till: 
            case Shield: {
                return null;
            }
            case AttachEffect: {
                return new AttachEffectAction(group, def);
            }
            case SpawnParticle: {
                return new SpawnParticleAction(group, def);
            }
            case EjectCasing: {
                return new EjectCasingAction(group, def);
            }
            case Laser: {
                return new LaserAction(group, def);
            }
            case SwitchMode: {
                return new SwitchModeAction(group, def);
            }
            case AbilityOnSelf: {
                return new AbilityOnSelfAction(group, def);
            }
        }
        return null;
    }

    public static ActionInstance.NetData CreateEmptyNetData(int type) {
        switch (type) {
            case -1: {
                return ActionInstance.NetData.Invalid;
            }
            case 1: {
                return new ShootAction.ShootNetData();
            }
            case 2: {
                return new EjectCasingAction.CasingNetData();
            }
        }
        return ActionInstance.NetData.Invalid;
    }
}

