/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.abilities;

import com.flansmod.common.FlansModConfig;
import com.flansmod.common.abilities.AbilityStack;
import com.flansmod.common.abilities.IAbilityEffect;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.contexts.ShooterContextPlayer;
import com.flansmod.common.actions.contexts.TargetsContext;
import com.flansmod.common.actions.contexts.TriggerContext;
import com.flansmod.common.entity.INpcRelationshipsCapability;
import com.flansmod.common.entity.NpcRelationshipsCapability;
import com.flansmod.common.entity.ShopkeeperEntity;
import com.flansmod.common.types.abilities.elements.AbilityEffectDefinition;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;

public class AbilityEffectSummonNpc
implements IAbilityEffect {
    private final ResourceLocation NpcID;
    @Nullable
    private final EntityType<? extends Entity> EntityType;

    public AbilityEffectSummonNpc(@Nonnull AbilityEffectDefinition def) {
        this.NpcID = new ResourceLocation(def.ModifyString("entity_tag", ""));
        this.EntityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.NpcID);
    }

    public boolean CanSummonNpc(@Nonnull Player player) {
        if (!((Boolean)FlansModConfig.AllowSummonNpc.get()).booleanValue()) {
            return false;
        }
        double checkRange = (Double)FlansModConfig.SummonNpcMinDistance.get();
        LazyOptional relationshipCap = player.getCapability(NpcRelationshipsCapability.INSTANCE);
        if (relationshipCap.isPresent() && relationshipCap.resolve().isPresent()) {
            long endCooldownTick = ((INpcRelationshipsCapability)relationshipCap.resolve().get()).GetEndCooldownTick(this.NpcID);
            if (player.m_9236_().m_46467_() < endCooldownTick) {
                long ticks = endCooldownTick - player.m_9236_().m_46467_();
                player.m_213846_((Component)Component.m_237110_((String)"action.summon_npc.on_cooldown", (Object[])new Object[]{ticks / 20L}));
                return false;
            }
        }
        for (ShopkeeperEntity nearbyShopkeeper : player.m_9236_().m_45976_(ShopkeeperEntity.class, new AABB(player.m_20185_() - checkRange, player.m_20186_() - checkRange, player.m_20189_() - checkRange, player.m_20185_() + checkRange, player.m_20186_() + checkRange, player.m_20189_() + checkRange))) {
            if (!nearbyShopkeeper.GetDef().Location.equals((Object)this.NpcID)) continue;
            player.m_213846_((Component)Component.m_237115_((String)"action.summon_npc.already_spawned"));
            return false;
        }
        return true;
    }

    @Override
    public void TriggerServer(@Nonnull ActionGroupContext actionGroup, @Nonnull TriggerContext trigger, @Nonnull TargetsContext targets, @Nullable AbilityStack stacks) {
        ShooterContext shooterContext;
        Level level;
        if (this.EntityType != null && (level = actionGroup.Gun.GetLevel()) != null && (shooterContext = actionGroup.Gun.GetShooter()) instanceof ShooterContextPlayer) {
            ShooterContextPlayer playerContext = (ShooterContextPlayer)shooterContext;
            if (this.CanSummonNpc(playerContext.Player)) {
                targets.ForOnePosition(pos -> {
                    Entity entity = this.EntityType.m_20615_(level);
                    if (entity != null) {
                        entity.m_146884_(pos);
                        Optional freePos = level.m_151418_(entity, Shapes.m_83064_((AABB)entity.m_20191_()), pos, 1.0, 1.0, 1.0);
                        entity.m_146884_(freePos.orElse(pos));
                        level.m_7967_(entity);
                        if (entity instanceof ShopkeeperEntity) {
                            ShopkeeperEntity shopkeeper = (ShopkeeperEntity)entity;
                            LazyOptional relationshipCap = playerContext.Player.getCapability(NpcRelationshipsCapability.INSTANCE);
                            if (relationshipCap.isPresent() && relationshipCap.resolve().isPresent()) {
                                ((INpcRelationshipsCapability)relationshipCap.resolve().get()).SetEndCooldownTick(this.NpcID, shopkeeper.m_9236_().m_46467_() + (long)shopkeeper.GetDef().CooldownTicks(true));
                            }
                        }
                    }
                });
            }
        }
    }
}

