/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.vehicles;

import com.flansmod.client.render.RenderContext;
import com.flansmod.client.render.models.ITurboRenderer;
import com.flansmod.client.render.models.TurboRigWrapper;
import com.flansmod.common.FlansMod;
import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.types.LazyDefinition;
import com.flansmod.common.types.vehicles.VehicleDefinition;
import com.flansmod.physics.common.util.Transform;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class VehicleRenderer
extends EntityRenderer<VehicleEntity>
implements ITurboRenderer {
    @Nonnull
    private final LazyDefinition<VehicleDefinition> Def;
    protected final TurboRigWrapper rigWrapper;

    public VehicleRenderer(@Nonnull ResourceLocation defLoc, @Nonnull EntityRendererProvider.Context context) {
        super(context);
        this.Def = LazyDefinition.of(defLoc, FlansMod.VEHICLES);
        this.rigWrapper = new TurboRigWrapper(() -> defLoc);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull VehicleEntity vehicle) {
        return TextureManager.f_118466_;
    }

    private void DoRender(@Nullable VehicleEntity vehicle, @Nonnull RenderContext renderContext, float deltaTick) {
        ResourceLocation skin;
        renderContext.Transforms.add(Transform.fromEuler(0.0f, 0.0f, 180.0f));
        ResourceLocation resourceLocation = skin = vehicle != null ? this.getTextureLocation(vehicle) : TextureManager.f_118466_;
        if (vehicle != null) {
            renderContext.Transforms.add(Transform.extractOrientation(vehicle.RootTransform(deltaTick), false));
        }
        this.rigWrapper.ifRigFound(rig -> rig.renderSectionIteratively(renderContext, "body", partName -> skin, (partName, preRenderContext) -> true, (partName, postRenderContext) -> {}));
    }

    @Override
    public void renderDirect(@Nullable Entity heldByEntity, @Nullable ItemStack stack, @Nonnull RenderContext renderContext) {
        VehicleEntity veh;
        this.DoRender(heldByEntity instanceof VehicleEntity ? (veh = (VehicleEntity)heldByEntity) : null, renderContext, 0.0f);
    }

    public void render(@Nonnull VehicleEntity vehicle, float yaw, float dt, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffers, int light) {
        RenderContext renderContext = new RenderContext(buffers, ItemDisplayContext.FIXED, poseStack, light, 0);
        this.DoRender(vehicle, renderContext, dt);
    }
}

