/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.vehicles;

import com.flansmod.client.FlansModClient;
import com.flansmod.common.FlansMod;
import com.flansmod.common.entity.longdistance.LongDistanceEntity;
import com.flansmod.common.entity.longdistance.LongDistanceVehicle;
import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.flansmod.common.entity.vehicle.hierarchy.VehicleComponentPath;
import com.flansmod.physics.client.DebugRenderer;
import com.flansmod.physics.common.collision.TransformedBB;
import com.flansmod.physics.common.collision.TransformedBBCollection;
import com.flansmod.physics.common.collision.obb.DynamicObject;
import com.flansmod.physics.common.collision.obb.OBBCollisionSystem;
import com.flansmod.physics.common.entity.PhysicsComponent;
import com.flansmod.physics.common.units.AngularAcceleration;
import com.flansmod.physics.common.units.IAcceleration;
import com.flansmod.physics.common.units.LinearAcceleration;
import com.flansmod.physics.common.util.Transform;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class VehicleDebugRenderer {
    private static final float ArrowLengthSeconds = 0.05f;
    private static final DebugPalette Client = new DebugPalette(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), new Vector4f(0.25f, 0.25f, 1.0f, 1.0f), new Vector4f(0.0f, 0.0f, 1.0f, 1.0f), new Vector4f(1.0f, 0.75f, 0.75f, 1.0f), new Vector4f(1.0f, 0.0f, 0.0f, 1.0f), new Vector4f(0.125f, 0.125f, 1.0f, 0.5f), new Vector4f(0.25f, 0.25f, 1.0f, 0.25f), new Vector4f(1.0f, 0.0f, 0.0f, 1.0f), new Vector4f(0.125f, 0.125f, 1.0f, 0.5f), new Vector4f(0.25f, 0.25f, 1.0f, 0.25f), new Vector4f(1.0f, 0.0f, 1.0f, 1.0f), new Vector4f(1.0f, 0.25f, 0.75f, 1.0f));
    private static final DebugPalette Server = new DebugPalette(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), new Vector4f(1.0f, 1.0f, 0.25f, 1.0f), new Vector4f(1.0f, 1.0f, 0.0f, 1.0f), new Vector4f(0.75f, 1.0f, 0.75f, 1.0f), new Vector4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector4f(1.0f, 1.0f, 0.125f, 0.5f), new Vector4f(1.0f, 1.0f, 0.25f, 0.25f), new Vector4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector4f(1.0f, 1.0f, 0.125f, 0.5f), new Vector4f(1.0f, 1.0f, 0.25f, 0.25f), new Vector4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector4f(1.0f, 0.75f, 0.25f, 1.0f));

    public void ClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (FlansMod.DEBUG || Minecraft.m_91087_().m_91290_().m_114377_()) {
            MinecraftServer server;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                for (LongDistanceEntity longEntity : FlansModClient.CLIENT_LONG_DISTANCE.GetAllLongEntities((Level)level)) {
                    if (!(longEntity instanceof LongDistanceVehicle)) continue;
                    LongDistanceVehicle longDistanceVehicle = (LongDistanceVehicle)longEntity;
                }
                OBBCollisionSystem physics = OBBCollisionSystem.ForLevel((Level)level);
                physics.tryForEachDynamic(dynamic -> this.DebugRender((DynamicObject)dynamic, Client));
                this.DebugRenderSeparations(physics, Client);
                this.DebugRender(level.m_104735_(), Client);
            }
            if ((server = ServerLifecycleHooks.getCurrentServer()) != null) {
                for (ServerLevel loadedLevel : server.m_129785_()) {
                    this.DebugRender(loadedLevel.m_8583_(), Server);
                    OBBCollisionSystem physics = OBBCollisionSystem.ForLevel((Level)loadedLevel);
                    physics.tryForEachDynamic(dynamic -> this.DebugRender((DynamicObject)dynamic, Server));
                    this.DebugRenderSeparations(physics, Server);
                }
            }
        }
    }

    private void DebugRenderSeparations(@Nonnull OBBCollisionSystem physics, @Nonnull DebugPalette palettte) {
    }

    private void DebugRender(@Nonnull DynamicObject dynamic, @Nonnull DebugPalette palette) {
    }

    private void DebugRender(@Nonnull TransformedBBCollection bbs, @Nonnull DebugPalette palette) {
        for (int i = 0; i < bbs.getCount(); ++i) {
            TransformedBB bb = bbs.getColliderBB(i);
            DebugRenderer.renderCube(bb.Loc(), 1, palette.CoreCurrent, bb.HalfExtents());
        }
    }

    private void DebugRender(@Nonnull Iterable<Entity> entityList, @Nonnull DebugPalette palette) {
        for (Entity entity : entityList) {
            if (!(entity instanceof VehicleEntity)) continue;
            VehicleEntity vehicle = (VehicleEntity)entity;
            Transform vehiclePos = vehicle.getRootTransform().current();
            Vec3 coreMotionNextFrame = this.DebugRenderForces(vehicle.GetCoreForces(), vehicle.m_20184_(), vehicle.getRootTransform().current(), palette, true, vehicle.Def().physics.mass, vehicle::GetWorldToPartCurrent);
            Transform vehiclePosNext = Transform.compose(vehiclePos, Transform.fromPos(coreMotionNextFrame.m_82490_((double)0.05f)));
            vehicle.GetHierarchy().ForEachNode(node -> {});
            vehicle.GetHierarchy().ForEachWheel((path, def) -> {
                PhysicsComponent physics = vehicle.GetPartPhysics((VehicleComponentPath)path);
                Transform wheelPos = physics.getCurrentTransform();
                Vector3f debugWheelBoxSize = new Vector3f(0.5f * def.radius, def.radius, def.radius);
                DebugRenderer.renderRotation(wheelPos, 1, palette.WheelCurrent, wheelPos.right(), 1.0);
                DebugRenderer.renderLine(vehiclePos, 1, palette.WheelCurrent, vehiclePos.globalToLocalPosition(wheelPos.positionVec3()));
                Vec3 wheelMotionNextFrame = this.DebugRenderForces(physics.getCurrentForces(), physics.getCurrentLinearVelocity().applyOneTick(), wheelPos, palette, false, def.mass, vehicle::GetWorldToPartCurrent);
            });
        }
    }

    private Vec3 DebugRenderForces(@Nullable List<IAcceleration> forces, @Nonnull Vec3 motion, @Nonnull Transform worldTransform, @Nonnull DebugPalette palette, boolean isCore, float mass, @Nonnull Function<VehicleComponentPath, Transform> lookup) {
        float inertia = 1.0f / mass;
        float forceArrowScale = 0.05f;
        float motionArrowScale = 1.0f;
        if (forces != null) {
            Vec3 origin = worldTransform.positionVec3();
            Vec3 forceTotal = new Vec3(0.0, 0.0, 0.0);
            Vector4f forceColour = isCore ? palette.CoreForces : palette.WheelForces;
            for (IAcceleration force : forces) {
                if (force.hasLinearComponent(worldTransform)) {
                    LinearAcceleration linear = force.getLinearComponent(worldTransform);
                    DebugRenderer.renderArrow(worldTransform, 1, forceColour, linear.Acceleration().m_82490_((double)forceArrowScale));
                }
                if (!force.hasAngularComponent(worldTransform)) continue;
                AngularAcceleration angular = force.getAngularComponent(worldTransform);
                DebugRenderer.renderRotation(worldTransform, 1, forceColour, angular.Axis(), angular.Magnitude());
            }
            Vec3 motionNext = motion.m_82549_(forceTotal.m_82490_((double)inertia));
            DebugRenderer.renderArrow(worldTransform, 1, palette.MotionCurrent, motion.m_82490_((double)motionArrowScale));
            DebugRenderer.renderArrow(worldTransform, 1, palette.MotionNext, motionNext.m_82490_((double)motionArrowScale));
            DebugRenderer.renderArrow(worldTransform.translated(motion.m_82490_((double)motionArrowScale)), 1, palette.TotalForce, forceTotal.m_82490_((double)motionArrowScale));
            return motionNext;
        }
        return Vec3.f_82478_;
    }

    private record DebugPalette(@Nonnull Vector4f Default, @Nonnull Vector4f MotionCurrent, @Nonnull Vector4f MotionNext, @Nonnull Vector4f TotalForce, @Nonnull Vector4f WheelForces, @Nonnull Vector4f WheelCurrent, @Nonnull Vector4f WheelNext, @Nonnull Vector4f CoreForces, @Nonnull Vector4f CoreCurrent, @Nonnull Vector4f CoreNext, @Nonnull Vector4f StaticCollision, @Nonnull Vector4f DynamicCollision) {
    }
}

