/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.models.unbaked;

import com.flansmod.client.render.models.ETurboRenderMaterial;
import com.flansmod.client.render.models.ITurboDeserializer;
import com.flansmod.client.render.models.baked.BakedTurboGeometry;
import com.flansmod.client.render.models.baked.BakedTurboSection;
import com.flansmod.client.render.models.unbaked.TurboElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class TurboSection {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<TurboElement> elements;
    private final BlockModel.GuiLight guiLight;
    public final boolean hasAmbientOcclusion;
    private final ItemTransforms transforms;
    private final List<ItemOverride> overrides;
    public final Vector3f offset;
    public final Map<String, ResourceLocation> textures;
    public final ETurboRenderMaterial material;
    public final String renderConditional;
    @Nullable
    public TurboSection parent;
    @Nullable
    protected ResourceLocation parentLocation;

    public TurboSection(@Nullable ResourceLocation parentLocation, @Nonnull List<TurboElement> elements, @Nonnull Map<String, ResourceLocation> textures, boolean hasAmbientOcclusion, @Nullable BlockModel.GuiLight guiLight, @Nullable ItemTransforms transforms, @Nonnull List<ItemOverride> overrides, @Nonnull Vector3f offset, @Nonnull ETurboRenderMaterial material, @Nonnull String renderConditional) {
        this.elements = elements;
        this.hasAmbientOcclusion = hasAmbientOcclusion;
        this.guiLight = guiLight;
        this.textures = textures;
        this.parentLocation = parentLocation;
        this.transforms = transforms;
        this.overrides = overrides;
        this.offset = offset;
        this.material = material;
        this.renderConditional = renderConditional;
    }

    @Nonnull
    public BakedTurboSection bake(@Nullable IGeometryBakingContext context, @Nonnull ModelBaker baker, @Nonnull Function<Material, TextureAtlasSprite> spriteGetter, @Nonnull ModelState modelState, @Nonnull ItemOverrides overrides, @Nonnull ResourceLocation modelLocation, @Nonnull Vector2i textureSize) {
        ImmutableList.Builder bakedGeometry = new ImmutableList.Builder();
        for (TurboElement element : this.elements) {
            BakedTurboGeometry bakedGeom = element.bake(textureSize);
            bakedGeometry.add((Object)bakedGeom);
        }
        return new BakedTurboSection((List<BakedTurboGeometry>)bakedGeometry.build(), overrides, this.transforms, this.material, this.renderConditional);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<TurboSection>,
    ITurboDeserializer {
        private static final boolean DEFAULT_AMBIENT_OCCLUSION = true;

        public TurboSection deserialize(@Nonnull JsonElement jElement, @Nonnull Type p_111499_, @Nonnull JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = jElement.getAsJsonObject();
            List<TurboElement> elementList = this.getElements(context, jObject);
            String parentName = this.getParentName(jObject);
            Map<String, ResourceLocation> map = this.getTextureMap(jObject);
            boolean flag = this.getAmbientOcclusion(jObject);
            ItemTransforms itemTransforms = ItemTransforms.f_111786_;
            if (jObject.has("display")) {
                JsonObject jDisplayObject = GsonHelper.m_13930_((JsonObject)jObject, (String)"display");
                itemTransforms = (ItemTransforms)context.deserialize((JsonElement)jDisplayObject, ItemTransforms.class);
            }
            List<ItemOverride> list1 = this.getOverrides(context, jObject);
            BlockModel.GuiLight blockmodel$guilight = null;
            if (jObject.has("gui_light")) {
                blockmodel$guilight = BlockModel.GuiLight.m_111527_((String)GsonHelper.m_13906_((JsonObject)jObject, (String)"gui_light"));
            }
            Vector3f offset = new Vector3f();
            if (jObject.has("origin")) {
                offset = this.getVector3f(jObject.get("origin"));
            }
            ETurboRenderMaterial material = ETurboRenderMaterial.Solid;
            if (jObject.has("material")) {
                material = ETurboRenderMaterial.valueOf(jObject.get("material").getAsString());
            }
            String renderConditional = "";
            if (jObject.has("renderCondition")) {
                renderConditional = jObject.get("renderCondition").getAsString();
            }
            ResourceLocation parentLocation = parentName.isEmpty() ? null : new ResourceLocation(parentName);
            return new TurboSection(parentLocation, elementList, map, flag, blockmodel$guilight, itemTransforms, list1, offset, material, renderConditional);
        }

        protected List<ItemOverride> getOverrides(JsonDeserializationContext p_111495_, JsonObject p_111496_) {
            ArrayList list = Lists.newArrayList();
            if (p_111496_.has("overrides")) {
                for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)p_111496_, (String)"overrides")) {
                    list.add((ItemOverride)p_111495_.deserialize(jsonelement, ItemOverride.class));
                }
            }
            return list;
        }

        @Nonnull
        private Map<String, ResourceLocation> getTextureMap(@Nonnull JsonObject jObject) {
            HashMap map = Maps.newHashMap();
            if (jObject.has("textures")) {
                JsonObject jTextureObject = GsonHelper.m_13930_((JsonObject)jObject, (String)"textures");
                for (Map.Entry kvp : jTextureObject.entrySet()) {
                    map.put((String)kvp.getKey(), Deserializer.parseTextureLocationOrReference(((JsonElement)kvp.getValue()).getAsString()));
                }
            }
            return map;
        }

        @Nullable
        private static ResourceLocation parseTextureLocationOrReference(@Nonnull String textureName) {
            return ResourceLocation.m_135820_((String)textureName);
        }

        @Nonnull
        private String getParentName(@Nonnull JsonObject jObject) {
            return GsonHelper.m_13851_((JsonObject)jObject, (String)"parent", (String)"");
        }

        protected boolean getAmbientOcclusion(@Nonnull JsonObject jObject) {
            return GsonHelper.m_13855_((JsonObject)jObject, (String)"ambientocclusion", (boolean)true);
        }

        @Nonnull
        protected List<TurboElement> getElements(@Nonnull JsonDeserializationContext context, @Nonnull JsonObject jObject) {
            ArrayList list = Lists.newArrayList();
            if (jObject.has("turboelements")) {
                for (JsonElement jElement : GsonHelper.m_13933_((JsonObject)jObject, (String)"turboelements")) {
                    list.add((TurboElement)context.deserialize(jElement, TurboElement.class));
                }
            }
            return list;
        }
    }
}

