/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.models.unbaked;

import com.flansmod.client.render.models.baked.BakedTurboGeometry;
import com.flansmod.client.render.models.unbaked.TurboElement;
import com.flansmod.client.render.models.unbaked.TurboFace;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TurboElementRaw
extends TurboElement {
    public final Vector3f[] vertices;
    public final Map<Direction, TurboFace> faces;
    private static final int[] UP_VERTS = new int[]{7, 3, 2, 6};
    private static final int[] DOWN_VERTS = new int[]{5, 4, 0, 1};
    private static final int[] NORTH_VERTS = new int[]{0, 2, 3, 1};
    private static final int[] SOUTH_VERTS = new int[]{5, 7, 6, 4};
    private static final int[] EAST_VERTS = new int[]{1, 3, 7, 5};
    private static final int[] WEST_VERTS = new int[]{4, 6, 2, 0};

    public TurboElementRaw(@Nonnull Vector3f euler, @Nonnull Vector3f rotOrigin, boolean shade, @Nonnull Vector3f[] verts, @Nonnull Map<Direction, TurboFace> faceMap) {
        super(euler, rotOrigin, shade);
        this.vertices = verts;
        this.faces = faceMap;
    }

    @Nonnull
    public TurboFace getFace(@Nonnull Direction direction) {
        return this.faces.get(direction);
    }

    @Nonnull
    public BakedTurboGeometry.Polygon bakeQuad(@Nonnull Direction dir) {
        TurboFace face = this.faces.get(dir);
        int[] faceVerts = switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> DOWN_VERTS;
            case Direction.UP -> UP_VERTS;
            case Direction.NORTH -> NORTH_VERTS;
            case Direction.SOUTH -> SOUTH_VERTS;
            case Direction.WEST -> WEST_VERTS;
            case Direction.EAST -> EAST_VERTS;
        };
        return new BakedTurboGeometry.Polygon((List<BakedTurboGeometry.VertexRef>)ImmutableList.of((Object)new BakedTurboGeometry.VertexRef(faceVerts[0], new Vector2f(face.uvData.m_111392_(0), face.uvData.m_111396_(0))), (Object)new BakedTurboGeometry.VertexRef(faceVerts[1], new Vector2f(face.uvData.m_111392_(1), face.uvData.m_111396_(1))), (Object)new BakedTurboGeometry.VertexRef(faceVerts[2], new Vector2f(face.uvData.m_111392_(2), face.uvData.m_111396_(2))), (Object)new BakedTurboGeometry.VertexRef(faceVerts[3], new Vector2f(face.uvData.m_111392_(3), face.uvData.m_111396_(3)))), new Vector3f((float)dir.m_122436_().m_123341_(), (float)dir.m_122436_().m_123342_(), (float)dir.m_122436_().m_123343_()));
    }

    @Override
    @Nonnull
    public BakedTurboGeometry bake(@Nonnull Vector2i textureSize) {
        ImmutableList.Builder vertexBuilder = new ImmutableList.Builder();
        ImmutableList.Builder polygonBuilder = new ImmutableList.Builder();
        Quaternionf rotation = new Quaternionf().rotateY(this.eulerRotations.y * ((float)Math.PI / 180)).rotateX(this.eulerRotations.x * ((float)Math.PI / 180)).rotateZ(this.eulerRotations.z * ((float)Math.PI / 180));
        for (int z = 0; z < 2; ++z) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 2; ++x) {
                    int index = x + y * 2 + z * 4;
                    Vector3f vertex = new Vector3f((Vector3fc)this.vertices[index]);
                    vertex.rotate((Quaternionfc)rotation);
                    vertex.add((Vector3fc)this.rotationOrigin);
                    vertexBuilder.add((Object)new BakedTurboGeometry.Vertex(vertex));
                }
            }
        }
        polygonBuilder.add((Object)this.bakeQuad(Direction.NORTH));
        polygonBuilder.add((Object)this.bakeQuad(Direction.SOUTH));
        polygonBuilder.add((Object)this.bakeQuad(Direction.WEST));
        polygonBuilder.add((Object)this.bakeQuad(Direction.EAST));
        polygonBuilder.add((Object)this.bakeQuad(Direction.UP));
        polygonBuilder.add((Object)this.bakeQuad(Direction.DOWN));
        return new BakedTurboGeometry((List<BakedTurboGeometry.Vertex>)vertexBuilder.build(), (List<BakedTurboGeometry.Polygon>)polygonBuilder.build());
    }
}

