/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.effects;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.render.FirstPersonManager;
import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextPlayer;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.nodes.LaserAction;
import com.flansmod.common.gunshots.Raytracer;
import com.flansmod.common.types.attachments.EAttachmentType;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Vector4f;

public class LaserRenderer {
    private static final ResourceLocation LaserTexture = new ResourceLocation("flansmod", "textures/effects/laser_point.png");

    public LaserRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void RenderTick(@Nonnull RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        for (Player player : Minecraft.m_91087_().f_91073_.m_6907_()) {
            ShooterContext playerContext = ShooterContext.of((Entity)player);
            if (!playerContext.IsValid()) continue;
            for (GunContext gunContext : playerContext.GetAllGunContexts()) {
                if (!gunContext.IsValid()) continue;
                for (ActionGroupInstance actionGroup : gunContext.GetActionStack().GetActiveActionGroups()) {
                    for (ActionInstance actionInstance : actionGroup.GetActions()) {
                        if (!(actionInstance instanceof LaserAction)) continue;
                        LaserAction laserAction = (LaserAction)actionInstance;
                        if (actionGroup.Context.IsAttachment()) {
                            this.RenderLaserOnEntity(event.getPoseStack(), event.getCamera(), gunContext, actionGroup.Context.GetAttachmentType(), actionGroup.Context.GetAttachmentIndex(), laserAction.LaserOrigin(), new Vector4f(laserAction.Red(), laserAction.Green(), laserAction.Blue(), 1.0f));
                            continue;
                        }
                        this.RenderLaserOnEntity(event.getPoseStack(), event.getCamera(), gunContext, EAttachmentType.Generic, -1, laserAction.LaserOrigin(), new Vector4f(laserAction.Red(), laserAction.Green(), laserAction.Blue(), 1.0f));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void OnRenderFirstPersonHands(@Nonnull RenderHandEvent event) {
    }

    public void RenderLaserOnEntity(@Nonnull PoseStack poseStack, @Nonnull Camera camera, @Nonnull GunContext gunContext, @Nonnull EAttachmentType attachType, int attachIndex, @Nonnull String apName, @Nonnull Vector4f colour) {
        ItemDisplayContext transformType = ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        Transform eyeOrigin = gunContext.GetShootOrigin(Minecraft.m_91087_().getPartialTick());
        if (gunContext instanceof GunContextPlayer) {
            GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
            transformType = !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || !gunContext.GetShooter().IsLocalPlayerOwner() ? MinecraftHelpers.getThirdPersonTransformType(gunContext.GetShooter().IsLocalPlayerOwner(), playerGunContext.GetHand()) : MinecraftHelpers.getFirstPersonTransformType(playerGunContext.GetHand());
        }
        Transform laserOrigin = FirstPersonManager.GetWorldSpaceAPTransform(gunContext, transformType, ActionGroupContext.CreateGroupPath(attachType, attachIndex, apName));
        if (gunContext instanceof GunContextPlayer) {
            GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
            switch (playerGunContext.GetHand()) {
                case MAIN_HAND: {
                    laserOrigin = Transform.compose(laserOrigin, Transform.fromEuler(1.0f, 1.0f, 0.0f));
                    break;
                }
                case OFF_HAND: {
                    laserOrigin = Transform.compose(laserOrigin, Transform.fromEuler(1.0f, -1.0f, 0.0f));
                }
            }
        }
        this.RenderLaserFrom(poseStack, camera, eyeOrigin, laserOrigin, gunContext.GetShooter().Entity(), gunContext.GetUUID(), colour);
    }

    public void RenderLaserThirdPerson(@Nonnull PoseStack poseStack, @Nonnull Camera camera, @Nonnull GunContext gunContext, @Nonnull EAttachmentType attachType, int attachIndex, @Nonnull String apName, @Nonnull Vector4f colour) {
        if (gunContext.GetShooter().IsValid()) {
            // empty if block
        }
    }

    public void RenderLaserFrom(@Nonnull PoseStack poseStack, @Nonnull Camera camera, @Nonnull Transform eyeOrigin, @Nonnull Transform laserOrigin, @Nullable Entity ignoreEntity, @Nullable UUID id, @Nonnull Vector4f colour) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            Raytracer raytracer = Raytracer.ForLevel((LevelAccessor)level);
            ArrayList hits = new ArrayList();
            HitResult castFromEye = raytracer.CastBullet(ignoreEntity, eyeOrigin.positionVec3(), laserOrigin.forward().m_82490_(100.0));
            if (castFromEye != null) {
                HitResult castFromLaser;
                Vec3 laserRay = castFromEye.m_82450_().m_82546_(laserOrigin.positionVec3());
                Vec3 laserRayDir = laserRay.m_82541_();
                double dot = laserOrigin.forward().m_82526_(laserRayDir);
                if (dot > 0.5 && (castFromLaser = raytracer.CastBullet(ignoreEntity, laserOrigin.positionVec3(), laserRay.m_82490_(1.02))) != null) {
                    Vec3 normal = laserOrigin.forward().m_82490_(-1.0);
                    if (castFromLaser instanceof BlockHitResult) {
                        BlockHitResult blockHit = (BlockHitResult)castFromLaser;
                        normal = new Vec3((double)blockHit.m_82434_().m_122436_().m_123341_(), (double)blockHit.m_82434_().m_122436_().m_123342_(), (double)blockHit.m_82434_().m_122436_().m_123343_());
                    }
                    this.RenderLaserBeam(poseStack, camera, laserOrigin.positionVec3(), castFromLaser.m_82450_(), colour);
                    FlansModClient.DECAL_RENDERER.AddOrUpdateDecal(LaserTexture, id, castFromLaser.m_82450_(), normal, colour, 0.0f, 2);
                    return;
                }
                Vec3 normal = laserOrigin.forward().m_82490_(-1.0);
                if (castFromEye instanceof BlockHitResult) {
                    BlockHitResult blockHit = (BlockHitResult)castFromEye;
                    normal = new Vec3((double)blockHit.m_82434_().m_122436_().m_123341_(), (double)blockHit.m_82434_().m_122436_().m_123342_(), (double)blockHit.m_82434_().m_122436_().m_123343_());
                }
                this.RenderLaserBeam(poseStack, camera, laserOrigin.positionVec3(), castFromEye.m_82450_(), colour);
                FlansModClient.DECAL_RENDERER.AddOrUpdateDecal(LaserTexture, id, castFromEye.m_82450_(), normal, colour, 0.0f, 2);
                return;
            }
            this.RenderLaserBeam(poseStack, camera, laserOrigin.positionVec3(), laserOrigin.positionVec3().m_82549_(laserOrigin.forward().m_82490_(100.0)), colour);
        }
    }

    public void RenderLaserBeam(@Nonnull PoseStack poseStack, @Nonnull Camera camera, @Nonnull Vec3 startPos, @Nonnull Vec3 endPos, @Nonnull Vector4f colour) {
        Tesselator tesselator = Tesselator.m_85913_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Vec3 cameraPos = camera.m_90583_();
        Vec3 centerPos = startPos.m_82549_(endPos).m_82490_(0.5);
        double length = endPos.m_82554_(startPos);
        Vec3 laserDirection = endPos.m_82546_(startPos).m_82541_();
        Vec3 cameraToTrailDirection = centerPos.m_82546_(cameraPos).m_82541_();
        Vec3 trailYAxis = laserDirection.m_82537_(cameraToTrailDirection).m_82541_();
        Vec3 trailXAxis = laserDirection.m_82490_(length * 0.5);
        trailYAxis = trailYAxis.m_82490_((double)0.01f);
        poseStack.m_85836_();
        poseStack.m_85837_(centerPos.f_82479_ - cameraPos.f_82479_, centerPos.f_82480_ - cameraPos.f_82480_, centerPos.f_82481_ - cameraPos.f_82481_);
        BufferBuilder buf = tesselator.m_85915_();
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Vec3 v0 = trailYAxis.m_82549_(trailXAxis);
        Vec3 v1 = trailYAxis.m_82546_(trailXAxis);
        Vec3 v2 = trailYAxis.m_82490_(-1.0).m_82546_(trailXAxis);
        Vec3 v3 = trailYAxis.m_82490_(-1.0).m_82549_(trailXAxis);
        buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v0.f_82479_, (float)v0.f_82480_, (float)v0.f_82481_).m_85950_(colour.x, colour.y, colour.z, colour.w).m_5752_();
        buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_).m_85950_(colour.x, colour.y, colour.z, colour.w).m_5752_();
        buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_).m_85950_(colour.x, colour.y, colour.z, colour.w).m_5752_();
        buf.m_252986_(poseStack.m_85850_().m_252922_(), (float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_).m_85950_(colour.x, colour.y, colour.z, colour.w).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }
}

