/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.bullets;

import com.flansmod.client.render.FirstPersonManager;
import com.flansmod.client.render.RenderContext;
import com.flansmod.client.render.bullets.CasingRenderer;
import com.flansmod.client.render.models.FlansModelRegistry;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.GunContextPlayer;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.projectiles.CasingEntity;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CasingEntityItemRenderer {
    public CasingEntityItemRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void OnRenderFirstPersonHands(@Nonnull RenderHandEvent event) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        ShooterContext playerContext = ShooterContext.of((Entity)Minecraft.m_91087_().f_91074_);
        if (!playerContext.IsValid()) {
            return;
        }
        for (CasingEntity e : Minecraft.m_91087_().f_91073_.m_45976_(CasingEntity.class, AABB.m_165882_((Vec3)Minecraft.m_91087_().f_91074_.m_20182_(), (double)5.0, (double)5.0, (double)5.0))) {
            if (!e.GetContext().GetShooter().IsLocalPlayerOwner() || e.Action == null || e.lifeTime >= 8) continue;
            this.RenderCasingFirstPerson(e, event.getPoseStack(), null, e.GetContext(), event.getPartialTick());
        }
    }

    public void RenderCasingFirstPerson(@Nonnull CasingEntity casing, @Nonnull PoseStack poseStack, @Nullable Camera camera, @Nonnull GunContext gunContext, @Nonnull float partialTick) {
        CasingRenderer renderer;
        ResourceLocation loc = new ResourceLocation(casing.GetContext().Def.casingModel);
        Item item = casing.GetContext().GetItemStack().m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (!gunItem.GetMagazineType((ItemStack)casing.GetContext().GetItemStack(), (String)casing.GetContext().GetActionGroupContextByHash((int)casing.GetActionGroupPathHash()).GroupPath, (int)0).casingModelOverride.isEmpty()) {
                loc = new ResourceLocation(gunItem.GetMagazineType((ItemStack)casing.GetContext().GetItemStack(), (String)casing.GetContext().GetActionGroupContextByHash((int)casing.GetActionGroupPathHash()).GroupPath, (int)0).casingModelOverride);
            }
        }
        if ((renderer = (CasingRenderer)FlansModelRegistry.GetItemRenderer(loc)) != null) {
            ItemDisplayContext transformType = ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            if (gunContext instanceof GunContextPlayer) {
                GunContextPlayer playerGunContext = (GunContextPlayer)gunContext;
                transformType = !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || !gunContext.GetShooter().IsLocalPlayerOwner() ? MinecraftHelpers.getThirdPersonTransformType(gunContext.GetShooter().IsLocalPlayerOwner(), playerGunContext.GetHand()) : MinecraftHelpers.getFirstPersonTransformType(playerGunContext.GetHand());
            }
            int light = camera != null ? camera.getBlockAtCamera().m_60791_() : 0;
            poseStack.m_85836_();
            RenderContext renderContext = new RenderContext((MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), transformType, poseStack, 0xF00040, 655360);
            renderContext.Transforms.push();
            if (camera != null) {
                renderContext.Transforms.add(Transform.fromPos(camera.m_90583_().m_82490_(-1.0)));
            }
            if (transformType.m_269069_()) {
                FirstPersonManager.ApplyEyeToRoot(renderContext.Transforms, gunContext, transformType);
                FirstPersonManager.ApplyRootToModel(renderContext.Transforms, gunContext, transformType);
                FirstPersonManager.ApplyModelToAP(renderContext.Transforms, gunContext, casing.Action.EjectDirection(), true);
                renderContext.Transforms.add(renderer.getPosePublic(null, null, casing.Action.EjectDirection()));
                renderContext.Transforms.add(Transform.fromScale(1.152f));
            } else {
                renderContext.Transforms.add(FirstPersonManager.GetWorldSpaceAPTransform(gunContext, transformType, casing.Action.AttachPoint()));
            }
            float dist = (float)((double)Mth.m_14179_((float)partialTick, (float)(casing.lifeTime - 1), (float)casing.lifeTime) * casing.m_20184_().m_82553_());
            renderContext.Transforms.add(Transform.fromPos(new Vec3(0.0, 0.0, (double)(-dist))));
            renderer.renderDirect((Entity)casing, ItemStack.f_41583_, renderContext);
            renderContext.Transforms.pop();
            poseStack.m_85849_();
        }
    }
}

