/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.bullets;

import com.flansmod.client.render.RenderContext;
import com.flansmod.client.render.bullets.BulletItemRenderer;
import com.flansmod.client.render.models.FlansModelRegistry;
import com.flansmod.common.FlansMod;
import com.flansmod.common.projectiles.BulletEntity;
import com.flansmod.common.types.bullets.BulletDefinition;
import com.flansmod.physics.common.util.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class BulletEntityRenderer
extends EntityRenderer<BulletEntity> {
    private final HashMap<ResourceLocation, ModelPart> LoadedModels = new HashMap();

    public BulletEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull BulletEntity bullet) {
        return bullet.GetBulletDef().Location;
    }

    public void render(@Nonnull BulletEntity bullet, float yaw, float partialTick, @Nonnull PoseStack pose, @Nonnull MultiBufferSource buffers, int light) {
        BulletDefinition def = bullet.GetBulletDef();
        ResourceLocation loc = def.Location;
        BulletItemRenderer bulletRenderer = (BulletItemRenderer)FlansModelRegistry.GetItemRenderer(loc);
        if (bulletRenderer != null) {
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 0.0f);
            float y = Mth.m_14179_((float)partialTick, (float)bullet.f_19859_, (float)bullet.m_146908_()) - 90.0f;
            float x = Mth.m_14179_((float)partialTick, (float)bullet.f_19860_, (float)bullet.m_146909_());
            pose.m_252781_(Axis.f_252436_.m_252977_(y));
            pose.m_252781_(Axis.f_252403_.m_252977_(x));
            TransformStack transformStack = TransformStack.empty();
            RenderContext context = new RenderContext(buffers, ItemDisplayContext.FIXED, pose, light, 655360);
            bulletRenderer.renderDirect((Entity)bullet, ItemStack.f_41583_, context);
            pose.m_85849_();
        } else {
            FlansMod.LOGGER.warn("Could not find bullet renderer for " + bullet);
        }
    }
}

