/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render.animation;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.render.FlanItemModelRenderer;
import com.flansmod.client.render.animation.FlanimationDefinition;
import com.flansmod.client.render.animation.elements.KeyframeDefinition;
import com.flansmod.client.render.animation.elements.PoseDefinition;
import com.flansmod.client.render.models.FlansModelRegistry;
import com.flansmod.client.render.models.ITurboRenderer;
import com.flansmod.common.FlansMod;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;

public class PoseCache {
    private static final Map<ResourceLocation, Map<ResourceLocation, Map<String, Map<String, Transform>>>> Cache = new HashMap<ResourceLocation, Map<ResourceLocation, Map<String, Map<String, Transform>>>>();

    @Nonnull
    public static Transform Lerp(@Nonnull ResourceLocation itemID, @Nonnull ResourceLocation animationID, @Nonnull String keyframeA, @Nonnull String keyframeB, @Nonnull String partName, float t) {
        Transform poseA = PoseCache.GetPose(itemID, animationID, keyframeA, partName);
        Transform poseB = PoseCache.GetPose(itemID, animationID, keyframeB, partName);
        return Transform.interpolate(poseA, poseB, Maths.clamp(t, 0.0f, 1.0f));
    }

    @Nonnull
    public static Transform GetPose(@Nonnull ResourceLocation itemID, @Nonnull ResourceLocation animationID, @Nonnull String keyframeID, @Nonnull String partName) {
        Map<ResourceLocation, Map<String, Map<String, Transform>>> cacheForItem;
        if (!Cache.containsKey(itemID)) {
            Cache.put(itemID, new HashMap());
        }
        if ((cacheForItem = Cache.get(itemID)) != null) {
            Map<String, Map<String, Transform>> cacheForAnim;
            if (!cacheForItem.containsKey(animationID)) {
                cacheForItem.put(animationID, PoseCache.BuildCache(itemID, animationID));
            }
            if ((cacheForAnim = cacheForItem.get(animationID)) != null) {
                Map<String, Transform> cacheForKeyframe = cacheForAnim.get(keyframeID);
                return cacheForKeyframe.getOrDefault(partName, Transform.IDENTITY);
            }
            return Transform.IDENTITY;
        }
        FlansMod.LOGGER.error("We failed to get the Cache we either already had or just created??");
        return Transform.IDENTITY;
    }

    @Nonnull
    private static Map<String, Map<String, Transform>> BuildCache(@Nonnull ResourceLocation itemID, @Nonnull ResourceLocation animationID) {
        FlansMod.LOGGER.info(">> Creating cache for [model:" + itemID + ", anim:" + animationID + "] <<");
        HashMap<String, Map<String, Transform>> cache = new HashMap<String, Map<String, Transform>>();
        ITurboRenderer renderer = FlansModelRegistry.GetItemRenderer(itemID);
        FlanimationDefinition anim = (FlanimationDefinition)FlansModClient.ANIMATIONS.Get(animationID);
        if (renderer instanceof FlanItemModelRenderer) {
            FlanItemModelRenderer flanRenderer = (FlanItemModelRenderer)renderer;
            for (KeyframeDefinition keyframe : anim.keyframes) {
                cache.put(keyframe.name, new HashMap());
                Map poseCache = (Map)cache.get(keyframe.name);
                PoseCache.BuildPoseCache(flanRenderer, anim, keyframe, poseCache);
            }
            return cache;
        }
        FlansMod.LOGGER.error(">> Cache creation failed for [model:" + itemID + ", anim:" + animationID + "] <<");
        return cache;
    }

    private static void BuildPoseCache(@Nonnull FlanItemModelRenderer renderer, @Nonnull FlanimationDefinition anim, @Nonnull KeyframeDefinition keyframe, @Nonnull Map<String, Transform> poseCache) {
        for (PoseDefinition pose : keyframe.poses) {
            if (poseCache.containsKey(pose.applyTo)) continue;
            poseCache.put(pose.applyTo, pose.Resolve(renderer.getParameters()));
        }
        for (String parent : keyframe.parents) {
            KeyframeDefinition parentKeyframe;
            if (parent == null || parent.isEmpty() || (parentKeyframe = anim.GetKeyframe(parent)) == null) continue;
            PoseCache.BuildPoseCache(renderer, anim, parentKeyframe, poseCache);
        }
    }
}

