/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.BakedModelWrapper;

public abstract class FlanItemModel
extends BakedModelWrapper<BakedModel> {
    protected String modName;
    protected String modelName;
    protected Map<String, BakedModel> parts = new HashMap<String, BakedModel>();
    protected Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
    private static RandomSource rnd = RandomSource.m_216327_();

    public FlanItemModel(BakedModel template, String modName, String modelName) {
        super(template);
        this.modName = modName;
        this.modelName = modelName;
    }

    protected void addParts(String ... partNames) {
        for (String name : partNames) {
            this.parts.put(name, null);
        }
    }

    public void bakeParts(ModelEvent.ModifyBakingResult event) {
        Map models = event.getModels();
        for (String name : this.parts.keySet()) {
            BakedModel part = this.lookupPart(models, name);
            if (part == null) continue;
            this.parts.put(name, part);
            List quads = part.getQuads(null, null, rnd, null, null);
            if (quads.size() <= 0) continue;
            ResourceLocation texLoc = ((BakedQuad)quads.get(0)).m_173410_().m_247685_();
            this.textures.put(name, new ResourceLocation(texLoc.m_135827_(), "textures/" + texLoc.m_135815_() + ".png"));
        }
    }

    protected BakedModel lookupPart(Map<ResourceLocation, BakedModel> models, String name) {
        ResourceLocation partModel = this.getPartModelLocation(name);
        ModelResourceLocation inventoryPartModel = new ModelResourceLocation(partModel, "inventory");
        if (models.containsKey(inventoryPartModel)) {
            return models.get(inventoryPartModel);
        }
        return null;
    }

    public final BakedModel getOriginalModel() {
        return this.originalModel;
    }

    public BakedModel getModelPart(String name) {
        if (name.equals("body")) {
            return this.originalModel;
        }
        return this.parts.get(name);
    }

    public final List<ResourceLocation> getModelLocations() {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>(this.parts.size() + 1);
        for (String partName : this.parts.keySet()) {
            locations.add(this.getPartModelLocation(partName));
        }
        return locations;
    }

    public ResourceLocation GetTextureForPart(String partName) {
        if (this.textures.containsKey(partName)) {
            return this.textures.get(partName);
        }
        return TextureManager.f_118466_;
    }

    public final Collection<ResourceLocation> GetTextureLocations() {
        return this.textures.values();
    }

    protected ResourceLocation getPartModelLocation(String name) {
        if (name.equals("body")) {
            return new ResourceLocation(this.modName, this.modelName);
        }
        return new ResourceLocation(this.modName, this.modelName + "/" + name);
    }

    public boolean m_7521_() {
        return true;
    }

    public BakedModel applyTransform(ItemDisplayContext cameraTransformType, PoseStack mat, boolean leftHand) {
        super.applyTransform(cameraTransformType, mat, leftHand);
        return this;
    }
}

