/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.render;

import com.flansmod.common.actions.ActionGroupInstance;
import com.flansmod.common.actions.ActionInstance;
import com.flansmod.common.actions.contexts.ActionGroupContext;
import com.flansmod.common.actions.contexts.GunContext;
import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.actions.nodes.AimDownSightAction;
import com.flansmod.common.actions.nodes.ScopeAction;
import com.flansmod.common.effects.FlansMobEffect;
import com.flansmod.common.item.GunItem;
import com.flansmod.common.types.bullets.elements.ProjectileDefinition;
import com.flansmod.common.types.guns.elements.ModeDefinition;
import com.flansmod.common.types.magazines.MagazineDefinition;
import com.flansmod.physics.client.DebugRenderer;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.MinecraftHelpers;
import com.flansmod.physics.common.util.Transform;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class ClientRenderHooks {
    private Minecraft MC = Minecraft.m_91087_();
    private RandomSource RNG = new LegacyRandomSource(1733347742354L);
    private static final ResourceLocation HIT_MARKER_TEXTURE = new ResourceLocation("flansmod", "textures/gui/hitmarker.png");
    private static final float HIT_MARKER_SIZE = 9.0f;
    private static float HitMarkerDurationRemaining = 0.0f;
    private static boolean isFatal = false;
    private static boolean isMLG = false;
    private static final ArrayList<Vec2> MLGPositions = new ArrayList();

    public ClientRenderHooks() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void OnClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.UpdateHitMarkers();
        }
    }

    @SubscribeEvent
    public void OnRenderFirstPersonHands(RenderHandEvent event) {
    }

    @SubscribeEvent
    public void OnComputeFOV(ComputeFovModifierEvent event) {
        GunContext[] gunContexts;
        ShooterContext shooterContext = ShooterContext.of((Entity)MinecraftHelpers.getClient().f_91074_);
        if (!shooterContext.IsValid()) {
            return;
        }
        float totalFOVModifier = 0.0f;
        int FOVModifierCount = 0;
        for (GunContext gunContext : gunContexts = shooterContext.GetAllGunContexts()) {
            if (!gunContext.IsValid()) continue;
            for (ActionGroupInstance actionGroup : gunContext.GetActionStack().GetActiveActionGroups()) {
                for (ActionInstance action : actionGroup.GetActions()) {
                    if (!(action instanceof AimDownSightAction)) continue;
                    AimDownSightAction adsAction = (AimDownSightAction)action;
                    totalFOVModifier += adsAction.FOVFactor();
                    ++FOVModifierCount;
                }
            }
        }
        if (FOVModifierCount > 0) {
            event.setNewFovModifier(event.getNewFovModifier() / (totalFOVModifier / (float)FOVModifierCount));
        }
    }

    @SubscribeEvent
    public void OnRenderOverlay(RenderGuiOverlayEvent event) {
        GuiGraphics graphics = event.getGuiGraphics();
        LocalPlayer player = MinecraftHelpers.getClient().f_91074_;
        ShooterContext shooterContext = ShooterContext.of((Entity)player);
        if (!shooterContext.IsValid()) {
            return;
        }
        GunContext[] gunContexts = shooterContext.GetAllGunContexts();
        GunContext mainContext = gunContexts[0];
        GunContext offContext = gunContexts[1];
        if (event instanceof RenderGuiOverlayEvent.Pre) {
            switch (event.getOverlay().id().m_135815_()) {
                case "helmet": {
                    break;
                }
                case "crosshair": {
                    this.RenderHitMarkerOverlay();
                    if (this.RenderScopeOverlay(mainContext, offContext)) {
                        event.setCanceled(true);
                    }
                    for (GunContext gunContext : gunContexts) {
                        if (!gunContext.IsValid()) continue;
                        for (ActionGroupInstance actionGroup : gunContext.GetActionStack().GetActiveActionGroups()) {
                            for (ActionInstance action : actionGroup.GetActions()) {
                                if (!(action instanceof AimDownSightAction)) continue;
                                AimDownSightAction adsAction = (AimDownSightAction)action;
                                event.setCanceled(true);
                            }
                        }
                    }
                    break;
                }
                case "hotbar": {
                    this.RenderPlayerAmmoOverlay(event.getGuiGraphics());
                    this.RenderKillMessageOverlay();
                    this.RenderTeamInfoOverlay();
                }
            }
        }
    }

    private boolean RenderScopeOverlay(GunContext main, GunContext off) {
        int i = MinecraftHelpers.getClient().m_91268_().m_85445_();
        int j = MinecraftHelpers.getClient().m_91268_().m_85446_();
        for (GunContext gunContext : new GunContext[]{main, off}) {
            if (!gunContext.IsValid()) continue;
            for (ActionGroupInstance actionGroup : gunContext.GetActionStack().GetActiveActionGroups()) {
                for (ActionInstance action : actionGroup.GetActions()) {
                    ScopeAction scopeAction;
                    if (!(action instanceof ScopeAction) || !(scopeAction = (ScopeAction)action).ApplyOverlay()) continue;
                    ResourceLocation overlayLocation = scopeAction.GetOverlayLocation();
                    if (overlayLocation != null) {
                        RenderSystem.setShader(GameRenderer::m_172817_);
                        RenderSystem.enableBlend();
                        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)overlayLocation);
                        Tesselator tesselator = Tesselator.m_85913_();
                        BufferBuilder builder = tesselator.m_85915_();
                        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                        builder.m_5483_((double)((float)i * 0.5f - (float)(2 * j)), (double)j, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
                        builder.m_5483_((double)((float)i * 0.5f + (float)(2 * j)), (double)j, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
                        builder.m_5483_((double)((float)i * 0.5f + (float)(2 * j)), 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
                        builder.m_5483_((double)((float)i * 0.5f - (float)(2 * j)), 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
                        tesselator.m_85914_();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void ApplyHitMarker(float duration, boolean fatal, boolean MLG) {
        HitMarkerDurationRemaining = Maths.max(HitMarkerDurationRemaining, duration);
        this.MC.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11915_, (float)1.0f));
        isMLG = MLG;
        isFatal = fatal;
    }

    private void UpdateHitMarkers() {
        if (isMLG) {
            int i;
            this.MC.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11915_, (float)1.0f));
            for (i = 0; i < Maths.ceil(HitMarkerDurationRemaining * 0.5f); ++i) {
                MLGPositions.add(new Vec2((float)this.RNG.m_188583_(), (float)this.RNG.m_188583_()));
            }
            for (i = 0; i < Maths.ceil((float)MLGPositions.size() * 0.25f); ++i) {
                MLGPositions.remove(this.RNG.m_188503_(i + 1));
            }
            if (MLGPositions.size() == 0) {
                isMLG = false;
            }
        }
        HitMarkerDurationRemaining -= 1.0f;
    }

    private void RenderHitMarkerOverlay() {
        int i = MinecraftHelpers.getClient().m_91268_().m_85445_();
        int j = MinecraftHelpers.getClient().m_91268_().m_85446_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)HIT_MARKER_TEXTURE);
        if (isMLG) {
            for (Vec2 v : MLGPositions) {
                this.RenderHitMarker(i, j, v);
            }
        } else if (HitMarkerDurationRemaining > 0.0f) {
            this.RenderHitMarker(i, j, Vec2.f_82462_);
        }
    }

    private void RenderHitMarker(int i, int j, Vec2 pos) {
        float uMin = isFatal ? 16.0f : 0.0f;
        float vMin = 0.0f;
        float scale = 1.0f;
        float x = pos.f_82470_ * 64.0f;
        float y = pos.f_82471_ * 64.0f;
        this.RenderQuad((float)i * 0.5f + x - 4.5f * scale, (float)j * 0.5f + y - 4.5f * scale, 9.0f * scale, 9.0f * scale, uMin, vMin, 32.0f, 16.0f);
    }

    private void RenderPlayerAmmoOverlay(@Nonnull GuiGraphics graphics) {
        int y;
        int x;
        int i;
        ProjectileDefinition def;
        Vector4f lockCol;
        int c;
        int b;
        int a;
        GunItem item;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int screenX = MinecraftHelpers.getClient().m_91268_().m_85445_();
        int screenY = MinecraftHelpers.getClient().m_91268_().m_85446_();
        int anchorX = screenX / 2;
        int anchorY = screenY;
        ShooterContext shooterContext = ShooterContext.of((Entity)player);
        if (player == null || !shooterContext.IsValid()) {
            return;
        }
        GunContext[] gunContexts = shooterContext.GetAllGunContexts();
        GunContext mainContext = gunContexts[0];
        GunContext offContext = gunContexts[1];
        if (gunContexts[0].IsValid()) {
            item = (GunItem)mainContext.Stack.m_41720_();
            a = -2139062144;
            b = 0xFFFFFF;
            c = 1065386112;
            lockCol = new Vector4f(0.5019608f, 0.5019608f, 0.5019608f, 0.5019608f);
            if (item.lockTime > 0.0f) {
                a = -2130786544;
                b = -80112;
                c = -2130786544;
                lockCol = new Vector4f(0.99607843f, 0.78039217f, 0.0627451f, 1.0f);
            }
            if (item.lockTime > item.lockTimeMax) {
                a = -2130833392;
                b = -126960;
                c = -2130833392;
                lockCol = new Vector4f(0.99607843f, 0.0627451f, 0.0627451f, 1.0f);
            }
            if ((def = item.GetChamberProjectile(mainContext.Stack, mainContext)) != null && def.HasLockOn()) {
                i = MinecraftHelpers.getClient().m_91268_().m_85445_();
                int j = MinecraftHelpers.getClient().m_91268_().m_85446_();
                double size = (double)(def.lockCone / (float)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue() * (float)i) / 2.0;
                this.RenderUntexturedCircle((float)i * 0.5f, (float)j * 0.5f, 32, (float)size, (float)size - 1.0f, c);
                if (item.LockedOnTarget != null) {
                    Transform t = Transform.fromPos(item.LockedOnTarget.m_20182_());
                    float rot = Minecraft.m_91087_().f_91075_.m_146908_();
                    t = t.rotateYaw(rot);
                    t = t.rotatePitch(-Minecraft.m_91087_().f_91075_.m_146909_());
                    t = t.rotateRoll(45.0f * Math.min(item.lockTime / item.lockTimeMax, 1.0f));
                    Vector3f bounds = new Vector3f((float)item.LockedOnTarget.m_20191_().m_82309_(), (float)item.LockedOnTarget.m_20191_().m_82309_(), 0.0f);
                    t = t.translated(new Vec3(0.0, item.LockedOnTarget.m_20191_().m_82309_() / 2.0, 0.0));
                    DebugRenderer.renderCube(t, 1, lockCol, bounds.mul(2.0f - Math.min(item.lockTime / item.lockTimeMax, 1.0f)));
                }
            }
            this.RenderUntexturedQuad(anchorX + 94, anchorY - 20, 300.0f, 18.0f, a);
            this.RenderItem(graphics, mainContext.GetItemStack(), anchorX + 95, anchorY - 19, false);
            x = anchorX + 113;
            ActionGroupContext mainHandPrimaryContext = ActionGroupContext.CreateFrom(mainContext, "primary_fire");
            if (mainHandPrimaryContext.IsShootAction()) {
                MagazineDefinition magDef = mainHandPrimaryContext.GetMagazineType(0);
                ItemStack[] bulletStacks = mainHandPrimaryContext.GetCombinedBulletStacks(0);
                if (magDef.numRounds <= 32) {
                    int stackIndex = 0;
                    int bulletIndex = 0;
                    for (int i2 = 0; i2 < magDef.numRounds; ++i2) {
                        if (stackIndex >= bulletStacks.length) continue;
                        if (bulletIndex == bulletStacks[stackIndex].m_41613_()) {
                            ++stackIndex;
                            bulletIndex = 0;
                        }
                        if (stackIndex >= bulletStacks.length || bulletIndex >= bulletStacks[stackIndex].m_41613_()) continue;
                        if (!bulletStacks[stackIndex].m_41619_() && bulletStacks[stackIndex].m_41720_() != Items.f_42410_) {
                            int y2 = anchorY - 20 + (i2 % 4 == 3 ? 2 : (i2 % 4 == 2 ? 0 : (i2 % 4 == 1 ? 1 : 3)));
                            this.RenderItem(graphics, (ItemStack)bulletStacks[stackIndex], x, y2, false);
                            x += 5;
                        }
                        ++bulletIndex;
                    }
                } else {
                    for (ItemStack bulletStack : bulletStacks) {
                        if (bulletStack.m_41619_() || bulletStack.m_41720_() == Items.f_42410_) continue;
                        y = anchorY - 20;
                        this.RenderItem(graphics, bulletStack, x, y, true);
                        x += 16;
                    }
                }
            }
            this.RenderString(graphics, anchorX + 96, anchorY - 29, mainContext.GetItemStack().m_41786_(), b);
            int xOffset = 0;
            for (MobEffectInstance mobEffect : player.m_21220_()) {
                MobEffect i2 = mobEffect.m_19544_();
                if (!(i2 instanceof FlansMobEffect)) continue;
                FlansMobEffect flansMobEffect = (FlansMobEffect)i2;
                TextureAtlasSprite sprite = Minecraft.m_91087_().m_91306_().m_118732_((MobEffect)flansMobEffect);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.RenderSprite(graphics, anchorX + 100 + xOffset, anchorY - 49, 18.0f, 18.0f, sprite);
                String stacksString = Integer.toString(mobEffect.m_19564_() + 1);
                int stacksStringWidth = Minecraft.m_91087_().f_91062_.m_92895_(stacksString);
                this.RenderString(graphics, anchorX + 118 + xOffset - stacksStringWidth, anchorY - 49, (Component)Component.m_237113_((String)stacksString), 0xFFFFFF);
                String timeRemaining = ".".repeat(Math.max(0, Maths.min(mobEffect.m_19557_() / 20, 5)));
                this.RenderString(graphics, anchorX + 102 + xOffset, anchorY - 39, (Component)Component.m_237113_((String)timeRemaining), 0xFFFFFF);
                xOffset += 20;
            }
            if (mainHandPrimaryContext.Def.twoHanded && !player.m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
                this.RenderString(graphics, anchorX + 96, anchorY - 39, (Component)Component.m_237115_((String)"tooltip.dual_wielding_two_handed"), 0xB0B0B0);
            } else if (mainContext.GetAllModeDefs().length > 0) {
                for (int i3 = 0; i3 < mainContext.GetAllModeDefs().length; ++i3) {
                    ModeDefinition modeDef = mainContext.GetAllModeDefs()[i3];
                    String value = mainContext.GetModeValue(modeDef.key);
                    this.RenderString(graphics, anchorX + 96, anchorY - 39 - 10 * i3, (Component)Component.m_237115_((String)("tooltip.mode." + modeDef.key + "." + value)), 0xB0B0B0);
                }
            }
        }
        if (gunContexts[1].IsValid()) {
            item = (GunItem)offContext.Stack.m_41720_();
            a = -2139062144;
            b = 0xFFFFFF;
            c = 1065386112;
            lockCol = new Vector4f(0.5019608f, 0.5019608f, 0.5019608f, 0.5019608f);
            if (item.lockTime > 0.0f) {
                a = -2130786544;
                b = -80112;
                c = -2130786544;
                lockCol = new Vector4f(0.99607843f, 0.78039217f, 0.0627451f, 1.0f);
            }
            if (item.lockTime > item.lockTimeMax) {
                a = -2130833392;
                b = -126960;
                c = -2130833392;
                lockCol = new Vector4f(0.99607843f, 0.0627451f, 0.0627451f, 1.0f);
            }
            if ((def = item.GetChamberProjectile(offContext.Stack, mainContext)) != null && def.HasLockOn()) {
                i = MinecraftHelpers.getClient().m_91268_().m_85445_();
                int j = MinecraftHelpers.getClient().m_91268_().m_85446_();
                double size = (double)(def.lockCone / (float)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue() * (float)i) / 2.0;
                this.RenderUntexturedCircle((float)i * 0.5f, (float)j * 0.5f, 32, (float)size, (float)size - 1.0f, c);
                if (item.LockedOnTarget != null) {
                    Vector3f view = new Vector3f((Vector3fc)offContext.GetShooter().Entity().m_20154_().m_252839_());
                    Transform t = Transform.fromPos(item.LockedOnTarget.m_20182_());
                    float rot = Minecraft.m_91087_().f_91075_.m_146908_();
                    t = t.rotateYaw(rot);
                    t = t.rotatePitch(-Minecraft.m_91087_().f_91075_.m_146909_());
                    t = t.rotateRoll(45.0f * Math.min(item.lockTime / item.lockTimeMax, 1.0f));
                    Vector3f bounds = new Vector3f((float)item.LockedOnTarget.m_20191_().m_82309_(), (float)item.LockedOnTarget.m_20191_().m_82309_(), 0.0f);
                    t = t.translated(new Vec3(0.0, item.LockedOnTarget.m_20191_().m_82309_() / 2.0, 0.0));
                    DebugRenderer.renderCube(t, 1, lockCol, bounds.mul(2.0f - Math.min(item.lockTime / item.lockTimeMax, 1.0f)));
                }
            }
            RenderSystem.enableBlend();
            this.RenderUntexturedQuad(anchorX - 94 - 308, anchorY - 20, 300.0f, 18.0f, a);
            x = anchorX - 113 - 22;
            ActionGroupContext offHandPrimaryContext = ActionGroupContext.CreateFrom(offContext, "primary_fire");
            if (offHandPrimaryContext.IsShootAction()) {
                MagazineDefinition magDef = offHandPrimaryContext.GetMagazineType(0);
                ItemStack[] bulletStacks = offHandPrimaryContext.GetCombinedBulletStacks(0);
                if (magDef.numRounds <= 32) {
                    int stackIndex = 0;
                    int bulletIndex = 0;
                    for (int i4 = 0; i4 < magDef.numRounds; ++i4) {
                        if (stackIndex >= bulletStacks.length) continue;
                        if (bulletIndex == bulletStacks[stackIndex].m_41613_()) {
                            ++stackIndex;
                            bulletIndex = 0;
                        }
                        if (stackIndex >= bulletStacks.length || bulletIndex >= bulletStacks[stackIndex].m_41613_()) continue;
                        if (!bulletStacks[stackIndex].m_41619_() && bulletStacks[stackIndex].m_41720_() != Items.f_42410_) {
                            int y3 = anchorY - 20 + (i4 % 4 == 3 ? 2 : (i4 % 4 == 2 ? 0 : (i4 % 4 == 1 ? 1 : 3)));
                            this.RenderItem(graphics, bulletStacks[stackIndex], x, y3, false);
                            x -= 5;
                        }
                        ++bulletIndex;
                    }
                } else {
                    for (ItemStack bulletStack : bulletStacks) {
                        if (bulletStack.m_41619_() || bulletStack.m_41720_() == Items.f_42410_) continue;
                        y = anchorY - 20;
                        this.RenderItem(graphics, bulletStack, x, y, true);
                        x -= 16;
                    }
                }
            }
            this.RenderString(graphics, anchorX - 98 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)offContext.GetItemStack().m_41786_()), anchorY - 31, offContext.GetItemStack().m_41786_(), b);
            if (offHandPrimaryContext.Def.twoHanded && !player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                MutableComponent warningString = Component.m_237115_((String)"tooltip.dual_wielding_two_handed");
                this.RenderString(graphics, anchorX - 98 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)warningString), anchorY - 39, (Component)warningString, 0xB0B0B0);
            }
        }
    }

    private void RenderKillMessageOverlay() {
    }

    private void RenderTeamInfoOverlay() {
    }

    private void RenderItem(@Nonnull GuiGraphics graphics, @Nonnull ItemStack stack, float x, float y, boolean decorate) {
        graphics.m_280480_(stack, Maths.floor(x), Maths.floor(y));
        if (decorate) {
            graphics.m_280370_(Minecraft.m_91087_().f_91062_, stack, Maths.floor(x), Maths.floor(y));
        }
    }

    private void RenderSprite(@Nonnull GuiGraphics graphics, float x, float y, float w, float h, @Nonnull TextureAtlasSprite sprite) {
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_5483_((double)x, (double)(y + h), -90.0).m_7421_(u0, v1).m_5752_();
        builder.m_5483_((double)(x + w), (double)(y + h), -90.0).m_7421_(u1, v1).m_5752_();
        builder.m_5483_((double)(x + w), (double)y, -90.0).m_7421_(u1, v0).m_5752_();
        builder.m_5483_((double)x, (double)y, -90.0).m_7421_(u0, v0).m_5752_();
        tesselator.m_85914_();
    }

    private void RenderQuad(float x, float y, float w, float h, float u0, float v0, float texW, float texH) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_5483_((double)x, (double)(y + h), -90.0).m_7421_(u0 / texW, (v0 + h) / texH).m_5752_();
        builder.m_5483_((double)(x + w), (double)(y + h), -90.0).m_7421_((u0 + w) / texW, (v0 + h) / texH).m_5752_();
        builder.m_5483_((double)(x + w), (double)y, -90.0).m_7421_((u0 + w) / texW, v0 / texH).m_5752_();
        builder.m_5483_((double)x, (double)y, -90.0).m_7421_(u0 / texW, v0 / texH).m_5752_();
        tesselator.m_85914_();
    }

    private void RenderUntexturedQuad(float x, float y, float w, float h, int colour) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_5483_((double)x, (double)(y + h), -90.0).m_193479_(colour).m_5752_();
        builder.m_5483_((double)(x + w), (double)(y + h), -90.0).m_193479_(colour).m_5752_();
        builder.m_5483_((double)(x + w), (double)y, -90.0).m_193479_(colour).m_5752_();
        builder.m_5483_((double)x, (double)y, -90.0).m_193479_(colour).m_5752_();
        tesselator.m_85914_();
    }

    private void RenderUntexturedCircle(float x, float y, int sides, float outerRadius, float innerRadius, int colour) {
        int i;
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        ArrayList<Vec2> pointsList = new ArrayList<Vec2>();
        ArrayList<Vec2> outerPoints = this.GetCircumferencePoints(sides, outerRadius);
        pointsList.addAll(outerPoints);
        ArrayList<Vec2> innerPoints = this.GetCircumferencePoints(sides, innerRadius);
        pointsList.addAll(innerPoints);
        int sides2 = pointsList.size() / 2;
        for (i = 0; i < sides2; ++i) {
            Vec2 vec2 = (Vec2)pointsList.get(i);
        }
        for (i = 0; i < sides2; ++i) {
            int outerIndex = i;
            int innerIndex = i + sides;
            builder.m_5483_((double)(((Vec2)pointsList.get((int)outerIndex)).f_82470_ + x), (double)(((Vec2)pointsList.get((int)outerIndex)).f_82471_ + y), -90.0).m_193479_(colour).m_5752_();
            builder.m_5483_((double)(((Vec2)pointsList.get((int)innerIndex)).f_82470_ + x), (double)(((Vec2)pointsList.get((int)innerIndex)).f_82471_ + y), -90.0).m_193479_(colour).m_5752_();
            builder.m_5483_((double)(((Vec2)pointsList.get((int)((i + 1) % sides))).f_82470_ + x), (double)(((Vec2)pointsList.get((int)((i + 1) % sides))).f_82471_ + y), -90.0).m_193479_(colour).m_5752_();
            builder.m_5483_((double)(((Vec2)pointsList.get((int)outerIndex)).f_82470_ + x), (double)(((Vec2)pointsList.get((int)outerIndex)).f_82471_ + y), -90.0).m_193479_(colour).m_5752_();
            builder.m_5483_((double)(((Vec2)pointsList.get((int)(sides + (sides + i - 1) % sides))).f_82470_ + x), (double)(((Vec2)pointsList.get((int)(sides + (sides + i - 1) % sides))).f_82471_ + y), -90.0).m_193479_(colour).m_5752_();
            builder.m_5483_((double)(((Vec2)pointsList.get((int)(outerIndex + sides))).f_82470_ + x), (double)(((Vec2)pointsList.get((int)(outerIndex + sides))).f_82471_ + y), -90.0).m_193479_(colour).m_5752_();
        }
        tesselator.m_85914_();
    }

    ArrayList<Vec2> GetCircumferencePoints(int sides, float radius) {
        ArrayList<Vec2> points = new ArrayList<Vec2>();
        float circumferenceProgressPerStep = 1.0f / (float)sides;
        float TAU = (float)Math.PI * 2;
        float radianProgressPerStep = circumferenceProgressPerStep * TAU;
        for (int i = 0; i < sides; ++i) {
            float currentRadian = radianProgressPerStep * (float)i;
            points.add(new Vec2((float)Math.cos(currentRadian) * radius, (float)Math.sin(currentRadian) * radius));
        }
        return points;
    }

    private void RenderString(@Nonnull GuiGraphics graphics, float x, float y, @Nonnull Component content, int colour) {
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, content, Maths.floor(x), Maths.floor(y), colour);
    }
}

