/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.input;

import com.flansmod.common.actions.contexts.ShooterContext;
import com.flansmod.common.entity.vehicle.VehicleEntity;
import com.mojang.blaze3d.platform.InputConstants;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.common.util.Lazy;

public class KeyMappings {
    public static final IKeyConflictContext HOLDING_GUN = new KeyConflictContextHoldingGun();
    public static final IKeyConflictContext IN_VEHICLE = new KeyConflictContextInVehicle();
    public static final Lazy<KeyMapping> LOOK_AT_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.look_at", HOLDING_GUN, InputConstants.Type.KEYSYM, 76, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> MODE_TOGGLE_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.mode_toggle", HOLDING_GUN, InputConstants.Type.KEYSYM, 67, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> MANUAL_RELOAD_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.manual_reload", HOLDING_GUN, InputConstants.Type.KEYSYM, 82, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> GEAR_UP_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.gear_down", IN_VEHICLE, InputConstants.Type.KEYSYM, 268, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> GEAR_DOWN_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.gear_up", IN_VEHICLE, InputConstants.Type.KEYSYM, 269, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> STRAFE_UP_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.strafe_down", IN_VEHICLE, InputConstants.Type.KEYSYM, 266, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> STRAFE_DOWN_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.strafe_up", IN_VEHICLE, InputConstants.Type.KEYSYM, 267, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> YAW_RIGHT_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.yaw_right", IN_VEHICLE, InputConstants.Type.KEYSYM, 68, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> YAW_LEFT_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.yaw_left", IN_VEHICLE, InputConstants.Type.KEYSYM, 65, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> PITCH_UP_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.pitch_up", IN_VEHICLE, InputConstants.Type.KEYSYM, 264, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> PITCH_DOWN_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.pitch_down", IN_VEHICLE, InputConstants.Type.KEYSYM, 265, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> ROLL_LEFT_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.roll_left", IN_VEHICLE, InputConstants.Type.KEYSYM, 263, "key.categories.flansmod"));
    public static final Lazy<KeyMapping> ROLL_RIGHT_MAPPING = Lazy.of(() -> new KeyMapping("key.flansmod.roll_right", IN_VEHICLE, InputConstants.Type.KEYSYM, 262, "key.categories.flansmod"));
    public static final int MouseX = 0;
    public static final int MouseY = 1;
    public static final int MouseScrollWheel = 2;
    public static final Lazy<AxisMapping> YAW_MOUSE_AXIS = Lazy.of(() -> new AxisMapping("axis.flansmod.yaw", IN_VEHICLE, AxisMappingType.MouseAxis, -1, "key.categories.flansmod"));
    public static final Lazy<AxisMapping> ROLL_MOUSE_AXIS = Lazy.of(() -> new AxisMapping("axis.flansmod.roll", IN_VEHICLE, AxisMappingType.MouseAxis, 0, "key.categories.flansmod"));
    public static final Lazy<AxisMapping> PITCH_MOUSE_AXIS = Lazy.of(() -> new AxisMapping("axis.flansmod.pitch", IN_VEHICLE, AxisMappingType.MouseAxis, 1, "key.categories.flansmod"));
    public static final Lazy<AxisMapping> ROLL_GAMEPAD_AXIS = Lazy.of(() -> new AxisMapping("axis.flansmod.roll", IN_VEHICLE, AxisMappingType.GamepadAxis, 0, "key.categories.flansmod"));
    public static final Lazy<AxisMapping> PITCH_GAMEPAD_AXIS = Lazy.of(() -> new AxisMapping("axis.flansmod.pitch", IN_VEHICLE, AxisMappingType.GamepadAxis, 1, "key.categories.flansmod"));
    public static final Lazy<AxisMapping> YAW_GAMEPAD_AXIS = Lazy.of(() -> new AxisMapping("axis.flansmod.yaw", IN_VEHICLE, AxisMappingType.GamepadAxis, 2, "key.categories.flansmod"));
    public static final Lazy<AxisMapping> FORWARD_GAMEPAD_AXIS = Lazy.of(() -> new AxisMapping("axis.flansmod.forward", IN_VEHICLE, AxisMappingType.GamepadAxis, 5, "key.categories.flansmod"));
    public static final Lazy<AxisMapping> STRAFE_RIGHT_GAMEPAD_AXIS = Lazy.of(() -> new AxisMapping("axis.flansmod.right", IN_VEHICLE, AxisMappingType.GamepadAxis, -1, "key.categories.flansmod"));
    public static final Lazy<AxisMapping> STRAFE_UP_GAMEPAD_AXIS = Lazy.of(() -> new AxisMapping("axis.flansmod.up", IN_VEHICLE, AxisMappingType.GamepadAxis, 3, "key.categories.flansmod"));

    public record AxisMapping(@Nonnull String name, @Nonnull IKeyConflictContext context, @Nonnull AxisMappingType mappingType, int axisID, @Nonnull String category) {
    }

    public static enum AxisMappingType {
        MouseAxis,
        GamepadAxis;

    }

    public static class KeyConflictContextHoldingGun
    implements IKeyConflictContext {
        public boolean isActive() {
            ShooterContext context = ShooterContext.of((Entity)Minecraft.m_91087_().f_91074_);
            return context.IsValid() && context.GetNumValidContexts() > 0;
        }

        public boolean conflicts(@Nonnull IKeyConflictContext other) {
            return this == other;
        }
    }

    public static class KeyConflictContextInVehicle
    implements IKeyConflictContext {
        public boolean isActive() {
            return Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20202_() instanceof VehicleEntity;
        }

        public boolean conflicts(@Nonnull IKeyConflictContext other) {
            return this == other;
        }
    }
}

