/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui.crafting;

import com.flansmod.client.gui.crafting.WorkbenchScreenTab;
import com.flansmod.common.crafting.ingredients.StackedIngredient;
import com.flansmod.common.crafting.menus.WorkbenchMenuPartCrafting;
import com.flansmod.common.crafting.recipes.PartFabricationRecipe;
import com.flansmod.common.item.PartItem;
import com.flansmod.common.types.crafting.EMaterialType;
import com.flansmod.common.types.crafting.MaterialDefinition;
import com.flansmod.physics.common.util.Maths;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class WorkbenchScreenTabPartCrafting
extends WorkbenchScreenTab<WorkbenchMenuPartCrafting> {
    public static final ResourceLocation PARTS_BG = new ResourceLocation("flansmod", "textures/gui/part_fabrication_large.png");
    public static final int PARTS_W = 512;
    public static final int PARTS_H = 256;
    private static final int PART_RECIPE_VIEWER_ROWS = 2;
    private static final int PART_RECIPE_VIEWER_COLUMNS = 8;
    private static final int PART_CRAFTING_NUM_INPUT_SLOTS_X = 4;
    private static final int PART_CRAFTING_NUM_INPUT_SLOTS_Y = 11;
    private static final int PART_CRAFTING_NUM_OUTPUT_SLOTS_X = 4;
    private static final int PART_CRAFTING_NUM_OUTPUT_SLOTS_Y = 6;
    private static final int PART_CRAFTING_INPUT_SLOTS_X = 5;
    private static final int PART_CRAFTING_INPUT_SLOTS_Y = 18;
    private static final int PART_CRAFTING_OUTPUT_SLOTS_X = 279;
    private static final int PART_CRAFTING_OUTPUT_SLOTS_Y = 115;
    private static final int PART_RECIPE_VIEWER_ORIGIN_X = 103;
    private static final int PART_RECIPE_VIEWER_ORIGIN_Y = 17;
    private static final int BLUEPRINT_ORIGIN_X = 98;
    private static final int BLUEPRINT_ORIGIN_Y = 64;
    private static final int QUEUE_VIEWER_NUM_ENTRIES_Y = 4;
    private static final int QUEUE_VIEWER_ORIGIN_X = 279;
    private static final int QUEUE_VIEWER_ORIGIN_Y = 17;
    protected float ShowPotentialMatchTicker = 0.0f;
    private float partSelectorScrollOffset = 0.0f;
    private int SelectedPartIndex = -1;
    private int CachedMaxPartsCraftable = 0;
    private Button[] PartSelectionButtons;
    private Button[] PartCraftingButtons;
    private Button[] PartQueueCancelButtons;
    public static final int CRAFT_BULK_AMOUNT = 8;
    private final List<ResourceKey<Item>> TagFilters = new ArrayList<ResourceKey<Item>>();
    private final List<Integer> TierFilters = new ArrayList<Integer>();
    private final List<EMaterialType> MaterialFilters = new ArrayList<EMaterialType>();
    private boolean OnlyCraftableFilter = false;
    private final List<Pair<Integer, PartFabricationRecipe>> FilteredPartsList = new ArrayList<Pair<Integer, PartFabricationRecipe>>();

    public WorkbenchScreenTabPartCrafting(@Nonnull WorkbenchMenuPartCrafting menu, @Nonnull Inventory inventory, @Nonnull Component title) {
        super(menu, inventory, title);
        this.f_97726_ = 356;
        this.f_97730_ = 97;
        this.f_97728_ = 97;
    }

    @Override
    protected boolean IsTabPresent() {
        return ((WorkbenchMenuPartCrafting)this.Workbench).Def.partCrafting.isActive;
    }

    @Override
    @Nonnull
    protected Component GetTitle() {
        return Component.m_237115_((String)"workbench.tab_part_crafting");
    }

    @Override
    protected void InitTab() {
        this.PartSelectionButtons = new Button[16];
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 8; ++i) {
                int index = j * 8 + i;
                this.PartSelectionButtons[index] = Button.m_253074_((Component)Component.m_237119_(), t -> this.SelectPartRecipe(index)).m_252987_(this.xOrigin + 103 + 18 * i, this.yOrigin + 17 + 18 * j, 18, 18).m_253136_();
                this.m_7787_((GuiEventListener)this.PartSelectionButtons[index]);
            }
        }
        this.PartCraftingButtons = new Button[3];
        this.PartCraftingButtons[0] = Button.m_253074_((Component)Component.m_237119_(), t -> this.CraftSelectedPart(1)).m_252987_(this.xOrigin + 98 + 105, this.yOrigin + 64 + 25, 17, 17).m_253136_();
        this.m_7787_((GuiEventListener)this.PartCraftingButtons[0]);
        this.PartCraftingButtons[1] = Button.m_253074_((Component)Component.m_237119_(), t -> this.CraftSelectedPart(8)).m_252987_(this.xOrigin + 98 + 105 + 18, this.yOrigin + 64 + 25, 17, 17).m_253136_();
        this.m_7787_((GuiEventListener)this.PartCraftingButtons[1]);
        this.PartCraftingButtons[2] = Button.m_253074_((Component)Component.m_237119_(), t -> this.CraftSelectedPart(-1)).m_252987_(this.xOrigin + 98 + 105 + 36, this.yOrigin + 64 + 25, 17, 17).m_253136_();
        this.m_7787_((GuiEventListener)this.PartCraftingButtons[2]);
        this.PartQueueCancelButtons = new Button[4];
        for (int i = 0; i < 4; ++i) {
            int index = i;
            this.PartQueueCancelButtons[i] = Button.m_253074_((Component)Component.m_237119_(), t -> this.CancelPartCrafting(index)).m_252987_(this.xOrigin + 279 + 56, this.yOrigin + 17 + 2 + i * 18, 9, 9).m_253136_();
            this.m_7787_((GuiEventListener)this.PartQueueCancelButtons[i]);
        }
        this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), t -> {
            this.OnlyCraftableFilter = !this.OnlyCraftableFilter;
            this.UpdatePartCraftingFilters();
        }).m_252987_(this.xOrigin + 98 + 2, this.yOrigin + 64 - 9, 6, 6).m_253136_());
        this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), t -> {
            if (this.TierFilters.contains(1)) {
                this.TierFilters.remove((Object)1);
            } else {
                this.TierFilters.add(1);
            }
            this.UpdatePartCraftingFilters();
        }).m_252987_(this.xOrigin + 98 + 62, this.yOrigin + 64 - 9, 6, 6).m_253136_());
        this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), t -> {
            if (this.TierFilters.contains(2)) {
                this.TierFilters.remove((Object)2);
            } else {
                this.TierFilters.add(2);
            }
            this.UpdatePartCraftingFilters();
        }).m_252987_(this.xOrigin + 98 + 82, this.yOrigin + 64 - 9, 6, 6).m_253136_());
        this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), t -> {
            if (this.TierFilters.contains(3)) {
                this.TierFilters.remove((Object)3);
            } else {
                this.TierFilters.add(3);
            }
            this.UpdatePartCraftingFilters();
        }).m_252987_(this.xOrigin + 98 + 102, this.yOrigin + 64 - 9, 6, 6).m_253136_());
        this.UpdatePartCraftingFilters();
        this.UpdateActivePartSelectionButtons();
    }

    @Override
    protected void OnTabSelected(boolean selected) {
        this.UpdatePartCraftingFilters();
    }

    @Override
    protected void UpdateTab(boolean selected) {
        this.ShowPotentialMatchTicker += 0.05f;
    }

    @Override
    protected boolean OnMouseScroll(int xMouse, int yMouse, double scroll) {
        if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 103, 150, this.yOrigin + 17, 36)) {
            int numRows = Maths.max(this.FilteredPartsList.size() / 8 - 2 + 1, 0);
            this.partSelectorScrollOffset = (float)((double)this.partSelectorScrollOffset - scroll);
            this.partSelectorScrollOffset = Maths.clamp(this.partSelectorScrollOffset, 0.0f, (float)numRows);
            this.UpdateActivePartSelectionButtons();
            return true;
        }
        return false;
    }

    @Override
    protected int GetWidth() {
        return 356;
    }

    @Override
    protected boolean RenderTooltip(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        int i;
        List<PartFabricationRecipe> recipes;
        PartFabricationRecipe recipe;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return false;
        }
        int craftingSelection = this.SelectedPartIndex;
        if (craftingSelection != -1 && (recipe = (recipes = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetAllPartRecipes((Level)level)).get(craftingSelection)) != null) {
            int[] matching = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetQuantityOfEachIngredientForRecipe((Level)level, craftingSelection);
            int[] required = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetRequiredOfEachIngredientForRecipe((Level)level, craftingSelection);
            for (int i2 = 0; i2 < recipe.m_7527_().size(); ++i2) {
                if (!WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 6 + 25 * i2, 25, this.yOrigin + 64 + 18, 23)) continue;
                graphics.m_280677_(this.font, recipe.GenerateTooltip(i2, required[i2], matching[i2]), Optional.empty(), xMouse, yMouse);
                return true;
            }
            if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 105, 17, this.yOrigin + 64 + 25, 17)) {
                graphics.m_280557_(this.font, (Component)Component.m_237115_((String)"workbench.craft.1"), xMouse, yMouse);
                return true;
            }
            if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 105 + 18, 17, this.yOrigin + 64 + 25, 17)) {
                graphics.m_280557_(this.font, (Component)Component.m_237110_((String)"workbench.craft.n", (Object[])new Object[]{8}), xMouse, yMouse);
                return true;
            }
            if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 105 + 36, 17, this.yOrigin + 64 + 25, 17)) {
                int maxCanCraft = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetMaxPartsCraftableFromInput((Level)level, this.SelectedPartIndex);
                graphics.m_280557_(this.font, (Component)Component.m_237110_((String)"workbench.craft.all", (Object[])new Object[]{maxCanCraft}), xMouse, yMouse);
                return true;
            }
        }
        for (i = 0; i < 4; ++i) {
            int craftingCount;
            List<PartFabricationRecipe> recipes2;
            PartFabricationRecipe recipe2;
            int queueSelection = ((WorkbenchMenuPartCrafting)this.Workbench).WorkbenchData.m_6413_(10 + i);
            if (queueSelection == -1 || (recipe2 = (recipes2 = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetAllPartRecipes((Level)level)).get(queueSelection)) == null || !WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 279, 67, this.yOrigin + 17 + 18 * i, 18) || (craftingCount = ((WorkbenchMenuPartCrafting)this.Workbench).WorkbenchData.m_6413_(5 + i)) == 0) continue;
            int craftingTime = ((WorkbenchMenuPartCrafting)this.Workbench).WorkbenchData.m_6413_(3);
            int craftingDuration = ((WorkbenchMenuPartCrafting)this.Workbench).WorkbenchData.m_6413_(4);
            graphics.m_280557_(this.font, (Component)Component.m_237110_((String)"crafting.parts.num_in_progress.named", (Object[])new Object[]{craftingCount, recipe2.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41786_()}), xMouse, yMouse);
            return true;
        }
        for (i = 0; i < 8; ++i) {
            for (int j = 0; j < 2; ++j) {
                int index;
                if (!WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 103 + i * 18, 18, this.yOrigin + 17 + 18 * j, 18) || (index = (Maths.floor(this.partSelectorScrollOffset) + j) * 8 + i) >= this.FilteredPartsList.size()) continue;
                graphics.m_280557_(this.font, ((PartFabricationRecipe)this.FilteredPartsList.get(index).getSecond()).m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41786_(), xMouse, yMouse);
                return true;
            }
        }
        if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 2, 6, this.yOrigin + 64 - 9, 6)) {
            graphics.m_280557_(this.font, (Component)Component.m_237115_((String)"crafting.parts.filter.only_craftable"), xMouse, yMouse);
            return true;
        }
        if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 62, 6, this.yOrigin + 64 - 9, 6)) {
            graphics.m_280557_(this.font, (Component)Component.m_237110_((String)"crafting.parts.filter.match_tier", (Object[])new Object[]{1}), xMouse, yMouse);
            return true;
        }
        if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 82, 6, this.yOrigin + 64 - 9, 6)) {
            graphics.m_280557_(this.font, (Component)Component.m_237110_((String)"crafting.parts.filter.match_tier", (Object[])new Object[]{2}), xMouse, yMouse);
            return true;
        }
        if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 102, 6, this.yOrigin + 64 - 9, 6)) {
            graphics.m_280557_(this.font, (Component)Component.m_237110_((String)"crafting.parts.filter.match_tier", (Object[])new Object[]{3}), xMouse, yMouse);
            return true;
        }
        return false;
    }

    @Override
    protected void RenderBG(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        List<PartFabricationRecipe> recipes;
        PartFabricationRecipe recipe;
        int j;
        graphics.m_280163_(PARTS_BG, this.xOrigin, this.yOrigin, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (j = 0; j < 11; ++j) {
            int numSlotsOnThisRow = Maths.min(((WorkbenchMenuPartCrafting)this.Workbench).PartCraftingInputContainer.m_6643_() - j * 4, 4);
            if (numSlotsOnThisRow <= 0) continue;
            graphics.m_280163_(PARTS_BG, this.xOrigin + 5, this.yOrigin + 18 + 18 * j, 97.0f, 136.0f, 18 * numSlotsOnThisRow, 18, 512, 256);
        }
        for (j = 0; j < 6; ++j) {
            int numOutputSlotsOnThisRow = Maths.min(((WorkbenchMenuPartCrafting)this.Workbench).PartCraftingOutputContainer.m_6643_() - j * 4, 4);
            if (numOutputSlotsOnThisRow <= 0) continue;
            graphics.m_280163_(PARTS_BG, this.xOrigin + 279, this.yOrigin + 115 + 18 * j, 97.0f, 136.0f, 18 * numOutputSlotsOnThisRow, 18, 512, 256);
        }
        int maxProduce = 0;
        int craftingSelection = this.SelectedPartIndex;
        if (craftingSelection != -1 && (recipe = (recipes = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetAllPartRecipes((Level)level)).get(craftingSelection)) != null) {
            int[] matching = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetQuantityOfEachIngredientForRecipe((Level)level, craftingSelection);
            int[] required = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetRequiredOfEachIngredientForRecipe((Level)level, craftingSelection);
            for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                Ingredient ingredient = (Ingredient)recipe.m_7527_().get(i);
                maxProduce = matching[i] / required[i];
                boolean isLast = i == recipe.m_7527_().size() - 1;
                graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 6 + 25 * i, this.yOrigin + 64 + 23, 275.0f, 233.0f, isLast ? 18 : 25, 18, 512, 256);
                graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 6 + 25 * i, this.yOrigin + 64 + 18, 275.0f, 228.0f, 24, 4, 512, 256);
                graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 6 + 25 * i, this.yOrigin + 64 + 18, 275.0f, 222.0f, 1 + 3 * Maths.clamp(maxProduce, 0, 5), 4, 512, 256);
                if (maxProduce > 5) {
                    graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 23 + 25 * i, this.yOrigin + 64 + 18, 292.0f, 223.0f, 3, 3, 512, 256);
                }
                if (maxProduce <= 10) continue;
                graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 27 + 25 * i, this.yOrigin + 64 + 18, 292.0f, 223.0f, 3, 3, 512, 256);
            }
        }
        for (int i = 0; i < 4; ++i) {
            int craftingCount;
            List<PartFabricationRecipe> recipes2;
            PartFabricationRecipe recipe2;
            int queueSelection = ((WorkbenchMenuPartCrafting)this.Workbench).WorkbenchData.m_6413_(10 + i);
            if (queueSelection == -1 || (recipe2 = (recipes2 = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetAllPartRecipes((Level)level)).get(queueSelection)) == null || (craftingCount = ((WorkbenchMenuPartCrafting)this.Workbench).WorkbenchData.m_6413_(5 + i)) == 0) continue;
            graphics.m_280163_(PARTS_BG, this.xOrigin + 279, this.yOrigin + 17 + 18 * i, 357.0f, 1.0f, 67, 18, 512, 256);
            if (i == 0) {
                int craftingTime = ((WorkbenchMenuPartCrafting)this.Workbench).WorkbenchData.m_6413_(3);
                int craftingDuration = ((WorkbenchMenuPartCrafting)this.Workbench).WorkbenchData.m_6413_(4);
                graphics.m_280163_(PARTS_BG, this.xOrigin + 279 + 18, this.yOrigin + 17 + 13, 375.0f, 21.0f, Maths.ceil(48.0f * (1.0f - (float)craftingTime / (float)craftingDuration)), 4, 512, 256);
            }
            if (craftingCount == -1) {
                graphics.m_280163_(PARTS_BG, this.xOrigin + 279 + 29, this.yOrigin + 17 + 3 + 18 * i, 450.0f, 3.0f, 13, 9, 512, 256);
            }
            if (!WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 279 + 56, 9, this.yOrigin + 17 + 2, 9)) continue;
            graphics.m_280163_(PARTS_BG, this.xOrigin + 279 + 56, this.yOrigin + 17 + 2, 426.0f, 3.0f, 9, 9, 512, 256);
        }
        if (maxProduce < 1) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 105, this.yOrigin + 64 + 25, 357.0f, 218.0f, 17, 17, 512, 256);
        } else if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 105, 17, this.yOrigin + 64 + 25, 17)) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 105, this.yOrigin + 64 + 25, 357.0f, 236.0f, 17, 17, 512, 256);
        }
        if (maxProduce < 8) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 123, this.yOrigin + 64 + 25, 375.0f, 218.0f, 17, 17, 512, 256);
        } else if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 123, 17, this.yOrigin + 64 + 25, 17)) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 123, this.yOrigin + 64 + 25, 375.0f, 236.0f, 17, 17, 512, 256);
        }
        if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 141, 17, this.yOrigin + 64 + 25, 17)) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 141, this.yOrigin + 64 + 25, 411.0f, 236.0f, 17, 17, 512, 256);
        }
        if (this.OnlyCraftableFilter) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 2, this.yOrigin + 64 - 9, 359.0f, 29.0f, 6, 6, 512, 256);
        }
        if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 2, 6, this.yOrigin + 64 - 9, 6)) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 2, this.yOrigin + 64 - 9, 359.0f, 36.0f, 6, 6, 512, 256);
        }
        if (this.TierFilters.contains(1)) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 62, this.yOrigin + 64 - 9, 359.0f, 29.0f, 6, 6, 512, 256);
        }
        if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 62, 6, this.yOrigin + 64 - 9, 6)) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 62, this.yOrigin + 64 - 9, 359.0f, 36.0f, 6, 6, 512, 256);
        }
        if (this.TierFilters.contains(2)) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 82, this.yOrigin + 64 - 9, 359.0f, 29.0f, 6, 6, 512, 256);
        }
        if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 82, 6, this.yOrigin + 64 - 9, 6)) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 82, this.yOrigin + 64 - 9, 359.0f, 36.0f, 6, 6, 512, 256);
        }
        if (this.TierFilters.contains(3)) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 102, this.yOrigin + 64 - 9, 359.0f, 29.0f, 6, 6, 512, 256);
        }
        if (WorkbenchScreenTabPartCrafting.InBox(xMouse, yMouse, this.xOrigin + 98 + 102, 6, this.yOrigin + 64 - 9, 6)) {
            graphics.m_280163_(PARTS_BG, this.xOrigin + 98 + 102, this.yOrigin + 64 - 9, 359.0f, 36.0f, 6, 6, 512, 256);
        }
        for (int j2 = 0; j2 < 2; ++j2) {
            int rowIndex = Maths.floor(this.partSelectorScrollOffset) + j2;
            int numSlotsOnThisRow = Maths.min(this.FilteredPartsList.size() - j2 * 8, 8);
            if (numSlotsOnThisRow <= 0) continue;
            graphics.m_280163_(PARTS_BG, this.xOrigin + 103, this.yOrigin + 17 + 18 * j2, 97.0f, 217.0f, 18 * numSlotsOnThisRow, 18, 512, 256);
            for (int i = 0; i < numSlotsOnThisRow; ++i) {
                Pair<Integer, PartFabricationRecipe> recipe3 = this.FilteredPartsList.get(j2 * 8 + i);
                int maxCraftable = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetMaxPartsCraftableFromInput((Level)level, (Integer)recipe3.getFirst());
                if (maxCraftable > 0) continue;
                graphics.m_280163_(PARTS_BG, this.xOrigin + 103 + 18 * i, this.yOrigin + 17 + 18 * j2, 359.0f, 43.0f, 18, 18, 512, 256);
            }
        }
        int numRows = this.FilteredPartsList.size() / 8 - 2 + 1;
        this.RenderScrollbar(graphics, this.xOrigin + 103 + 144, this.yOrigin + 17, 6, 36, this.partSelectorScrollOffset, 0.0f, numRows);
    }

    @Override
    protected void RenderFG(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        List<PartFabricationRecipe> recipes;
        PartFabricationRecipe recipe;
        int craftingSelection;
        graphics.m_280614_(this.font, (Component)Component.m_237115_((String)"workbench.input"), 5, 7, 0x404040, false);
        graphics.m_280614_(this.font, (Component)Component.m_237115_((String)"workbench.queue"), 279, 5, 0x404040, false);
        graphics.m_280614_(this.font, (Component)Component.m_237115_((String)"workbench.output"), 279, 104, 0x404040, false);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (this.SelectedPartIndex >= 0 && this.SelectedPartIndex < ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetAllPartRecipes((Level)level).size()) {
            ItemStack selectedPart = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetAllPartRecipes((Level)level).get(this.SelectedPartIndex).m_8043_((RegistryAccess)RegistryAccess.f_243945_);
            List wordWrap = this.font.m_92923_((FormattedText)selectedPart.m_41786_(), 151);
            graphics.m_280649_(this.font, (FormattedCharSequence)wordWrap.get(0), 104, 70, 0xFFFFFF, false);
        }
        if ((craftingSelection = this.SelectedPartIndex) != -1 && (recipe = (recipes = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetAllPartRecipes((Level)level)).get(craftingSelection)) != null) {
            for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                Ingredient ingredient = (Ingredient)recipe.m_7527_().get(i);
                ItemStack[] possibleInputs = ingredient.m_43908_();
                if (possibleInputs.length <= 0) continue;
                int pick = Maths.modulo(Maths.floor(this.ShowPotentialMatchTicker), possibleInputs.length);
                ItemStack possibleInput = ingredient.m_43908_()[pick];
                if (possibleInput.m_41619_()) continue;
                int slotX = 105 + 25 * i;
                int slotY = 88;
                graphics.m_280480_(possibleInput, slotX, slotY);
                if (!(ingredient instanceof StackedIngredient)) continue;
                StackedIngredient stacked = (StackedIngredient)ingredient;
                int countPerItem = stacked.Count(possibleInput);
                int countTarget = stacked.Count;
                if (countPerItem == 0) continue;
                int multi = countTarget / countPerItem;
                int remainder = countTarget % countPerItem;
                if (multi <= 0) {
                    graphics.m_280302_(this.font, possibleInput, slotX, slotY, "<1");
                    continue;
                }
                if (remainder == 0) {
                    graphics.m_280302_(this.font, possibleInput, slotX, slotY, "" + multi);
                    continue;
                }
                graphics.m_280302_(this.font, possibleInput, slotX, slotY, "<" + (multi + 1));
            }
        }
        for (int i = 0; i < 4; ++i) {
            int craftingCount;
            List<PartFabricationRecipe> recipes2;
            PartFabricationRecipe recipe2;
            int queueSelection = ((WorkbenchMenuPartCrafting)this.Workbench).WorkbenchData.m_6413_(10 + i);
            if (queueSelection == -1 || (recipe2 = (recipes2 = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetAllPartRecipes((Level)level)).get(queueSelection)) == null || (craftingCount = ((WorkbenchMenuPartCrafting)this.Workbench).WorkbenchData.m_6413_(5 + i)) == 0) continue;
            int stackCount = craftingCount > 0 ? craftingCount : 1;
            ItemStack queueStack = recipe2.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_255036_(recipe2.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41613_() * stackCount);
            this.RenderGUIItem(graphics, 280, 18 + 18 * i, queueStack, true);
        }
        int firstRow = Maths.floor(this.partSelectorScrollOffset);
        for (int row = 0; row < 2; ++row) {
            int firstIndexInRow = (firstRow + row) * 8;
            for (int col = 0; col < 8; ++col) {
                int index = firstIndexInRow + col;
                if (0 > index || index >= this.FilteredPartsList.size()) continue;
                ItemStack entry = ((PartFabricationRecipe)this.FilteredPartsList.get(index).getSecond()).m_8043_((RegistryAccess)RegistryAccess.f_243945_);
                this.RenderGUIItem(graphics, 104 + 18 * col, 18 + 18 * row, entry, true);
            }
        }
    }

    private void UpdatePartCraftingFilters() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        this.FilteredPartsList.clear();
        List<PartFabricationRecipe> allRecipes = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetAllPartRecipes((Level)level);
        for (int i = 0; i < allRecipes.size(); ++i) {
            int numCraftable;
            PartFabricationRecipe recipe = allRecipes.get(i);
            Item item = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_();
            if (item instanceof PartItem) {
                PartItem partItem = (PartItem)item;
                MaterialDefinition material = partItem.Def().GetMaterial();
                if (this.TierFilters.size() > 0 && !this.TierFilters.contains(material.craftingTier)) continue;
            }
            if (this.OnlyCraftableFilter && (numCraftable = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetMaxPartsCraftableFromInput((Level)level, i)) <= 0) continue;
            this.FilteredPartsList.add((Pair<Integer, PartFabricationRecipe>)Pair.of((Object)i, (Object)allRecipes.get(i)));
        }
        int maxScroll = Maths.max(this.FilteredPartsList.size() / 8 - 2, 0);
        if (this.partSelectorScrollOffset > (float)maxScroll) {
            this.partSelectorScrollOffset = maxScroll;
        }
        this.UpdateActivePartSelectionButtons();
    }

    private void UpdateActivePartSelectionButtons() {
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (this.PartSelectionButtons != null) {
            for (int j = 0; j < 2; ++j) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    int firstIndex = Maths.floor(this.partSelectorScrollOffset) * 8;
                    int relativeIndex = i2 + 8 * j;
                    this.PartSelectionButtons[relativeIndex].f_93623_ = this.IsActive && firstIndex + relativeIndex < this.FilteredPartsList.size();
                }
            }
        }
        if (this.PartCraftingButtons != null) {
            for (i = 0; i < 3; ++i) {
                if (i == 2) {
                    this.PartCraftingButtons[i].f_93623_ = true;
                    continue;
                }
                int numButtonRepresents = i == 1 ? 5 : 1;
                int numCanCraft = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetMaxPartsCraftableFromInput((Level)level, this.SelectedPartIndex);
                this.PartCraftingButtons[i].f_93623_ = this.IsActive && this.SelectedPartIndex != -1 && numCanCraft >= numButtonRepresents;
            }
        }
        if (this.PartQueueCancelButtons != null) {
            for (i = 0; i < 4; ++i) {
                int queueSize = ((WorkbenchMenuPartCrafting)this.Workbench).WorkbenchData.m_6413_(5 + i);
                this.PartQueueCancelButtons[i].f_93623_ = this.IsActive && queueSize != 0;
            }
        }
    }

    private void SelectPartRecipe(int relativeIndex) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        int filteredIndex = Maths.floor(this.partSelectorScrollOffset) * 8 + relativeIndex;
        if (filteredIndex >= this.FilteredPartsList.size()) {
            filteredIndex = -1;
        }
        this.SelectedPartIndex = (Integer)this.FilteredPartsList.get(filteredIndex).getFirst();
        this.NetworkedButtonPress(32 + this.SelectedPartIndex);
        this.CachedMaxPartsCraftable = ((WorkbenchMenuPartCrafting)this.Workbench).Workbench.GetMaxPartsCraftableFromInput((Level)level, this.SelectedPartIndex);
        this.UpdateActivePartSelectionButtons();
    }

    private void CraftSelectedPart(int count) {
        if (count <= 0) {
            this.NetworkedButtonPress(15);
        } else {
            this.NetworkedButtonPress(0 + (count - 1));
        }
    }

    private void CancelPartCrafting(int queueIndex) {
        this.NetworkedButtonPress(16 + queueIndex);
    }
}

