/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui.crafting;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.gui.crafting.WorkbenchScreenTab;
import com.flansmod.common.FlansMod;
import com.flansmod.common.crafting.AbstractWorkbench;
import com.flansmod.common.crafting.menus.WorkbenchMenuPainting;
import com.flansmod.common.item.FlanItem;
import com.flansmod.common.types.elements.PaintableDefinition;
import com.flansmod.common.types.elements.PaintjobDefinition;
import com.flansmod.physics.common.util.Maths;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WorkbenchScreenTabPainting
extends WorkbenchScreenTab<WorkbenchMenuPainting> {
    private static final ResourceLocation MOD_BG = new ResourceLocation("flansmod", "textures/gui/painting_table.png");
    private static final int MOD_W = 256;
    private static final int MOD_H = 256;
    private static final int PAINT_BUCKET_SLOT_ORIGIN_X = 150;
    private static final int PAINT_BUCKET_SLOT_ORIGIN_Y = 18;
    private static final int GUN_SLOT_ORIGIN_X = 13;
    private static final int GUN_SLOT_ORIGIN_Y = 18;
    private static final int SKIN_SELECTOR_ORIGIN_X = 18;
    private static final int SKIN_SELECTOR_ORIGIN_Y = 40;
    private static final int SKINS_PER_ROW = 8;
    private static final int SKIN_ROWS = 2;
    private final Button[] SkinButtons = new Button[16];
    private static final int PREMIUM_SKIN_SELECTOR_ORIGIN_X = 35;
    private static final int PREMIUM_SKIN_SELECTOR_ORIGIN_Y = 91;
    private static final int PREMIUM_SKINS_PER_ROW = 4;
    private static final int PREMIUM_SKIN_ROWS = 1;
    private final Button[] PremiumSkinButtons = new Button[16];
    private static final int PREMIUM_DETAILS_BUTTON_X = 6;
    private static final int PREMIUM_DETAILS_BUTTON_Y = 88;
    private Button PremiumDetailsButton;
    private float GunAngle = 2.0f;
    private float GunAngularVelocity = 5.0f;

    public WorkbenchScreenTabPainting(@Nonnull WorkbenchMenuPainting menu, @Nonnull Inventory inventory, @Nonnull Component title) {
        super(menu, inventory, title);
        this.f_97726_ = 180;
        this.f_97728_ += 4;
        this.f_97730_ += 4;
    }

    @Override
    protected boolean IsTabPresent() {
        return ((WorkbenchMenuPainting)this.Workbench).Def.painting.isActive;
    }

    @Override
    @Nonnull
    protected Component GetTitle() {
        return Component.m_237115_((String)"workbench.tab_painting");
    }

    @Override
    protected void InitTab() {
        if (this.IsTabPresent()) {
            int index;
            int j;
            int i;
            for (i = 0; i < 8; ++i) {
                for (j = 0; j < 2; ++j) {
                    index = i + j * 8;
                    this.SkinButtons[index] = Button.m_253074_((Component)Component.m_237119_(), t -> this.NetworkedButtonPress(0 + index)).m_252987_(this.xOrigin + 18 + 18 * i, this.yOrigin + 40 + 18 * j, 18, 18).m_253136_();
                    this.m_7787_((GuiEventListener)this.SkinButtons[index]);
                }
            }
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 1; ++j) {
                    index = i + j * 4;
                    this.PremiumSkinButtons[index] = Button.m_253074_((Component)Component.m_237119_(), t -> this.NetworkedButtonPress(128 + index)).m_252987_(this.xOrigin + 35 + 18 * i, this.yOrigin + 91 + 18 * j, 18, 18).m_253136_();
                    this.m_7787_((GuiEventListener)this.PremiumSkinButtons[index]);
                }
            }
            this.PremiumDetailsButton = Button.m_253074_((Component)Component.m_237119_(), t -> {
                try {
                    Util.m_137581_().m_137650_(new URL("https://www.patreon.com/c/FlansGames"));
                }
                catch (Exception e) {
                    FlansMod.LOGGER.error("Failed to open Patreon page");
                }
            }).m_252987_(this.xOrigin + 6, this.yOrigin + 88, 24, 24).m_253136_();
            this.m_142416_((GuiEventListener)this.PremiumDetailsButton);
        }
    }

    @Override
    protected void OnTabSelected(boolean selected) {
        this.UpdateTab(selected);
    }

    @Override
    protected void UpdateTab(boolean selected) {
        this.GunAngularVelocity *= Maths.expF(-FlansModClient.FrameDeltaSeconds() * 0.0025f);
        this.GunAngle += FlansModClient.FrameDeltaSeconds() * this.GunAngularVelocity * 10.0f;
        if (this.IsTabPresent()) {
            int index;
            int i;
            FlanItem flanItem;
            PaintableDefinition paintableDef;
            Item item;
            int numSkinButtons = 0;
            int numPremiumSkinButtons = 0;
            if (selected && ((WorkbenchMenuPainting)this.Workbench).GunContainer.m_6643_() > 0 && (item = ((WorkbenchMenuPainting)this.Workbench).GunContainer.m_8020_(0).m_41720_()) instanceof FlanItem && (paintableDef = (flanItem = (FlanItem)item).GetPaintDef()).IsValid()) {
                numSkinButtons = paintableDef.getBasicPaintjobs().size() + 1;
                numPremiumSkinButtons = paintableDef.getPremiumPaintjobs().size();
            }
            for (i = 0; i < 8; ++i) {
                for (int j = 0; j < 2; ++j) {
                    index = i + j * 8;
                    if (this.SkinButtons[index] == null) continue;
                    this.SkinButtons[index].f_93623_ = index < numSkinButtons;
                }
            }
            for (i = 0; i < 4; ++i) {
                for (int j = 0; j < 1; ++j) {
                    index = i + j * 4;
                    if (this.PremiumSkinButtons[index] == null) continue;
                    this.PremiumSkinButtons[index].f_93623_ = index < numPremiumSkinButtons;
                }
            }
        }
    }

    @Override
    protected boolean OnMouseScroll(int xMouse, int yMouse, double scroll) {
        if (scroll != 0.0 && xMouse < this.xOrigin) {
            this.GunAngularVelocity = (float)((double)this.GunAngularVelocity + scroll * 2.0);
            return true;
        }
        return false;
    }

    @Override
    protected boolean RenderTooltip(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        Item item;
        if (WorkbenchScreenTabPainting.InBox(xMouse, yMouse, this.xOrigin + 150, 18, this.yOrigin + 18, 18)) {
            graphics.m_280557_(this.font, (Component)Component.m_237115_((String)"workbench.slot.paint_can"), xMouse, yMouse);
            return true;
        }
        if (((WorkbenchMenuPainting)this.Workbench).GunContainer.m_6643_() >= 0 && !((WorkbenchMenuPainting)this.Workbench).GunContainer.m_7983_() && (item = ((WorkbenchMenuPainting)this.Workbench).GunContainer.m_8020_(0).m_41720_()) instanceof FlanItem) {
            FlanItem flanItem = (FlanItem)item;
            PaintableDefinition paintableDefinition = flanItem.GetPaintDef();
            if (paintableDefinition.paintjobs.length > 0) {
                if (WorkbenchScreenTabPainting.InBox(xMouse, yMouse, this.xOrigin + 18, 18, this.yOrigin + 40, 18)) {
                    ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                    lines.add(Component.m_237115_((String)"paintjob.default").m_7532_());
                    lines.add(Component.m_237115_((String)"paintjob.free_to_swap").m_7532_());
                    graphics.m_280245_(this.font, lines, xMouse, yMouse);
                    return true;
                }
                for (int p = 0; p < paintableDefinition.paintjobs.length; ++p) {
                    int xIndex = (p + 1) % 8;
                    int yIndex = (p + 1) / 8;
                    if (!WorkbenchScreenTabPainting.InBox(xMouse, yMouse, this.xOrigin + 18 + 18 * xIndex, 18, this.yOrigin + 40 + 18 * yIndex, 18)) continue;
                    ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                    lines.add(Component.m_237115_((String)("paintjob." + flanItem.DefinitionLocation.m_135827_() + "." + paintableDefinition.paintjobs[p].textureName)).m_7532_());
                    int paintCost = AbstractWorkbench.GetPaintUpgradeCost(((WorkbenchMenuPainting)this.Workbench).GunContainer, p + 1);
                    if (paintCost == 1) {
                        lines.add(Component.m_237115_((String)"paintjob.cost.1").m_7532_());
                    } else {
                        lines.add(Component.m_237110_((String)"paintjob.cost", (Object[])new Object[]{paintCost}).m_7532_());
                    }
                    graphics.m_280245_(this.font, lines, xMouse, yMouse);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void RenderBG(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        Item item;
        if (((WorkbenchMenuPainting)this.Workbench).GunContainer.m_6643_() > 0) {
            this.Render3DGun(graphics, this.xOrigin - 64, this.yOrigin + 64, this.GunAngle, -20.0f, ((WorkbenchMenuPainting)this.Workbench).GunContainer.m_8020_(0));
        }
        graphics.m_280163_(MOD_BG, this.xOrigin, this.yOrigin, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
        if (((WorkbenchMenuPainting)this.Workbench).GunContainer.m_6643_() >= 0 && !((WorkbenchMenuPainting)this.Workbench).GunContainer.m_7983_() && (item = ((WorkbenchMenuPainting)this.Workbench).GunContainer.m_8020_(0).m_41720_()) instanceof FlanItem) {
            FlanItem flanItem = (FlanItem)item;
            ItemStack gunStack = ((WorkbenchMenuPainting)this.Workbench).GunContainer.m_8020_(0);
            PaintableDefinition paintableDefinition = flanItem.GetPaintDef();
            if (paintableDefinition.paintjobs.length > 0) {
                if (FlanItem.GetPaintjobName(gunStack).equals("default")) {
                    graphics.m_280163_(MOD_BG, this.xOrigin + 18, this.yOrigin + 40, 180.0f, 201.0f, 18, 18, 256, 256);
                } else {
                    graphics.m_280163_(MOD_BG, this.xOrigin + 18, this.yOrigin + 40, 180.0f, 165.0f, 18, 18, 256, 256);
                }
                for (int p = 0; p < paintableDefinition.paintjobs.length; ++p) {
                    int xIndex = (p + 1) % 8;
                    int yIndex = (p + 1) / 8;
                    if (FlanItem.GetPaintjobName(gunStack).equals(paintableDefinition.paintjobs[p].textureName)) {
                        graphics.m_280163_(MOD_BG, this.xOrigin + 18 + 18 * xIndex, this.yOrigin + 40 + 18 * yIndex, 180.0f, 201.0f, 18, 18, 256, 256);
                        continue;
                    }
                    graphics.m_280163_(MOD_BG, this.xOrigin + 18 + 18 * xIndex, this.yOrigin + 40 + 18 * yIndex, 180.0f, 165.0f, 18, 18, 256, 256);
                }
            }
        }
    }

    @Override
    protected void RenderFG(@Nonnull GuiGraphics graphics, int xMouse, int yMouse) {
        if (((WorkbenchMenuPainting)this.Workbench).GunContainer.m_6643_() >= 0) {
            Item item;
            if (!((WorkbenchMenuPainting)this.Workbench).GunContainer.m_7983_() && (item = ((WorkbenchMenuPainting)this.Workbench).GunContainer.m_8020_(0).m_41720_()) instanceof FlanItem) {
                FlanItem flanItem = (FlanItem)item;
                ItemStack gunStack = ((WorkbenchMenuPainting)this.Workbench).GunContainer.m_8020_(0);
                PaintableDefinition paintableDefinition = flanItem.GetPaintDef();
                List<PaintjobDefinition> basic = paintableDefinition.getBasicPaintjobs();
                List<PaintjobDefinition> premium = paintableDefinition.getPremiumPaintjobs();
                if (basic.size() > 0) {
                    ItemStack paintedStack = gunStack.m_41777_();
                    FlanItem.SetPaintjobName(paintedStack, "default");
                    this.RenderGUIItem(graphics, 19, 41, paintedStack, false);
                    for (int p = 0; p < paintableDefinition.paintjobs.length; ++p) {
                        int xIndex = (p + 1) % 8;
                        int yIndex = (p + 1) / 8;
                        ItemStack paintedStack2 = gunStack.m_41777_();
                        FlanItem.SetPaintjobName(paintedStack2, paintableDefinition.paintjobs[p].textureName);
                        this.RenderGUIItem(graphics, 19 + 18 * xIndex, 41 + 18 * yIndex, paintedStack2, false);
                    }
                }
                if (premium.size() <= 0) {
                    graphics.m_280614_(this.font, (Component)Component.m_237115_((String)"workbench.paint.premium.header"), 35, 91, 0, false);
                    graphics.m_280614_(this.font, (Component)Component.m_237115_((String)"workbench.paint.premium.none_available"), 35, 101, 0x808080, false);
                }
                if (((WorkbenchMenuPainting)this.Workbench).PaintCanContainer.m_7983_()) {
                    MutableComponent insertHint = Component.m_237115_((String)"workbench.paint.hint.insert_paintcan");
                    graphics.m_280614_(this.font, (Component)insertHint, 146 - this.font.m_92852_((FormattedText)insertHint), 23, 0x808080, false);
                }
            } else {
                graphics.m_280614_(this.font, (Component)Component.m_237115_((String)"workbench.paint.premium.header"), 35, 91, 0, false);
                graphics.m_280614_(this.font, (Component)Component.m_237115_((String)"workbench.paint.premium.no_item"), 35, 101, 0x808080, false);
                MutableComponent insertHint = Component.m_237115_((String)"workbench.paint.hint.insert_gun");
                graphics.m_280614_(this.font, (Component)insertHint, 37, 23, 0x808080, false);
            }
        }
        graphics.m_280218_(MOD_BG, 9, 91, 188, 4, 16, 16);
    }
}

