/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record ExposureDataPartPacket(String id, int width, int height, CompoundTag properties, int offset, byte[] partBytes) implements IPacket
{
    public static final ResourceLocation ID = Exposure.resource("exposure_data_part");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.id);
        buffer.writeInt(this.width);
        buffer.writeInt(this.height);
        buffer.m_130079_(this.properties);
        buffer.writeInt(this.offset);
        buffer.m_130087_(this.partBytes);
        return buffer;
    }

    public static ExposureDataPartPacket fromBuffer(FriendlyByteBuf buffer) {
        return new ExposureDataPartPacket(buffer.m_130277_(), buffer.readInt(), buffer.readInt(), buffer.m_130261_(), buffer.readInt(), buffer.m_130052_());
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        direction.getExposureReceiver().receivePart(this.id, this.width, this.height, this.properties, this.offset, this.partBytes);
        return true;
    }
}

