/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.entity;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.item.PhotographItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PhotographFrameEntity
extends HangingEntity {
    public static final Logger LOGGER = Exposure.LOGGER;
    protected static final EntityDataAccessor<Integer> DATA_SIZE = SynchedEntityData.m_135353_(PhotographFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<ItemStack> DATA_FRAME_ITEM = SynchedEntityData.m_135353_(PhotographFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.m_135353_(PhotographFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Integer> DATA_ITEM_ROTATION = SynchedEntityData.m_135353_(PhotographFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> DATA_GLOWING = SynchedEntityData.m_135353_(PhotographFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DATA_STRIPPED = SynchedEntityData.m_135353_(PhotographFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int size = 0;

    public PhotographFrameEntity(EntityType<? extends PhotographFrameEntity> entityType, Level level) {
        super(entityType, level);
    }

    public PhotographFrameEntity(Level level, BlockPos pos, Direction facingDirection) {
        super(Exposure.EntityTypes.PHOTOGRAPH_FRAME.get(), level, pos);
        this.m_6022_(facingDirection);
        this.setItem(ItemStack.f_41583_);
    }

    public boolean m_6783_(double distance) {
        double d = (double)((Integer)Config.Client.PHOTOGRAPH_FRAME_CULLING_DISTANCE.get()).intValue() * PhotographFrameEntity.m_20150_();
        return distance < d * d;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_SIZE, (Object)0);
        this.m_20088_().m_135372_(DATA_FRAME_ITEM, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_ITEM, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_ITEM_ROTATION, (Object)0);
        this.m_20088_().m_135372_(DATA_STRIPPED, (Object)false);
        this.m_20088_().m_135372_(DATA_GLOWING, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
        if (key.equals(DATA_SIZE)) {
            this.size = (Integer)this.m_20088_().m_135370_(DATA_SIZE);
            this.m_7087_();
        }
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        int packedData = packet.m_131509_();
        int size = packedData >> 8 & 0xFF;
        int direction = packedData & 0xFF;
        this.setSize(size);
        this.m_6022_(Direction.m_122376_((int)direction));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        int packedData = this.size << 8 | this.f_31699_.m_122411_();
        return new ClientboundAddEntityPacket((Entity)this, packedData, this.m_31748_());
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        ItemStack frameItem;
        super.m_7380_(tag);
        ItemStack item = this.getItem();
        if (!item.m_41619_()) {
            tag.m_128365_("Item", (Tag)item.m_41739_(new CompoundTag()));
            tag.m_128379_("IsGlowing", this.isGlowing());
            tag.m_128344_("ItemRotation", (byte)this.getItemRotation());
        }
        if (!(frameItem = this.getFrameItem()).m_41619_()) {
            tag.m_128365_("FrameItem", (Tag)frameItem.m_41739_(new CompoundTag()));
        }
        tag.m_128344_("Size", (byte)this.getSize());
        tag.m_128344_("Facing", (byte)this.f_31699_.m_122411_());
        tag.m_128379_("Stripped", this.isStripped());
        tag.m_128379_("Invisible", this.m_20145_());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        CompoundTag itemTag;
        super.m_7378_(tag);
        CompoundTag frameItemTag = tag.m_128469_("FrameItem");
        if (!frameItemTag.m_128456_()) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)frameItemTag);
            if (itemstack.m_41619_()) {
                Exposure.LOGGER.warn("Unable to load frame item from: {}", (Object)frameItemTag);
                itemstack = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH_FRAME.get());
            }
            this.setFrameItem(itemstack);
        }
        if (!(itemTag = tag.m_128469_("Item")).m_128456_()) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)itemTag);
            if (itemstack.m_41619_()) {
                Exposure.LOGGER.warn("Unable to load item from: {}", (Object)itemTag);
            }
            this.setItem(itemstack);
            this.setGlowing(tag.m_128471_("IsGlowing"));
            this.setItemRotation(tag.m_128445_("ItemRotation"));
        }
        this.setSize(tag.m_128445_("Size"));
        this.m_6022_(Direction.m_122376_((int)tag.m_128445_("Facing")));
        this.setStripped(tag.m_128471_("Stripped"));
        this.m_6842_(tag.m_128471_("Invisible"));
    }

    @NotNull
    public Vec3 m_213870_() {
        return Vec3.m_82528_((Vec3i)this.f_31698_);
    }

    protected float m_6380_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return 0.0f;
    }

    public int m_7076_() {
        return this.getSize() * 16 + 16;
    }

    public int m_7068_() {
        return this.getSize() * 16 + 16;
    }

    @Nullable
    public ItemStack m_142340_() {
        ItemStack item = this.getItem();
        if (!item.m_41619_()) {
            return item.m_41777_();
        }
        return this.getFrameItem().m_41777_();
    }

    protected void m_7087_() {
        double heightOffset;
        if (this.f_31699_ == null) {
            return;
        }
        double x = (double)this.f_31698_.m_123341_() + 0.5;
        double y = (double)this.f_31698_.m_123342_() + 0.5;
        double z = (double)this.f_31698_.m_123343_() + 0.5;
        double widthOffset = this.m_7076_() % 32 == 0 ? 0.5 : 0.0;
        double d = heightOffset = this.m_7068_() % 32 == 0 ? 0.5 : 0.0;
        if (this.getSize() == 2) {
            widthOffset += 1.0;
            heightOffset += 1.0;
        }
        double hangOffset = 0.46875;
        if (this.m_6350_().m_122434_().m_122479_()) {
            x -= (double)this.m_6350_().m_122429_() * hangOffset;
            z -= (double)this.m_6350_().m_122431_() * hangOffset;
            Direction direction = this.m_6350_().m_122428_();
            this.m_20343_(x += widthOffset * (double)direction.m_122429_(), y += heightOffset, z += widthOffset * (double)direction.m_122431_());
            double xSize = this.m_7076_();
            double ySize = this.m_7068_();
            double zSize = this.m_7076_();
            if (this.m_6350_().m_122434_() == Direction.Axis.Z) {
                zSize = 1.0;
            } else {
                xSize = 1.0;
            }
            this.m_20011_(new AABB(x - (xSize /= 32.0), y - (ySize /= 32.0), z - (zSize /= 32.0), x + xSize, y + ySize, z + zSize));
        } else {
            this.m_20343_(x += widthOffset, y -= (double)this.m_6350_().m_122430_() * hangOffset, z -= heightOffset);
            double xSize = this.m_7076_();
            double zSize = this.m_7068_();
            this.m_20011_(new AABB(x - (xSize /= 32.0), y - 0.03125, z - (zSize /= 32.0), x + xSize, y + 0.03125, z + zSize));
        }
    }

    public boolean m_7088_() {
        if (!this.m_9236_().m_45786_((Entity)this)) {
            return false;
        }
        int sizeX = Math.max(1, this.m_7076_() / 16);
        int sizeY = Math.max(1, this.m_7068_() / 16);
        BlockPos baseBlockPos = this.f_31698_.m_121945_(this.f_31699_.m_122424_());
        if (this.m_6350_().m_122434_().m_122479_()) {
            Direction direction = this.m_6350_().m_122428_();
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
            for (int pX = 0; pX < sizeX; ++pX) {
                for (int pY = 0; pY < sizeY; ++pY) {
                    mPos.m_122190_((Vec3i)baseBlockPos).m_122175_(direction, pX).m_122175_(Direction.UP, pY);
                    BlockState blockState = this.m_9236_().m_8055_((BlockPos)mPos);
                    if (blockState.m_280296_() || DiodeBlock.m_52586_((BlockState)blockState)) continue;
                    return false;
                }
            }
        } else {
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
            for (int pX = 0; pX < sizeX; ++pX) {
                for (int pY = 0; pY < sizeY; ++pY) {
                    mPos.m_122190_((Vec3i)baseBlockPos).m_122175_(Direction.NORTH, pX).m_122175_(Direction.EAST, pY);
                    BlockState blockState = this.m_9236_().m_8055_((BlockPos)mPos);
                    if (blockState.m_280296_() || DiodeBlock.m_52586_((BlockState)blockState)) continue;
                    return false;
                }
            }
        }
        return this.m_9236_().m_6249_((Entity)this, this.m_20191_(), f_31697_).isEmpty();
    }

    protected void m_6022_(@NotNull Direction facingDirection) {
        Validate.notNull((Object)facingDirection);
        this.f_31699_ = facingDirection;
        if (facingDirection.m_122434_().m_122479_()) {
            this.m_146926_(0.0f);
            this.m_146922_(this.f_31699_.m_122416_() * 90);
        } else {
            this.m_146926_(-90 * facingDirection.m_122421_().m_122540_());
            this.m_146922_(0.0f);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_7087_();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.m_20088_().m_135381_(DATA_SIZE, (Object)Mth.m_14045_((int)size, (int)0, (int)2));
        this.size = size;
        this.m_7087_();
    }

    public ItemStack getFrameItem() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_FRAME_ITEM);
    }

    public void setFrameItem(ItemStack stack) {
        this.m_20088_().m_135381_(DATA_FRAME_ITEM, (Object)stack);
    }

    public ItemStack getItem() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM);
    }

    public void setItem(ItemStack stack) {
        this.m_20088_().m_135381_(DATA_ITEM, (Object)stack);
    }

    protected void onItemChanged(ItemStack itemStack) {
        if (!itemStack.m_41619_()) {
            itemStack.m_41636_((Entity)this);
        }
    }

    public int getItemRotation() {
        return (Integer)this.m_20088_().m_135370_(DATA_ITEM_ROTATION);
    }

    public void setItemRotation(int rotation) {
        this.m_20088_().m_135381_(DATA_ITEM_ROTATION, (Object)(rotation % 4));
    }

    public boolean isGlowing() {
        return (Boolean)this.m_20088_().m_135370_(DATA_GLOWING);
    }

    public void setGlowing(boolean glowing) {
        this.m_20088_().m_135381_(DATA_GLOWING, (Object)glowing);
    }

    public boolean isStripped() {
        return (Boolean)this.m_20088_().m_135370_(DATA_STRIPPED);
    }

    public void setStripped(boolean stripped) {
        this.m_20088_().m_135381_(DATA_STRIPPED, (Object)stripped);
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (!this.isStripped()) {
            if (this.canStrip(itemInHand)) {
                if (!this.m_9236_().f_46443_) {
                    this.setStripped(true);
                    itemInHand.m_41622_(1, (LivingEntity)player, pl -> pl.m_21190_(hand));
                    this.m_146852_(GameEvent.f_157792_, (Entity)player);
                    this.m_5496_(SoundEvents.f_11688_, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (itemInHand.m_150930_(Items.f_42398_)) {
            if (!this.m_9236_().f_46443_) {
                this.setStripped(false);
                itemInHand.m_41774_(1);
                this.m_146852_(GameEvent.f_157792_, (Entity)player);
                this.m_7084_();
            }
            return InteractionResult.SUCCESS;
        }
        if (itemInHand.m_41720_() instanceof PhotographItem && this.getItem().m_41619_()) {
            this.setItem(itemInHand.m_41777_());
            itemInHand.m_41774_(1);
            this.m_146852_(GameEvent.f_157792_, (Entity)player);
            this.m_5496_(this.getAddItemSound(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemInHand.m_150930_(Items.f_151056_) && !this.isGlowing()) {
            this.setGlowing(true);
            itemInHand.m_41774_(1);
            if (!this.m_9236_().f_46443_) {
                this.m_216990_(SoundEvents.f_144153_);
                this.m_146852_(GameEvent.f_157792_, (Entity)player);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_20145_()) {
            if (itemInHand.m_204117_(ItemTags.f_13168_)) {
                this.m_6842_(false);
                itemInHand.m_41774_(1);
                if (!this.m_9236_().f_46443_) {
                    this.m_7084_();
                    this.m_146852_(GameEvent.f_157792_, (Entity)player);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (itemInHand.m_150930_(Items.f_42027_)) {
            this.m_6842_(true);
            itemInHand.m_41774_(1);
            if (!this.m_9236_().f_46443_) {
                this.m_5496_(Exposure.SoundEvents.FILTER_INSERT.get(), 0.8f, 1.0f);
                this.m_146852_(GameEvent.f_157792_, (Entity)player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.getItem().m_41619_()) {
            if (!this.m_9236_().f_46443_) {
                this.m_5496_(this.getRotateSound(), 1.0f, this.m_9236_().m_213780_().m_188501_() * 0.2f + 0.9f);
                this.setItemRotation(this.getItemRotation() + 1);
                this.m_146852_(GameEvent.f_157792_, (Entity)player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canStrip(ItemStack stack) {
        return PlatformHelper.canStrip(stack);
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (!damageSource.m_269533_(DamageTypeTags.f_268415_) && !this.getItem().m_41619_()) {
            if (!this.m_9236_().f_46443_) {
                this.dropItem(damageSource.m_7639_(), false);
                this.m_146852_(GameEvent.f_157792_, damageSource.m_7639_());
                this.m_5496_(this.getRemoveItemSound(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        this.m_5496_(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(brokenEntity, true);
        this.m_146852_(GameEvent.f_157792_, brokenEntity);
    }

    protected void dropItem(@Nullable Entity entity, boolean dropSelf) {
        float yOffset;
        Player player;
        ItemStack itemStack = this.getItem();
        this.setItem(ItemStack.f_41583_);
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return;
        }
        float f = yOffset = this.m_6350_() == Direction.DOWN ? -0.3f : 0.0f;
        if (dropSelf) {
            this.m_5552_(this.getFrameItem(), yOffset);
        }
        if (!itemStack.m_41619_()) {
            this.m_5552_(itemStack.m_41777_(), yOffset);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.isGlowing() && this.m_9236_().m_213780_().m_188501_() < 0.003f) {
            AABB bb = this.m_20191_();
            Vec3i normal = this.m_6350_().m_122436_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20182_().f_82479_ + ((double)this.m_9236_().m_213780_().m_188501_() * (bb.m_82362_() * 0.75) - bb.m_82362_() * 0.75 / 2.0), this.m_20182_().f_82480_ + ((double)this.m_9236_().m_213780_().m_188501_() * (bb.m_82376_() * 0.75) - bb.m_82376_() * 0.75 / 2.0), this.m_20182_().f_82481_ + ((double)this.m_9236_().m_213780_().m_188501_() * (bb.m_82385_() * 0.75) - bb.m_82385_() * 0.75 / 2.0), (double)(this.m_9236_().m_213780_().m_188501_() * 0.02f * (float)normal.m_123341_()), (double)(this.m_9236_().m_213780_().m_188501_() * 0.02f * (float)normal.m_123342_()), (double)(this.m_9236_().m_213780_().m_188501_() * 0.02f * (float)normal.m_123343_()));
        }
    }

    @NotNull
    public SlotAccess m_141942_(int slot) {
        if (slot == 0) {
            return new SlotAccess(){

                @NotNull
                public ItemStack m_142196_() {
                    return PhotographFrameEntity.this.getItem();
                }

                public boolean m_142104_(ItemStack carried) {
                    PhotographFrameEntity.this.setItem(carried);
                    return true;
                }
            };
        }
        return super.m_141942_(slot);
    }

    @NotNull
    protected Component m_5677_() {
        if (this.isGlowing()) {
            return Component.m_237115_((String)"entity.exposure.glow_photograph_frame");
        }
        return super.m_5677_();
    }

    public float m_278726_() {
        return (float)(this.getSize() + 1) / 2.0f + 0.35f;
    }

    public void m_7084_() {
        this.m_5496_(this.getPlaceSound(), 1.0f, this.m_9236_().m_213780_().m_188501_() * 0.2f + 0.7f);
    }

    public SoundEvent getPlaceSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_PLACE.get();
    }

    public SoundEvent getBreakSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_BREAK.get();
    }

    public SoundEvent getAddItemSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_ADD_ITEM.get();
    }

    public SoundEvent getRemoveItemSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_REMOVE_ITEM.get();
    }

    public SoundEvent getRotateSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_FRAME_ROTATE_ITEM.get();
    }
}

