/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.storage;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.capture.CapturedFramesHistory;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.data.storage.IServersideExposureStorage;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.ExposureChangedS2CP;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public class ServersideExposureStorage
implements IServersideExposureStorage {
    private static final String EXPOSURE_DIR = "exposures";
    private final MinecraftServer server;
    private final Supplier<DimensionDataStorage> levelStorageSupplier;
    private final Supplier<Path> worldPathSupplier;

    public ServersideExposureStorage(MinecraftServer server) {
        this.server = server;
        this.levelStorageSupplier = () -> server.m_129783_().m_8895_();
        this.worldPathSupplier = () -> server.m_129843_(LevelResource.f_78182_);
    }

    @Override
    public Optional<ExposureSavedData> getOrQuery(String id) {
        DimensionDataStorage dataStorage = this.levelStorageSupplier.get();
        @Nullable ExposureSavedData loadedExposureData = (ExposureSavedData)dataStorage.m_164858_(ExposureSavedData::load, this.getSaveId(id));
        if (loadedExposureData == null) {
            Exposure.LOGGER.error("Exposure '{}' was not loaded. File does not exist or some error occurred.", (Object)id);
        }
        return Optional.ofNullable(loadedExposureData);
    }

    @Override
    public void put(String id, ExposureSavedData data) {
        if (this.createStorageDirectory()) {
            DimensionDataStorage dataStorage = this.levelStorageSupplier.get();
            dataStorage.m_164855_(this.getSaveId(id), (SavedData)data);
            data.m_77762_();
            if (this.server.m_6982_()) {
                CompoundTag frameTag = new CompoundTag();
                frameTag.m_128359_("Id", id);
                CapturedFramesHistory.add(frameTag);
            }
        }
    }

    @Override
    public List<String> getAllIds() {
        this.levelStorageSupplier.get().m_78151_();
        Path path = this.worldPathSupplier.get().resolve("data/exposures");
        File folder = path.toFile();
        @Nullable File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (File file : listOfFiles) {
            if (file == null || !file.isFile()) continue;
            ids.add(com.google.common.io.Files.getNameWithoutExtension((String)file.getName()));
        }
        return ids;
    }

    @Override
    public void clear() {
        Exposure.LOGGER.warn("Clearing Server Exposure Storage is not implemented.");
    }

    @Override
    public void sendExposureChanged(String exposureId) {
        Packets.sendToAllClients(new ExposureChangedS2CP(exposureId));
    }

    private String getSaveId(String id) {
        return "exposures/" + id;
    }

    private boolean createStorageDirectory() {
        try {
            Path path = this.worldPathSupplier.get().resolve("data/exposures");
            return Files.exists(path, new LinkOption[0]) || path.toFile().mkdirs();
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Failed to create exposure storage directory: {}", (Object)e.toString());
            return false;
        }
    }
}

