/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.sound;

import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.AbstractOnlineSoundInstance;
import gg.moonflower.etched.api.sound.OnlineRecordSoundInstance;
import gg.moonflower.etched.api.sound.StopListeningSound;
import gg.moonflower.etched.api.sound.source.AudioSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import gg.moonflower.etched.common.block.AlbumJukeboxBlock;
import gg.moonflower.etched.common.block.RadioBlock;
import gg.moonflower.etched.common.blockentity.AlbumJukeboxBlockEntity;
import gg.moonflower.etched.core.mixin.client.GuiAccessor;
import gg.moonflower.etched.core.mixin.client.LevelRendererAccessor;
import gg.moonflower.etched.core.registry.EtchedTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.DoubleSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import org.jetbrains.annotations.Nullable;

public class SoundTracker {
    private static final Int2ObjectArrayMap<SoundInstance> ENTITY_PLAYING_SOUNDS = new Int2ObjectArrayMap();
    private static final Set<String> FAILED_URLS = new HashSet<String>();
    private static final Component RADIO = Component.m_237115_((String)"sound_source.etched.radio");

    private static synchronized void setRecordPlayingNearby(Level level, BlockPos pos, boolean playing) {
        BlockState state = level.m_8055_(pos);
        if (state.m_204336_(EtchedTags.AUDIO_PROVIDER) || state.m_60713_(Blocks.f_50131_)) {
            for (LivingEntity livingEntity : level.m_45976_(LivingEntity.class, new AABB(pos).m_82400_(3.0))) {
                livingEntity.m_6818_(pos, playing);
            }
        }
    }

    @Nullable
    public static SoundInstance getEntitySound(int entity) {
        return (SoundInstance)ENTITY_PLAYING_SOUNDS.get(entity);
    }

    public static void setEntitySound(int entity, @Nullable SoundInstance instance) {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (instance == null) {
            SoundInstance old = (SoundInstance)ENTITY_PLAYING_SOUNDS.remove(entity);
            if (old != null) {
                if (old instanceof StopListeningSound) {
                    ((StopListeningSound)old).stopListening();
                }
                soundManager.m_120399_(old);
            }
        } else {
            ENTITY_PLAYING_SOUNDS.put(entity, (Object)instance);
            soundManager.m_120367_(instance);
        }
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(final String url, final Component title, final Entity entity, int attenuationDistance, boolean stream) {
        return new OnlineRecordSoundInstance(url, entity, attenuationDistance, new MusicDownloadListener(title, () -> ((Entity)entity).m_20185_(), () -> ((Entity)entity).m_20186_(), () -> ((Entity)entity).m_20189_()){

            @Override
            public void onSuccess() {
                if (!entity.m_6084_() || !ENTITY_PLAYING_SOUNDS.containsKey(entity.m_19879_())) {
                    this.clearComponent();
                } else if (PlayableRecord.canShowMessage(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())) {
                    Minecraft.m_91087_().f_91065_.m_93055_(title);
                }
            }

            @Override
            public void onFail() {
                Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237110_((String)"record.etched.downloadFail", (Object[])new Object[]{title}), true);
                FAILED_URLS.add(url);
            }
        }, stream ? AudioSource.AudioFileType.STREAM : AudioSource.AudioFileType.FILE);
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(String url, Component title, Entity entity, boolean stream) {
        return SoundTracker.getEtchedRecord(url, title, entity, 16, stream);
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(final String url, final Component title, final ClientLevel level, final BlockPos pos, int attenuationDistance, AudioSource.AudioFileType type) {
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        boolean muffled = aboveState.m_204336_(BlockTags.f_13089_);
        final boolean hidden = !aboveState.m_60795_();
        final Map<BlockPos, SoundInstance> playingRecords = ((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).getPlayingRecords();
        return new OnlineRecordSoundInstance(url, (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f, muffled ? 2.0f : 4.0f, muffled ? attenuationDistance / 2 : attenuationDistance, new MusicDownloadListener(title, () -> (double)pos.m_123341_() + 0.5, () -> (double)pos.m_123342_() + 0.5, () -> (double)pos.m_123343_() + 0.5){

            @Override
            public void onSuccess() {
                if (!playingRecords.containsKey(pos)) {
                    this.clearComponent();
                } else {
                    if (!hidden && PlayableRecord.canShowMessage((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5)) {
                        Minecraft.m_91087_().f_91065_.m_93055_(title);
                    }
                    SoundTracker.setRecordPlayingNearby((Level)level, pos, true);
                }
            }

            @Override
            public void onFail() {
                Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237110_((String)"record.etched.downloadFail", (Object[])new Object[]{title}), true);
                FAILED_URLS.add(url);
            }
        }, type);
    }

    public static AbstractOnlineSoundInstance getEtchedRecord(String url, Component title, ClientLevel level, BlockPos pos, AudioSource.AudioFileType type) {
        return SoundTracker.getEtchedRecord(url, title, level, pos, 16, type);
    }

    private static void playRecord(BlockPos pos, SoundInstance sound) {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        Map<BlockPos, SoundInstance> playingRecords = ((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).getPlayingRecords();
        playingRecords.put(pos, sound);
        soundManager.m_120367_(sound);
    }

    private static void playNextRecord(ClientLevel level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof AlbumJukeboxBlockEntity)) {
            return;
        }
        AlbumJukeboxBlockEntity jukebox = (AlbumJukeboxBlockEntity)blockEntity;
        jukebox.next();
        SoundTracker.playAlbum((AlbumJukeboxBlockEntity)blockEntity, blockEntity.m_58900_(), level, pos, true);
    }

    public static void playBlockRecord(BlockPos pos, TrackData[] tracks, int track) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (track >= tracks.length) {
            SoundTracker.setRecordPlayingNearby((Level)level, pos, false);
            return;
        }
        TrackData trackData = tracks[track];
        String url = trackData.url();
        if (!TrackData.isValidURL(url) || FAILED_URLS.contains(url)) {
            SoundTracker.playBlockRecord(pos, tracks, track + 1);
            return;
        }
        SoundTracker.playRecord(pos, StopListeningSound.create((SoundInstance)SoundTracker.getEtchedRecord(url, trackData.getDisplayName(), level, pos, AudioSource.AudioFileType.FILE), () -> Minecraft.m_91087_().m_6937_(() -> {
            if (!((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).getPlayingRecords().containsKey(pos)) {
                return;
            }
            SoundTracker.playBlockRecord(pos, tracks, track + 1);
        })));
    }

    public static void playEntityRecord(ItemStack record, int entityId, int track, int attenuationDistance, boolean loop) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(entityId);
        if (entity == null) {
            return;
        }
        Optional<? extends SoundInstance> sound = ((PlayableRecord)record.m_41720_()).createEntitySound(record, entity, track, attenuationDistance);
        if (sound.isEmpty()) {
            if (loop && track != 0) {
                SoundTracker.playEntityRecord(record, entityId, 0, attenuationDistance, true);
            }
            return;
        }
        SoundInstance entitySound = (SoundInstance)ENTITY_PLAYING_SOUNDS.remove(entity.m_19879_());
        if (entitySound != null) {
            if (entitySound instanceof StopListeningSound) {
                ((StopListeningSound)entitySound).stopListening();
            }
            Minecraft.m_91087_().m_91106_().m_120399_(entitySound);
        }
        entitySound = StopListeningSound.create(sound.get(), () -> Minecraft.m_91087_().m_6937_(() -> {
            ENTITY_PLAYING_SOUNDS.remove(entityId);
            SoundTracker.playEntityRecord(record, entityId, track + 1, attenuationDistance, loop);
        }));
        ENTITY_PLAYING_SOUNDS.put(entityId, (Object)entitySound);
        Minecraft.m_91087_().m_91106_().m_120367_(entitySound);
    }

    public static void playEntityRecord(ItemStack record, int entityId, int track, boolean loop) {
        SoundTracker.playEntityRecord(record, entityId, track, 16, loop);
    }

    public static void playBoombox(int entityId, ItemStack record) {
        SoundTracker.setEntitySound(entityId, null);
        if (!record.m_41619_()) {
            SoundTracker.playEntityRecord(record, entityId, 0, 8, true);
        }
    }

    public static void playRadio(@Nullable String url, BlockState state, ClientLevel level, BlockPos pos) {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        Map<BlockPos, SoundInstance> playingRecords = ((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).getPlayingRecords();
        SoundInstance soundInstance = playingRecords.get(pos);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            soundManager.m_120399_(soundInstance);
            playingRecords.remove(pos);
            SoundTracker.setRecordPlayingNearby((Level)level, pos, false);
        }
        if (FAILED_URLS.contains(url)) {
            return;
        }
        if (!state.m_61138_((Property)RadioBlock.POWERED) || ((Boolean)state.m_61143_((Property)RadioBlock.POWERED)).booleanValue()) {
            return;
        }
        if (TrackData.isValidURL(url)) {
            AbstractOnlineSoundInstance record = SoundTracker.getEtchedRecord(url, RADIO, level, pos, 8, AudioSource.AudioFileType.BOTH);
            record.setLoop(true);
            SoundTracker.playRecord(pos, (SoundInstance)record);
        }
    }

    public static void playAlbum(AlbumJukeboxBlockEntity jukebox, BlockState state, ClientLevel level, BlockPos pos, boolean force) {
        Optional<TrackData[]> optional;
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        Map<BlockPos, SoundInstance> playingRecords = ((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).getPlayingRecords();
        if (!state.m_61138_((Property)AlbumJukeboxBlock.POWERED) || !((Boolean)state.m_61143_((Property)AlbumJukeboxBlock.POWERED)).booleanValue() && !force && !jukebox.recalculatePlayingIndex(false)) {
            return;
        }
        SoundInstance soundInstance = playingRecords.get(pos);
        if (soundInstance != null) {
            if (soundInstance instanceof StopListeningSound) {
                ((StopListeningSound)soundInstance).stopListening();
            }
            soundManager.m_120399_(soundInstance);
            playingRecords.remove(pos);
            SoundTracker.setRecordPlayingNearby((Level)level, pos, false);
        }
        if (((Boolean)state.m_61143_((Property)AlbumJukeboxBlock.POWERED)).booleanValue()) {
            jukebox.stopPlaying();
        }
        if (jukebox.getPlayingIndex() < 0) {
            return;
        }
        ItemStack disc = jukebox.m_8020_(jukebox.getPlayingIndex());
        StopListeningSound sound = null;
        if (disc.m_41720_() instanceof RecordItem) {
            sound = StopListeningSound.create((SoundInstance)SoundTracker.getEtchedRecord(((RecordItem)disc.m_41720_()).m_43051_().m_11660_().toString(), (Component)((RecordItem)disc.m_41720_()).m_43050_(), level, pos, AudioSource.AudioFileType.FILE), () -> Minecraft.m_91087_().m_6937_(() -> SoundTracker.playNextRecord(level, pos)));
        } else if (disc.m_41720_() instanceof PlayableRecord && (optional = PlayableRecord.getStackMusic(disc)).isPresent()) {
            TrackData[] tracks = optional.get();
            TrackData track = jukebox.getTrack() < 0 || jukebox.getTrack() >= tracks.length ? tracks[0] : tracks[jukebox.getTrack()];
            String url = track.url();
            if (TrackData.isValidURL(url) && !FAILED_URLS.contains(url)) {
                sound = StopListeningSound.create((SoundInstance)SoundTracker.getEtchedRecord(url, track.getDisplayName(), level, pos, AudioSource.AudioFileType.FILE), () -> Minecraft.m_91087_().m_6937_(() -> SoundTracker.playNextRecord(level, pos)));
            }
        }
        if (sound == null) {
            return;
        }
        SoundTracker.playRecord(pos, sound);
        SoundTracker.setRecordPlayingNearby((Level)level, pos, true);
    }

    static {
        MinecraftForge.EVENT_BUS.addListener(event -> FAILED_URLS.clear());
    }

    private static abstract class MusicDownloadListener
    implements DownloadProgressListener {
        private final Component title;
        private final DoubleSupplier x;
        private final DoubleSupplier y;
        private final DoubleSupplier z;
        private final BlockPos.MutableBlockPos pos;
        private float size;
        private Component requesting;
        private DownloadTextComponent component;

        protected MusicDownloadListener(Component title, DoubleSupplier x, DoubleSupplier y, DoubleSupplier z) {
            this.title = title;
            this.x = x;
            this.y = y;
            this.z = z;
            this.pos = new BlockPos.MutableBlockPos();
        }

        private BlockPos.MutableBlockPos getPos() {
            return this.pos.m_122169_(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble());
        }

        private void setComponent(Component text) {
            if (!(this.component != null || Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_8055_((BlockPos)this.getPos().m_122173_(Direction.UP)).m_60795_() && PlayableRecord.canShowMessage(this.x.getAsDouble(), this.y.getAsDouble(), this.z.getAsDouble()))) {
                return;
            }
            if (this.component == null) {
                this.component = new DownloadTextComponent();
                Minecraft.m_91087_().f_91065_.m_93063_((Component)this.component, true);
                ((GuiAccessor)Minecraft.m_91087_().f_91065_).setOverlayMessageTime(Short.MAX_VALUE);
            }
            this.component.setText(text.getString());
        }

        protected void clearComponent() {
            if (((GuiAccessor)Minecraft.m_91087_().f_91065_).getOverlayMessageString() == this.component) {
                ((GuiAccessor)Minecraft.m_91087_().f_91065_).setOverlayMessageTime(60);
                this.component = null;
            }
        }

        @Override
        public void progressStartRequest(Component component) {
            this.requesting = component;
            this.setComponent(component);
        }

        @Override
        public void progressStartDownload(float size) {
            this.size = size;
            this.requesting = null;
            this.progressStagePercentage(0);
        }

        @Override
        public void progressStagePercentage(int percentage) {
            if (this.requesting != null) {
                this.setComponent((Component)this.requesting.m_6881_().m_130946_(" " + percentage + "%"));
            } else if (this.size != 0.0f) {
                this.setComponent((Component)Component.m_237110_((String)"record.etched.downloadProgress", (Object[])new Object[]{String.format(Locale.ROOT, "%.2f", Float.valueOf((float)percentage / 100.0f * this.size)), String.format(Locale.ROOT, "%.2f", Float.valueOf(this.size)), this.title}));
            }
        }

        @Override
        public void progressStartLoading() {
            this.requesting = null;
            this.setComponent((Component)Component.m_237110_((String)"record.etched.loading", (Object[])new Object[]{this.title}));
        }

        @Override
        public void onFail() {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237110_((String)"record.etched.downloadFail", (Object[])new Object[]{this.title}), true);
        }
    }

    private static class DownloadTextComponent
    implements Component {
        private ComponentContents contents = ComponentContents.f_237124_;
        private FormattedCharSequence visualOrderText = FormattedCharSequence.f_13691_;
        private Language decomposedWith = null;

        public ComponentContents m_214077_() {
            return this.contents;
        }

        public List<Component> m_7360_() {
            return Collections.emptyList();
        }

        public Style m_7383_() {
            return Style.f_131099_;
        }

        public FormattedCharSequence m_7532_() {
            Language language = Language.m_128107_();
            if (this.decomposedWith != language) {
                this.visualOrderText = language.m_5536_((FormattedText)this);
                this.decomposedWith = language;
            }
            return this.visualOrderText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DownloadTextComponent that = (DownloadTextComponent)o;
            return this.contents.equals((Object)that.contents);
        }

        public int hashCode() {
            return this.contents.hashCode();
        }

        public String toString() {
            return this.contents.toString();
        }

        public void setText(String text) {
            this.contents = new LiteralContents(text);
            this.decomposedWith = null;
        }
    }
}

