/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.handlers;

import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.mutable.MutableBoolean;
import top.theillusivec4.curios.api.CuriosApi;

public class SuperDelightHandler {
    public static final Random RANDOM = new Random();
    public static final UUID CHARM_SLOT_UUID = UUID.fromString("a38069c2-a0fd-616e-695a-eb64f402707d");

    public static boolean unlockUltimateSlot(String slot, Player player) {
        if (!slot.equals("charm")) {
            throw new IllegalArgumentException("Slot type '" + slot + "' is not supported!");
        }
        MutableBoolean success = new MutableBoolean(false);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.getStacksHandler(slot).ifPresent(stacks -> {
            Map map = stacks.getModifiers();
            if (!stacks.getModifiers().containsKey(CHARM_SLOT_UUID)) {
                stacks.addPermanentModifier(new AttributeModifier(CHARM_SLOT_UUID, "MasterSlot", 1.0, AttributeModifier.Operation.ADDITION));
                success.setTrue();
            }
        }));
        return success.getValue();
    }

    public static float getMissingFoodProperty(Player player) {
        int foodLevel = player.m_36324_().m_38702_();
        float missingFood = (float)(20 - Math.min(foodLevel, 20)) / 20.0f;
        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.BERSERK_CHARM)) {
            float missingHealth = (player.m_21233_() - Math.min(player.m_21223_(), player.m_21233_())) / player.m_21233_();
            missingFood = missingFood * 0.8f + missingHealth * 0.4f;
        }
        return missingFood;
    }
}

