/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.handlers;

import auviotre.enigmatic.addon.handlers.OmniconfigAddonHandler;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.omniconfig.Configuration;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;

public class OmniconfigDelightHandler {
    public static void initialize() {
        OmniconfigWrapper configBuilder = OmniconfigWrapper.setupBuilder((String)"enigmaticdelicacy-common", (boolean)true, (String)"1.1");
        configBuilder.pushVersioningPolicy(Configuration.VersioningPolicy.AGGRESSIVE);
        configBuilder.pushTerminateNonInvokedKeys(true);
        OmniconfigDelightHandler.loadCommon(configBuilder);
        configBuilder.setReloadable();
        OmniconfigWrapper clientBuilder = OmniconfigWrapper.setupBuilder((String)"enigmaticdelicacy-client", (boolean)true, (String)"1.1");
        clientBuilder.pushSidedType(Configuration.SidedConfigType.CLIENT);
        clientBuilder.pushVersioningPolicy(Configuration.VersioningPolicy.AGGRESSIVE);
        clientBuilder.pushTerminateNonInvokedKeys(true);
        OmniconfigDelightHandler.loadClient(clientBuilder);
        clientBuilder.setReloadable();
    }

    private static void loadClient(OmniconfigWrapper client) {
        client.loadConfigFile();
        client.pushCategory("Generic Config", "Some more different stuff");
        SuperpositionHandler.dispatchWrapperToHolders((String)"enigmaticdelicacy", (OmniconfigWrapper)client);
        client.popCategory();
        client.build();
    }

    private static void loadCommon(OmniconfigWrapper builder) {
        builder.loadConfigFile();
        builder.pushCategory("Accessibility Options", "You may disable certain items or features from being obtainable/usable here." + System.lineSeparator() + "Check more details in Enigmatic Legacy's Config Files.");
        Multimap accessibilityGeneratorMap = SuperpositionHandler.retainAccessibilityGeneratorMap((String)"enigmaticdelicacy");
        OmniconfigAddonHandler.ITEMS_OPTIONS.clear();
        builder.forceSynchronized(true);
        for (String itemName : accessibilityGeneratorMap.keySet()) {
            String optionName = itemName.replaceAll("[^a-zA-Z0-9]", "") + "Enabled";
            Omniconfig.BooleanParameter param = builder.comment("Whether or not " + itemName + " should be enabled.").getBoolean(optionName, true);
            for (Field associatedField : accessibilityGeneratorMap.get((Object)itemName)) {
                OmniconfigAddonHandler.ITEMS_OPTIONS.put(associatedField, param);
            }
        }
        builder.forceSynchronized(false);
        builder.popCategory();
        builder.pushCategory("Balance Options", "Various options that mostly affect individual items");
        builder.forceSynchronized(true);
        SuperpositionHandler.dispatchWrapperToHolders((String)"enigmaticdelicacy", (OmniconfigWrapper)builder);
        builder.forceSynchronized(false);
        builder.popCategory();
        builder.build();
    }
}

