/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.handlers;

import auviotre.enigmatic.delicacy.client.screens.EtheriumStoveScreen;
import auviotre.enigmatic.delicacy.contents.crafting.EnigmaticAmuletRecipe;
import auviotre.enigmatic.delicacy.contents.guis.EtheriumStoveMenu;
import auviotre.enigmatic.delicacy.contents.items.EnigmaticFruit;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightBlocks;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightItems;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightMenus;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class DelicacyJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("enigmaticdelicacy", "common_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)EnigmaticItems.ENIGMATIC_AMULET, (IIngredientSubtypeInterpreter)SubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter((Item)EnigmaticDelightItems.ENIGMATIC_FRUIT, (IIngredientSubtypeInterpreter)SubtypeInterpreter.INSTANCE);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EnigmaticDelightBlocks.ETHERIUM_STOVE), new RecipeType[]{RecipeTypes.SMELTING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(EtheriumStoveScreen.class, 79, 34, 24, 17, new RecipeType[]{RecipeTypes.SMELTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(EtheriumStoveMenu.class, EnigmaticDelightMenus.ETHERIUM_STOVE_MENU, RecipeTypes.SMELTING, 0, 1, 2, 36);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        ArrayList<IJeiAnvilRecipe> anvilRecipes = new ArrayList<IJeiAnvilRecipe>();
        anvilRecipes.add(vanillaRecipeFactory.createAnvilRecipe(EnigmaticDelightItems.CURSE_BLADE.m_7968_(), List.of(EnigmaticDelightItems.CURSED_SOUL_FRAGMENT.m_7968_()), List.of(EnigmaticDelightItems.CURSE_CRYSTAL_KNIFE.m_7968_()), new ResourceLocation("enigmaticdelicacy", "anvil_crafting.curse_crystal_knife")));
        anvilRecipes.add(vanillaRecipeFactory.createAnvilRecipe(EnigmaticItems.UNWITNESSED_AMULET.m_7968_(), List.of(EnigmaticDelightItems.CURSED_SOUL_FRAGMENT.m_7968_()), List.of(EnigmaticDelightItems.CURSE_CRYSTAL_PENDANT.m_7968_()), new ResourceLocation("enigmaticdelicacy", "anvil_crafting.curse_crystal_pendant")));
        registration.addRecipes(RecipeTypes.ANVIL, anvilRecipes);
        registration.addRecipes(RecipeTypes.CRAFTING, this.getAmuletsRecipes());
    }

    private List<CraftingRecipe> getAmuletsRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (Float value : EnigmaticAmuletRecipe.MAP.keySet()) {
            ResourceLocation location = new ResourceLocation("enigmaticdelicacy", "enigmatic_amulet" + EnigmaticAmuletRecipe.MAP.get(value));
            NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            ItemStack amulet = EnigmaticItems.ENIGMATIC_AMULET.m_7968_();
            for (int i = 0; i < 9; ++i) {
                if (i == 4) continue;
                ItemStack stack = EnigmaticAmuletRecipe.ITEM_LIST.get(i).m_7968_();
                if (i == 7) {
                    ItemNBTHelper.setFloat((ItemStack)stack, (String)"AssignedColor", (float)value.floatValue());
                    ItemNBTHelper.setFloat((ItemStack)amulet, (String)"AssignedColor", (float)value.floatValue());
                }
                ingredients.set(i, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
            }
            ShapedRecipe shapedRecipe = new ShapedRecipe(location, "enigmatic_amulet", CraftingBookCategory.MISC, 3, 3, ingredients, amulet);
            recipes.add((CraftingRecipe)shapedRecipe);
        }
        return recipes;
    }

    public static class SubtypeInterpreter
    implements IIngredientSubtypeInterpreter<ItemStack> {
        public static final SubtypeInterpreter INSTANCE = new SubtypeInterpreter();

        private SubtypeInterpreter() {
        }

        public String apply(@NotNull ItemStack stack, UidContext context) {
            if (stack.m_150930_((Item)EnigmaticItems.ENIGMATIC_AMULET) || stack.m_150930_((Item)EnigmaticDelightItems.ENIGMATIC_FRUIT)) {
                float color = EnigmaticFruit.getColor(stack);
                if (color == 0.0f) {
                    return "";
                }
                return EnigmaticAmuletRecipe.MAP.get(Float.valueOf(color)) + ";";
            }
            return "";
        }
    }
}

