/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.contents.items;

import auviotre.enigmatic.addon.api.items.IBetrayed;
import auviotre.enigmatic.addon.contents.items.BlessRing;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import auviotre.enigmatic.delicacy.handlers.SuperDelightHandler;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.SlotContext;

public class GluttonyCharm
extends ItemBaseCurio
implements ICursed,
IBetrayed {
    public static Omniconfig.DoubleParameter attackDamage;
    public static Omniconfig.DoubleParameter critModifier;
    public static Omniconfig.DoubleParameter movementSpeed;
    public static Omniconfig.DoubleParameter damageResistance;

    public GluttonyCharm() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC).m_41486_());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("VoracityEmblem");
        attackDamage = builder.comment("Damage increase provided by Emblem of Boundless Voracity for each missing percent of food. Measured as percentage.").getDouble("DamageBoost", 0.4);
        critModifier = builder.comment("Crit modifier increase provided by Emblem of Bloodstained Valor for each missing percent of food. Measured as percentage.").getDouble("CritModifier", 1.25);
        movementSpeed = builder.comment("Movement speed increase provided by Emblem of Bloodstained Valor for each missing percent of food. Measured as percentage.").getDouble("SpeedBoost", 0.25);
        damageResistance = builder.comment("Damage resistance provided by Emblem of Bloodstained Valor for each missing percent of food. Measured as percentage.").getDouble("ResistanceBoost", 0.5);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.berserk_charm1", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{GluttonyCharm.minimizeNumber((double)attackDamage.getValue()) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.gluttonyCharm2", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{GluttonyCharm.minimizeNumber((double)critModifier.getValue()) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.berserk_charm3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{GluttonyCharm.minimizeNumber((double)movementSpeed.getValue()) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.berserk_charm4", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{GluttonyCharm.minimizeNumber((double)damageResistance.getValue()) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.gluttonyCharm5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.gluttonyCharm6");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.gluttonyCharm7");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        if (Minecraft.m_91087_().f_91074_ != null && SuperpositionHandler.getCurioStack((LivingEntity)Minecraft.m_91087_().f_91074_, (Item)this) == stack) {
            float missingPool = SuperDelightHandler.getMissingFoodProperty((Player)Minecraft.m_91087_().f_91074_);
            int percentage = (int)(missingPool * 100.0f);
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.berserk_charm7");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.berserk_charm8", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{GluttonyCharm.minimizeNumber((double)(attackDamage.getValue() * (double)percentage)) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.gluttonyCharm2", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{GluttonyCharm.minimizeNumber((double)(critModifier.getValue() * (double)percentage)) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.berserk_charm10", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{GluttonyCharm.minimizeNumber((double)(movementSpeed.getValue() * (double)percentage)) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.berserk_charm11", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{GluttonyCharm.minimizeNumber((double)(damageResistance.getValue() * (double)percentage)) + "%"});
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
    }

    public CreativeModeTab getCreativeTab() {
        return null;
    }

    private Multimap<Attribute, AttributeModifier> createAttributeMap(Player player) {
        HashMultimap attributesDefault = HashMultimap.create();
        float missingHealthPool = SuperDelightHandler.getMissingFoodProperty(player);
        attributesDefault.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("e7749ac9-aa82-49c0-9cd6-8867b9bd13a3"), "enigmaticdelicacy:speed_modifier", (double)missingHealthPool * movementSpeed.getValue(), AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_21204_().m_22178_(this.createAttributeMap(player));
        }
    }

    public void onUnequip(SlotContext context, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_21204_().m_22161_(this.createAttributeMap(player));
        }
    }

    public boolean canEquip(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity;
        if (super.canEquip(context, stack) && (livingEntity = context.entity()) instanceof Player) {
            Player player = (Player)livingEntity;
            return SuperAddonHandler.isOKOne((Player)player) && !EnigmaticItems.FORBIDDEN_FRUIT.haveConsumedFruit(player);
        }
        return false;
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)livingEntity), (Item)this)) {
            float resistance = SuperDelightHandler.getMissingFoodProperty(player) * (float)damageResistance.getValue();
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.HELL_BLADE_CHARM)) {
                resistance *= 0.5f;
            }
            event.setAmount(event.getAmount() * (1.0f - resistance));
            BlessRing.Helper.addBetrayal((Player)player, (int)2);
            if (event.getSource().m_276093_(DamageTypes.f_268441_)) {
                event.setCanceled(true);
            }
        }
        if ((livingEntity = event.getSource().m_7639_()) instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)livingEntity), (Item)this)) {
            BlessRing.Helper.addBetrayal((Player)player, (int)2);
            event.setAmount(event.getAmount() * (1.0f + SuperDelightHandler.getMissingFoodProperty(player) * (float)attackDamage.getValue()));
        }
    }
}

