/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.contents.items;

import auviotre.enigmatic.addon.registries.EnigmaticAddonParticles;
import auviotre.enigmatic.delicacy.contents.items.CurseBlade;
import auviotre.enigmatic.delicacy.contents.items.CursePotion;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightEffects;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vectorwing.farmersdelight.common.item.KnifeItem;

public class CurseCrystalKnife
extends KnifeItem {
    public static Omniconfig.PerhapsParameter applyingCurseEffectProbability;
    public static Omniconfig.IntParameter specialLootCooldown;

    public CurseCrystalKnife() {
        super((Tier)EnigmaticMaterials.FORBIDDEN_AXE, 4.0f, -2.2f, new Item.Properties().m_41497_(Rarity.EPIC).m_41486_());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("CursedSoulCrystalKnife");
        applyingCurseEffectProbability = builder.comment("The probability of applying health curse effect on the target. Measures in percentage.").max(30.0).getPerhaps("ApplyingCurseEffectProbability", 16);
        specialLootCooldown = builder.comment("The cooldown of transforming creatures into babies ot drop loot. Measures in tick.").min(40.0).getInt("SpecialLootCooldown", 200);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        int soulAmount = CurseBlade.SoulHelper.getSoulAmount(stack);
        int killCount = CurseBlade.SoulHelper.getKillCount(stack);
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalKnife1", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{applyingCurseEffectProbability + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalKnife2", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{applyingCurseEffectProbability + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalKnife3");
            if (soulAmount > 0) {
                MutableComponent compSoul = Component.m_237113_((String)String.valueOf(soulAmount)).m_130940_(ChatFormatting.LIGHT_PURPLE);
                MutableComponent compKill = Component.m_237113_((String)String.valueOf(killCount)).m_130940_(ChatFormatting.LIGHT_PURPLE);
                MutableComponent compBonus = Component.m_237113_((String)String.valueOf(0.1f * (float)Mth.m_14143_((float)((float)soulAmount * 10.0f / (float)killCount)))).m_130940_(ChatFormatting.RED);
                list.add((Component)Component.m_237110_((String)"tooltip.enigmaticdelicacy.curseCrystalKnife4", (Object[])new Object[]{compBonus, compSoul, compKill}));
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalKnife5");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalSoulAmount", (ChatFormatting)ChatFormatting.LIGHT_PURPLE, (Object[])new Object[]{soulAmount});
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseCrystalKnifeCount", (ChatFormatting)ChatFormatting.LIGHT_PURPLE, (Object[])new Object[]{killCount});
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        AgeableMob ageableMob;
        if (target instanceof AgeableMob && !(ageableMob = (AgeableMob)target).m_6162_()) {
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)EnigmaticAddonParticles.RED_STAR_DUST, target.m_20185_(), target.m_20186_(), target.m_20189_(), 24, (double)(target.m_20205_() / 2.0f), (double)target.m_20206_(), (double)(target.m_20205_() / 2.0f), 0.0);
                ageableMob.m_6863_(true);
                target.m_6598_(player);
                player.m_36335_().m_41524_((Item)this, specialLootCooldown.getValue());
                DamageSource source = player.m_269291_().m_269075_(player);
                target.m_7472_(source, ForgeHooks.getLootingLevel((Entity)target, (Entity)player, (DamageSource)source), true);
                target.m_7625_(source, true);
            }
            return InteractionResult.m_19078_((boolean)target.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHurt(LivingHurtEvent event) {
        LivingEntity entity;
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof LivingEntity && (entity = (LivingEntity)attacker).m_21205_().m_150930_((Item)this)) {
            float soulAmount = CurseBlade.SoulHelper.getSoulAmount(entity.m_21205_());
            float killCount = CurseBlade.SoulHelper.getKillCount(entity.m_21205_());
            float bonus = 0.1f * (float)Mth.m_14143_((float)(soulAmount * 10.0f / killCount));
            if (soulAmount > 0.0f) {
                event.setAmount(event.getAmount() + bonus);
            }
        }
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent event) {
        LivingEntity entity;
        boolean apply;
        Entity attacker = event.getSource().m_7639_();
        LivingEntity victim = event.getEntity();
        boolean bl = apply = victim.m_217043_().m_188503_(100) < applyingCurseEffectProbability.getValue().asPercentage();
        if (attacker instanceof LivingEntity && (entity = (LivingEntity)attacker).m_21205_().m_150930_((Item)this) && !entity.m_9236_().m_5776_()) {
            if (victim.m_21023_((MobEffect)EnigmaticDelightEffects.HEALTH_CURSE_EFFECT)) {
                MobEffectInstance effect = victim.m_21124_((MobEffect)EnigmaticDelightEffects.HEALTH_CURSE_EFFECT);
                int amplifier = effect.m_19564_();
                if (amplifier == 4) {
                    event.setAmount(event.getAmount() + victim.m_21233_() * 0.05f);
                    CursePotion.setEffectCleanable(victim);
                    victim.m_21195_((MobEffect)EnigmaticDelightEffects.HEALTH_CURSE_EFFECT);
                }
                if (apply) {
                    if (effect.m_19557_() < 900) {
                        effect.f_19503_ += 600;
                    } else {
                        victim.m_7292_(new MobEffectInstance((MobEffect)EnigmaticDelightEffects.HEALTH_CURSE_EFFECT, (1200 + effect.m_19557_()) / 2, Math.min(amplifier + 1, 4)));
                    }
                }
            } else if (apply) {
                victim.m_7292_(new MobEffectInstance((MobEffect)EnigmaticDelightEffects.HEALTH_CURSE_EFFECT, 600));
            }
        }
    }
}

