/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.contents.items;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonDamageTypes;
import auviotre.enigmatic.addon.registries.EnigmaticAddonParticles;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightEffects;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.aizistral.enigmaticlegacy.entities.PermanentItemEntity;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;
import vectorwing.farmersdelight.common.item.KnifeItem;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class CurseBlade
extends KnifeItem {
    public static Omniconfig.IntParameter additionalHealthCurseAmplifier;
    public static Omniconfig.IntParameter additionalHealthCurseDuration;
    public static Omniconfig.IntParameter healthCurseAmplifier;
    public static Omniconfig.PerhapsParameter attackSpeedCurseMultiplier;
    private boolean soundPlayed = false;

    public CurseBlade() {
        super((Tier)EnigmaticMaterials.FORBIDDEN_AXE, 2.0f, -2.4f, new Item.Properties().m_41497_(Rarity.EPIC).m_41486_());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("CurseBlade");
        additionalHealthCurseAmplifier = builder.comment("The amplifier of additional health curse effect while charging attack.").min(0.0).max(9.0).getInt("AdditionalHealthCurseAmplifier", 4);
        additionalHealthCurseDuration = builder.comment("The duration of additional health curse effect while charging attack.").min(600.0).getInt("AdditionalHealthCurseDuration", 2400);
        healthCurseAmplifier = builder.comment("The Amplifier of Health Curse when you get the curse after gaining Broken Cursed Soul Crystal.").getInt("HealthCurseAmplifier", 5);
        attackSpeedCurseMultiplier = builder.comment("The Attack Speed Multiplier when you get the curse after gaining Blooded Ring of the Seven Curses.").getPerhaps("AttackSpeedCurseMultiplier", 10);
        builder.popPrefix();
    }

    public static boolean getActive(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"Active", (boolean)false);
    }

    public static void setActive(ItemStack stack, boolean bool) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"Active", (boolean)bool);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseBlade1");
            int percentage = (additionalHealthCurseAmplifier.getValue() + 1) * 5;
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseBlade2", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{percentage + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseBlade3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{percentage + "%"});
            if (Minecraft.m_91087_().f_91074_ != null && SuperpositionHandler.hasCurio((LivingEntity)Minecraft.m_91087_().f_91074_, (Item)EnigmaticItems.CURSED_RING)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticdelicacy.curseBlade4");
            }
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            stack.m_41622_(10, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
            player.m_6469_(SuperAddonHandler.simpleSource((Entity)player, (ResourceKey)EnigmaticAddonDamageTypes.EVIL_CURSE), 1.0f);
            if (!level.f_46443_) {
                this.soundPlayed = false;
            }
            CurseBlade.setActive(stack, true);
        }
        return stack;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int tick) {
        int duration = this.m_8105_(stack) - tick;
        if (duration > 10 && duration % 19 == 0) {
            entity.m_6469_(SuperAddonHandler.simpleSource((Entity)entity, (ResourceKey)EnigmaticAddonDamageTypes.EVIL_CURSE), 0.25f);
        }
        if (!level.f_46443_ && duration >= 59 && !this.soundPlayed) {
            this.soundPlayed = true;
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), EnigmaticSounds.CHARGED_ON, SoundSource.PLAYERS, 2.5f, 0.5f);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_() && !CurseBlade.getActive(stack)) {
            player.m_6672_(hand);
            player.m_6469_(SuperAddonHandler.simpleSource((Entity)player, (ResourceKey)EnigmaticAddonDamageTypes.EVIL_CURSE), 0.5f);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public int m_8105_(ItemStack stack) {
        return 60;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDamage(LivingDamageEvent event) {
        Player player;
        Entity attacker = event.getSource().m_7639_();
        LivingEntity victim = event.getEntity();
        if (attacker instanceof Player && (player = (Player)attacker).m_21205_().m_150930_((Item)this) && player != victim && CurseBlade.getActive(player.m_21205_())) {
            player.m_36335_().m_41524_((Item)this, 100);
            float percentage = (float)additionalHealthCurseAmplifier.getValue() * 0.05f + 0.05f;
            player.m_6469_(SuperAddonHandler.simpleSource((Entity)player, (ResourceKey)DamageTypes.f_268566_), player.m_21223_() * percentage);
            event.setAmount(event.getAmount() + victim.m_21233_() * percentage);
            victim.m_7292_(new MobEffectInstance((MobEffect)EnigmaticDelightEffects.HEALTH_CURSE_EFFECT, additionalHealthCurseDuration.getValue(), additionalHealthCurseAmplifier.getValue(), true, true));
            CurseBlade.setActive(player.m_21205_(), false);
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)EnigmaticAddonParticles.RED_STAR_DUST, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), 24, (double)(victim.m_20205_() / 2.0f), (double)victim.m_20206_(), (double)(victim.m_20205_() / 2.0f), 0.0);
            }
        }
    }

    @SubscribeEvent
    public void onBoardInteraction(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        ItemStack toolStack = player.m_21120_(event.getHand());
        if (toolStack.m_150930_((Item)this)) {
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (CurseBlade.getActive(toolStack) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.CURSED_RING)) {
                CuttingBoardBlockEntity cuttingBoard;
                if (SuperpositionHandler.getPersistentBoolean((Player)player, (String)"CursedRingCut", (boolean)false) && !player.m_150110_().f_35937_) {
                    return;
                }
                if (blockEntity instanceof CuttingBoardBlockEntity && (cuttingBoard = (CuttingBoardBlockEntity)blockEntity).isEmpty()) {
                    ItemStack curioStack = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticItems.CURSED_RING).m_41777_();
                    SuperpositionHandler.destroyCurio((LivingEntity)player, (Item)EnigmaticItems.CURSED_RING);
                    int damage = toolStack.m_41776_() - toolStack.m_41773_();
                    toolStack.m_41622_(Mth.m_14107_((double)((double)damage * 0.6)), (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
                    ItemUtils.spawnItemEntity((Level)level, (ItemStack)curioStack, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.2), (double)((double)pos.m_123343_() + 0.5), (double)0.0, (double)0.06, (double)0.0);
                    player.m_6469_(player.m_269291_().m_269333_((LivingEntity)player), player.m_21233_() / 2.0f);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 50, 4));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 50));
                    ItemStack stack = EnigmaticDelightItems.BROKEN_CURSED_SOUL_CRYSTAL.m_7968_();
                    SoulHelper.setSoulThreshold(stack, player);
                    PermanentItemEntity itemEntity = new PermanentItemEntity(level, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, stack);
                    itemEntity.m_146915_(true);
                    itemEntity.setOwnerId(player.m_20148_());
                    itemEntity.setPickupDelay(120);
                    level.m_7967_((Entity)itemEntity);
                    SuperpositionHandler.setPersistentBoolean((Player)player, (String)"CursedRingCut", (boolean)true);
                    player.m_7292_(new MobEffectInstance((MobEffect)EnigmaticDelightEffects.HEALTH_CURSE_EFFECT, -1, healthCurseAmplifier.getValue(), true, true));
                    CurseBlade.setActive(toolStack, false);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSoulAbsorbing(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offhandItem = player.m_21206_();
            int base = (int)Math.pow(player.m_21233_() * 8000.0f, 0.25) * (SuperpositionHandler.isTheCursedOne((Player)player) ? 2 : 1);
            int point = Mth.m_14143_((float)(event.getEntity().m_21233_() / (float)base));
            if (mainHandItem.m_150930_((Item)EnigmaticDelightItems.CURSE_CRYSTAL_KNIFE)) {
                SoulHelper.addKillCount(mainHandItem);
                SoulHelper.setSoulAmount(mainHandItem, SoulHelper.getSoulAmount(mainHandItem) + point);
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticDelightItems.CURSE_CRYSTAL_PENDANT)) {
                ItemStack curioStack = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticDelightItems.CURSE_CRYSTAL_PENDANT);
                int threshold = (int)(player.m_21233_() * 8.0f);
                if (SoulHelper.getSoulAmount(curioStack) <= threshold) {
                    int newAmount = Math.min(SoulHelper.getSoulAmount(curioStack) + point, threshold);
                    SoulHelper.setSoulAmount(curioStack, newAmount);
                }
            }
            ItemStack crystal = null;
            if (mainHandItem.m_150930_((Item)EnigmaticDelightItems.BROKEN_CURSED_SOUL_CRYSTAL) && offhandItem.m_150930_((Item)EnigmaticDelightItems.CURSE_BLADE)) {
                crystal = mainHandItem;
            } else if (offhandItem.m_150930_((Item)EnigmaticDelightItems.BROKEN_CURSED_SOUL_CRYSTAL) && mainHandItem.m_150930_((Item)EnigmaticDelightItems.CURSE_BLADE)) {
                crystal = offhandItem;
            }
            if (crystal != null) {
                SoulHelper.setSoulAmount(crystal, SoulHelper.getSoulAmount(crystal) + point);
            }
        }
    }

    public static class SoulHelper {
        public static int getSoulAmount(ItemStack stack) {
            return stack.m_41782_() ? stack.m_41783_().m_128451_("CurseSoulAmount") : 0;
        }

        public static void setSoulAmount(ItemStack stack, int amount) {
            stack.m_41784_().m_128405_("CurseSoulAmount", amount);
        }

        public static void addKillCount(ItemStack stack) {
            int count = stack.m_41782_() ? stack.m_41783_().m_128451_("KillCount") : 0;
            stack.m_41784_().m_128405_("KillCount", count + 1);
        }

        public static int getKillCount(ItemStack stack) {
            return stack.m_41782_() ? stack.m_41783_().m_128451_("KillCount") : 0;
        }

        public static void setSoulThreshold(ItemStack stack, Player player) {
            stack.m_41784_().m_128405_("CurseSoulThreshold", Mth.m_14143_((float)(player.m_21233_() * 10.0f)));
        }

        public static int getSoulThreshold(ItemStack stack) {
            return stack.m_41782_() ? stack.m_41783_().m_128451_("CurseSoulThreshold") : 0;
        }
    }
}

