/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.delicacy.contents.crafting;

import auviotre.enigmatic.delicacy.contents.items.EnigmaticFruit;
import auviotre.enigmatic.delicacy.registries.EnigmaticDelightItems;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import java.util.List;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;

public class EnigmaticAmuletRecipe
extends CustomRecipe {
    public static final SimpleCraftingRecipeSerializer<EnigmaticAmuletRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(EnigmaticAmuletRecipe::new);
    public static final List<Item> ITEM_LIST = List.of(Items.f_42417_, EnigmaticItems.EARTH_HEART, Items.f_42417_, Items.f_42587_, Items.f_41852_, Items.f_42587_, Items.f_42587_, EnigmaticDelightItems.ENIGMATIC_FRUIT, Items.f_42587_);
    public static final Map<Float, String> MAP = Map.of(Float.valueOf(0.1f), "red", Float.valueOf(0.2f), "aqua", Float.valueOf(0.3f), "violet", Float.valueOf(0.4f), "magenta", Float.valueOf(0.5f), "green", Float.valueOf(0.6f), "black", Float.valueOf(0.7f), "blue");

    public EnigmaticAmuletRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        if (container.m_6643_() != 9) {
            return false;
        }
        boolean flag = true;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack checkedStack = container.m_8020_(i);
            if (i == 4 && !checkedStack.m_41619_()) {
                flag = false;
            } else if (!checkedStack.m_150930_(ITEM_LIST.get(i))) {
                flag = false;
            }
            if (i != 7 || EnigmaticFruit.getColor(checkedStack) != 0.0f) continue;
            flag = false;
        }
        return flag;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        boolean flag = true;
        float color = 0.0f;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack checkedStack = container.m_8020_(i);
            if (i == 4 && !checkedStack.m_41619_()) {
                flag = false;
            } else if (!checkedStack.m_150930_(ITEM_LIST.get(i))) {
                flag = false;
            }
            if (i != 7 || (color = EnigmaticFruit.getColor(checkedStack)) != 0.0f) continue;
            flag = false;
        }
        ItemStack amulet = EnigmaticItems.ENIGMATIC_AMULET.m_7968_();
        if (flag) {
            ItemNBTHelper.setFloat((ItemStack)amulet, (String)"AssignedColor", (float)color);
        }
        return flag ? amulet : ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height == 9;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

