/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.objects;

import auviotre.enigmatic.addon.handlers.OmniconfigAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class SpecialLootModifier
extends LootModifier {
    public static final Supplier<Codec<SpecialLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SpecialLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SpecialLootModifier::new)));

    protected SpecialLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        ServerLevel level = context.m_78952_();
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            boolean isNether = SuperpositionHandler.getNetherDungeons().stream().anyMatch(table -> table.equals((Object)context.getQueriedLootTableId()));
            boolean isOver = SuperpositionHandler.getOverworldDungeons().stream().anyMatch(table -> table.equals((Object)context.getQueriedLootTableId()));
            if (isNether && player.m_217043_().m_188503_(3) == 0 && !SuperpositionHandler.hasPersistentTag((Player)player, (String)"LootedHellCharm") && OmniconfigAddonHandler.isItemEnabled((Object)EnigmaticAddonItems.HELL_BLADE_CHARM) && generatedLoot.stream().anyMatch(stack -> stack.m_150930_((Item)EnigmaticAddonItems.ICHOR_DROPLET))) {
                generatedLoot.removeIf(stack -> stack.m_150930_((Item)EnigmaticAddonItems.ICHOR_DROPLET));
                generatedLoot.add((Object)EnigmaticAddonItems.HELL_BLADE_CHARM.m_7968_());
                SuperpositionHandler.setPersistentBoolean((Player)player, (String)"LootedHellCharm", (boolean)true);
            }
            if (isOver && player.m_217043_().m_188499_() && !SuperpositionHandler.hasPersistentTag((Player)player, (String)"LootedVoidTome") && OmniconfigAddonHandler.isItemEnabled((Object)EnigmaticAddonItems.VOID_TOME) && generatedLoot.stream().anyMatch(stack -> stack.m_150930_((Item)EnigmaticAddonItems.FORGER_GEM))) {
                generatedLoot.removeIf(stack -> stack.m_150930_((Item)EnigmaticAddonItems.FORGER_GEM));
                generatedLoot.add((Object)EnigmaticAddonItems.VOID_TOME.m_7968_());
                SuperpositionHandler.setPersistentBoolean((Player)player, (String)"LootedVoidTome", (boolean)true);
            }
            if (isOver && player.m_217043_().m_188503_(100000) == 0 && generatedLoot.stream().anyMatch(stack -> stack.m_150930_((Item)EnigmaticAddonItems.EARTH_HEART_FRAGMENT))) {
                generatedLoot.removeIf(stack -> stack.m_150930_((Item)EnigmaticAddonItems.EARTH_HEART_FRAGMENT));
                generatedLoot.add((Object)EnigmaticAddonItems.ENIGMATIC_PEARL.m_7968_());
            }
        }
        return generatedLoot;
    }

    public Codec<SpecialLootModifier> codec() {
        return CODEC.get();
    }
}

