/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ISpellstone;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ExperienceHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;

public class RevivalLeaf
extends ItemSpellstoneCurio
implements ISpellstone {
    private static final List<TagKey<Block>> PLANT_SET = List.of(BlockTags.f_13041_, BlockTags.f_13104_, BlockTags.f_278411_);
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.IntParameter naturalRegenerationSpeed;
    public static Omniconfig.DoubleParameter skillRadius;
    public static Omniconfig.IntParameter poisonTime;
    public static Omniconfig.IntParameter poisonLevel;
    public static Omniconfig.IntParameter regenerationTime;
    public static Omniconfig.IntParameter regenerationLevel;
    public Map<Player, Integer> flyMap = new WeakHashMap<Player, Integer>();

    public RevivalLeaf() {
        super(ItemSpellstoneCurio.getDefaultProperties().m_41497_(Rarity.RARE));
        this.immunityList.add(DamageTypes.f_268493_);
        this.resistanceList.put(DamageTypes.f_268631_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268468_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268546_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268434_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268684_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268534_, () -> Float.valueOf(1.5f));
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("RevivalLeaf");
        spellstoneCooldown = builder.comment("Active ability cooldown for Revival Leaf. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 320);
        naturalRegenerationSpeed = builder.comment("The time required for each 0.5HP treatment from the natural regeneration of the Revival Leaf. Measured in ticks.").min(5.0).getInt("NaturalRegenerationTick", 40);
        skillRadius = builder.comment("The effect radius of Revival Leaf' ability.").getDouble("AbilityRadius", 5.0);
        poisonTime = builder.comment("Amount of ticks for which bearer of the leaf will apply Poison effect to entities they attack. 20 ticks equals to 1 second.").getInt("PoisonTime", 160);
        poisonLevel = builder.comment("Level of Poison that bearer of the leaf will apply to entities they attack.").max(3.0).getInt("PoisonLevel", 1);
        regenerationTime = builder.comment("Amount of ticks for which bearer of the leaf will apply Regeneration effect to entities nearby when ability activated.").getInt("RegenerationTime", 180);
        regenerationLevel = builder.comment("Level of Regeneration that bearer of the leaf will apply to entities nearby when ability activated.").max(3.0).getInt("RegenerationLevel", 1);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeafCooldown", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{Float.valueOf((float)this.getCooldown((Player)Minecraft.m_91087_().f_91074_) / 20.0f)});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf6");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf7");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf8");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf9");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf10");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.currentKeybind", (ChatFormatting)ChatFormatting.LIGHT_PURPLE, (Object[])new Object[]{((Component)KeyMapping.m_90842_((String)"key.spellstoneAbility").get()).getString().toUpperCase()});
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public int getCooldown(Player player) {
        return player != null && reducedCooldowns.test(player) ? 200 : spellstoneCooldown.getValue();
    }

    public void triggerActiveAbility(Level world, ServerPlayer player, ItemStack stack) {
        if (!SuperpositionHandler.hasSpellstoneCooldown((Player)player)) {
            int level = ExperienceHelper.getPlayerXPLevel((Player)player);
            int playerXP = ExperienceHelper.getPlayerXP((Player)player);
            if (playerXP > 10) {
                ExperienceHelper.drainPlayerXP((Player)player, (int)Math.min(Mth.m_14167_((float)(5.0f * player.m_217043_().m_188501_())) + level, playerXP));
                BlockPos pos = player.m_20183_();
                world.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, (float)(0.8 + Math.random() * 0.2));
                SuperpositionHandler.setSpellstoneCooldown((Player)player, (int)this.getCooldown((Player)player));
                List genericMobs = player.m_9236_().m_45976_(LivingEntity.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)player, (double)skillRadius.getValue()));
                for (LivingEntity mob : genericMobs) {
                    if (level > 25) {
                        float maxHealth = mob.m_21233_();
                        mob.m_5634_(Math.min(0.2f, (float)(level - 25) * 0.01f) * maxHealth);
                    }
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19605_, regenerationTime.getValue() + Math.min(playerXP * level / 2, regenerationTime.getValue()), regenerationLevel.getValue(), false, true));
                }
                Iterable iterable = BlockPos.m_121940_((BlockPos)pos.m_7918_(5, 5, 5), (BlockPos)pos.m_7918_(-5, -5, -5));
                for (BlockPos blockPos : iterable) {
                    if (!world.m_8055_(blockPos).m_60713_(Blocks.f_50070_)) continue;
                    world.m_46961_(blockPos, false);
                    world.m_7731_(blockPos, Blocks.f_50112_.m_49966_(), 3);
                }
            }
        }
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity entity = context.entity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_21220_().isEmpty()) {
                for (MobEffectInstance activeEffect : new ArrayList(player.m_21220_())) {
                    if (activeEffect.m_19544_() != MobEffects.f_19612_ && activeEffect.m_19544_() != MobEffects.f_19615_ && activeEffect.m_19544_() != MobEffects.f_19614_) continue;
                    player.m_21195_(activeEffect.m_19544_());
                }
            }
            if (!SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.FABULOUS_SCROLL) && !SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.HEAVEN_SCROLL)) {
                boolean flag;
                boolean bl = flag = !player.m_5833_() && !player.m_7500_() && player.m_150110_().f_35935_;
                if (this.hasPlantBy(player) && flag) {
                    player.m_246865_(new Vec3(0.0, (double)-0.012f, 0.0));
                }
                if (player.m_9236_().m_5776_()) {
                    if (player.f_19797_ % 12 == 0 && flag) {
                        int[] offset;
                        BlockPos lazyPos = BlockPos.m_122022_((long)player.getPersistentData().m_128454_("RevivalFlightLazyPos"));
                        Vec3 dist = player.m_20182_().m_82546_(lazyPos.m_252807_());
                        player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, player.m_20208_(0.5), player.m_20186_(), player.m_20262_(0.5), 0.0, 0.0, 0.0);
                        for (int x : offset = new int[]{0, 1}) {
                            for (int y : offset) {
                                for (int z : offset) {
                                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)(lazyPos.m_123341_() + x), (double)(lazyPos.m_123342_() + y), (double)(lazyPos.m_123343_() + z), 0.0, 0.0, 0.0);
                                }
                            }
                        }
                    }
                } else {
                    this.handleFlight(player);
                }
            }
            List entities = player.m_9236_().m_6443_(LivingEntity.class, player.m_20191_().m_82400_(5.0), living -> living.m_6084_() && living.m_21023_(MobEffects.f_19614_));
            for (LivingEntity poisoned : entities) {
                entity.getPersistentData().m_128379_("RevivingPoisoned", true);
            }
            BlockPos pos = player.m_20183_();
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-3, -1, -3), (BlockPos)pos.m_7918_(3, 1, 3))) {
                    BlockState state = world.m_8055_(blockPos);
                    Block block = state.m_60734_();
                    if (block instanceof CropBlock) {
                        CropBlock cropBlock = (CropBlock)block;
                        if (cropBlock.m_7419_() <= cropBlock.m_52305_(state) || random.nextInt(16) != 0) continue;
                        cropBlock.m_213898_(state, world, blockPos, player.m_217043_());
                        Vec3 vec3 = blockPos.m_252807_();
                        if (random.nextInt(12) != 0) continue;
                        world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1, 0.2, 0.2, 0.2, 0.0);
                        continue;
                    }
                    Block block2 = state.m_60734_();
                    if (!(block2 instanceof StemBlock)) continue;
                    StemBlock stemBlock = (StemBlock)block2;
                    stemBlock.m_213898_(state, world, blockPos, player.m_217043_());
                    Vec3 vec3 = blockPos.m_252807_();
                    if (random.nextInt(12) != 0) continue;
                    world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
        if (entity.f_19797_ % naturalRegenerationSpeed.getValue() == 0 && entity.m_21223_() < entity.m_21233_()) {
            entity.m_5634_(Math.max(0.5f, entity.m_21233_() / 100.0f));
        }
    }

    private boolean hasPlantBy(Player player) {
        BlockPos blockPos = player.m_20183_();
        Iterable posSet = BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-5, -5, -5), (BlockPos)blockPos.m_7918_(5, 5, 5));
        if (player.getPersistentData().m_128441_("RevivalFlightLazyPos")) {
            long data = player.getPersistentData().m_128454_("RevivalFlightLazyPos");
            BlockPos lazyPos = BlockPos.m_122022_((long)data);
            BlockState blockState = player.m_9236_().m_8055_(lazyPos);
            if (PLANT_SET.stream().anyMatch(arg_0 -> ((BlockState)blockState).m_204336_(arg_0)) && lazyPos.m_203193_((Position)player.m_20182_()) < Math.pow(player.getEntityReach() + 1.0, 2.0)) {
                return true;
            }
        }
        for (BlockPos pos : posSet) {
            BlockState blockState = player.m_9236_().m_8055_(pos);
            if (!PLANT_SET.stream().anyMatch(arg_0 -> ((BlockState)blockState).m_204336_(arg_0)) || !(pos.m_203193_((Position)player.m_20182_()) < Math.pow(player.getEntityReach() + 1.0, 2.0))) continue;
            player.getPersistentData().m_128356_("RevivalFlightLazyPos", pos.m_121878_());
            return true;
        }
        return false;
    }

    protected void handleFlight(Player player) {
        try {
            if (this.hasPlantBy(player)) {
                if (!player.m_150110_().f_35936_) {
                    player.m_150110_().f_35936_ = true;
                    player.m_6885_();
                }
                this.flyMap.put(player, 5);
            } else if (this.flyMap.get(player) > 1) {
                this.flyMap.put(player, this.flyMap.get(player) - 1);
            } else if (this.flyMap.get(player) == 1) {
                if (!player.m_7500_()) {
                    player.m_150110_().f_35936_ = false;
                    player.m_150110_().f_35935_ = false;
                    player.m_6885_();
                }
                player.getPersistentData().m_128473_("RevivalFlightLazyPos");
                this.flyMap.put(player, 0);
            }
        }
        catch (NullPointerException exception) {
            exception.printStackTrace();
            player.getPersistentData().m_128473_("RevivalFlightLazyPos");
            this.flyMap.put(player, 0);
        }
    }

    public void onUnequip(SlotContext context, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_7500_()) {
                player.m_150110_().f_35936_ = false;
                player.m_150110_().f_35935_ = false;
                player.m_6885_();
            }
            player.getPersistentData().m_128473_("RevivalFlightLazyPos");
            this.flyMap.put(player, 0);
        }
    }
}

