/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.contents.entities.SoulFlameBall;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonDamageTypes;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ISpellstone;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.SlotContext;

public class IllusionLantern
extends ItemSpellstoneCurio
implements ISpellstone {
    private static final List<TagKey<Block>> PLANT_SET = List.of(BlockTags.f_13041_, BlockTags.f_13104_, BlockTags.f_278394_, BlockTags.f_278411_, BlockTags.f_278398_);
    private static final List<TagKey<DamageType>> BYPASS_SET = List.of(DamageTypeTags.f_268738_, DamageTypeTags.f_268630_, DamageTypeTags.f_268490_, DamageTypeTags.f_268413_, DamageTypeTags.f_268437_);
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.IntParameter fireballCooldown;
    public static Omniconfig.PerhapsParameter nonMagicDamageMultiplier;
    public static Omniconfig.PerhapsParameter bypassDamageResistance;

    public IllusionLantern() {
        super(ItemSpellstoneCurio.getDefaultProperties().m_41497_(Rarity.RARE));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("SoulLanternofIllusion");
        spellstoneCooldown = builder.comment("Active ability cooldown for Soul Lantern of Illusion. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 0);
        fireballCooldown = builder.comment("The cooldown of soul fireball generating for Soul Lantern of Illusion. Measured in ticks.").getInt("FireballCooldown", 60);
        nonMagicDamageMultiplier = builder.comment("The damage multiplier of the non-magic damage you received. Measured in percentage.").min(0.0).getPerhaps("NonMagicDamageMultiplier", 25);
        bypassDamageResistance = builder.comment("The damage resistance multiplier of the bypass-armor damage you received. Measured in percentage.").max(80.0).getPerhaps("BypassDamageResistance", 50);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.illusionLantern1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.illusionLantern2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.illusionLanternCooldown", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{Float.valueOf((float)spellstoneCooldown.getValue() / 20.0f)});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.illusionLantern3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.illusionLantern4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.illusionLantern5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.illusionLantern6");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.illusionLantern7");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.illusionLantern8");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.illusionLantern9");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.currentKeybind", (ChatFormatting)ChatFormatting.LIGHT_PURPLE, (Object[])new Object[]{((Component)KeyMapping.m_90842_((String)"key.spellstoneAbility").get()).getString().toUpperCase()});
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof ServerPlayer) {
            List balls;
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!player.m_36335_().m_41519_((Item)this) && (balls = player.m_9236_().m_45976_(SoulFlameBall.class, player.m_20191_().m_82400_(3.0))).size() < 5) {
                player.m_36335_().m_41524_((Item)this, fireballCooldown.getValue());
                SoulFlameBall soulFlameBall = new SoulFlameBall(player.m_9236_(), (LivingEntity)player);
                soulFlameBall.getPersistentData().m_128405_("BallID", balls.size());
                player.m_9236_().m_7967_((Entity)soulFlameBall);
            }
            if (player.f_19797_ % 20 == 0 && !player.m_7500_() && !player.m_5833_()) {
                Level level = player.m_9236_();
                BlockPos blockPos = player.m_20183_();
                boolean seeSky = level.m_46861_(blockPos);
                int rawBrightness = level.m_5518_().m_75831_(blockPos, 8);
                if (seeSky && rawBrightness > 9) {
                    player.m_6469_(SuperAddonHandler.simpleSource((Entity)player, EnigmaticAddonDamageTypes.EVIL_CURSE), player.m_21233_() / 5.0f);
                }
                Iterable posSet = BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-5, -5, -5), (BlockPos)blockPos.m_7918_(5, 5, 5));
                for (BlockPos pos : posSet) {
                    BlockState blockState = level.m_8055_(pos);
                    if (!PLANT_SET.stream().anyMatch(arg_0 -> ((BlockState)blockState).m_204336_(arg_0))) continue;
                    level.m_46953_(pos, false, (Entity)player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (entity instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)entity), (Item)this)) {
            boolean magic = source.m_269415_().f_268677_().contains("magic");
            boolean spell = source.m_269415_().f_268677_().contains("spell");
            boolean witch = source.m_269533_(DamageTypeTags.f_268731_);
            if (!(magic || spell || witch)) {
                event.setAmount(event.getAmount() * nonMagicDamageMultiplier.getValue().asModifier(true));
            }
            if (BYPASS_SET.stream().anyMatch(arg_0 -> ((DamageSource)source).m_269533_(arg_0))) {
                event.setAmount(event.getAmount() * (1.0f - bypassDamageResistance.getValue().asModifier()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDamage(LivingDamageEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (BYPASS_SET.stream().anyMatch(arg_0 -> ((DamageSource)event.getSource()).m_269533_(arg_0))) {
            return;
        }
        if (entity instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)entity), (Item)this)) {
            Predicate<LivingEntity> noSharing = living -> {
                OwnableEntity own;
                if (living instanceof OwnableEntity && (own = (OwnableEntity)living).m_269323_() == player) {
                    return false;
                }
                if (living.equals((Object)event.getSource().m_7639_())) {
                    return false;
                }
                if (living.equals((Object)player) || player.m_7307_((Entity)living)) {
                    return false;
                }
                return living.m_6084_() && !SuperpositionHandler.hasCurio((LivingEntity)living, (Item)this);
            };
            List entities = player.m_9236_().m_6443_(LivingEntity.class, player.m_20191_().m_82400_(8.0), noSharing);
            if (entities.isEmpty()) {
                return;
            }
            int size = entities.size();
            float baseDamage = event.getAmount() / (float)(size + 1) / (float)(size + 1);
            event.setAmount(baseDamage * (float)(2 * size + 1));
            for (LivingEntity livingEntity : entities) {
                livingEntity.m_6469_(SuperAddonHandler.damageSource((Entity)livingEntity, (ResourceKey<DamageType>)DamageTypes.f_268515_, (Entity)player), baseDamage * (float)size);
            }
        }
    }
}

