/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class ForgerGem
extends ItemBaseCurio {
    public static final List<ResourceLocation> blackList = new ArrayList<ResourceLocation>();
    private static final String[] defaultBlackList = new String[]{"enigmaticaddons:totem_of_malice", "twilightforest:glass_sword"};
    public static Omniconfig.BooleanParameter strictUnbreakableForge;
    public static Omniconfig.BooleanParameter levelNotValue;
    public static Omniconfig.IntParameter unbreakableRepairCost;

    public ForgerGem() {
        super(ForgerGem.getDefaultProperties().m_41497_(Rarity.EPIC).m_41486_().m_41487_(1));
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("ForgerGem");
        strictUnbreakableForge = builder.comment("Whether to enable stricter detection for unbreakable forging when equipped the Forger's Gem. True for enable.").getBoolean("StrictUnbreakableForge", true);
        levelNotValue = builder.comment("Whether the halving experience by level or value. True for level.").getBoolean("EXPLevelNotValue", false);
        unbreakableRepairCost = builder.comment("The extra repair cost after unbreakable forging when equipped the Forger's Gem.").min(2.0).getInt("UnbreakableRepairCost", 10);
        blackList.clear();
        String[] list = builder.config.getStringList("ForgerGemUnbreakableBlackList", "Balance Options", defaultBlackList, "List of items that will never be unbreakable. Examples: minecraft:iron_sword. Changing this option required game restart to take effect.");
        Arrays.stream(list).forEach(entry -> blackList.add(new ResourceLocation(entry)));
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.enchantersPearl1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgerGem2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgerGem3");
            if (Minecraft.m_91087_().f_91074_ != null && SuperAddonHandler.isOKOne((Player)Minecraft.m_91087_().f_91074_)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgerGem4");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgerGem5");
            }
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        if (slotContext.entity() instanceof Player) {
            CuriosApi.addSlotModifier((Multimap)attributes, (String)"charm", (UUID)UUID.fromString("4f9d6bf4-49b5-6543-8796-b0c75e53aa91"), (double)1.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        }
        return attributes;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }

    public boolean isPresent(Player player) {
        return SuperAddonHandler.isOKOne(player) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)this);
    }

    public boolean canEquip(SlotContext context, ItemStack stack) {
        if (context.entity() instanceof Player) {
            return super.canEquip(context, stack);
        }
        return false;
    }
}

