/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.TradeWithVillagerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class AvariceRing
extends ItemBaseCurio
implements ICursed {
    public static final List<ResourceLocation> merchantList = new ArrayList<ResourceLocation>();
    public static Omniconfig.DoubleParameter damageBoostMultiplier;

    public AvariceRing() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC).m_41487_(1).m_41486_());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("RingofUltimateLuxury");
        damageBoostMultiplier = builder.comment("The damage boost multiplier of the Ring of Ultimate Luxury .").max(2.0).min(0.0).getDouble("DamageBoostMultiplier", 0.5);
        merchantList.clear();
        builder.forceSynchronized(true);
        String[] list = builder.config.getStringList("RingofUltimateLuxuryExtraMerchantList", "Balance Options", new String[0], "List of entities that will be affected as Golem by the Ring of Ultimate Luxury. Examples: minecraft:iron_golem. Changing this option required game restart to take effect.");
        Arrays.stream(list).forEach(entry -> merchantList.add(new ResourceLocation(entry)));
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.avariceScroll1", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{1});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.avariceRing1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.avariceRing2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.avariceRing3");
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.AVARICE_SCROLL)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.avariceRing4_alt");
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.avariceRing4");
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.AVARICE_SCROLL)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.avariceRing5");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.avariceRing6", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("+%.01f%%", Float.valueOf(this.getDamageBoost((Player)player) * 100.0f))});
            }
        } else {
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.AVARICE_SCROLL)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.avariceRing6", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("+%.01f%%", Float.valueOf(this.getDamageBoost((Player)player) * 100.0f))});
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
    }

    private float getDamageBoost(Player player) {
        float count = 0.0f;
        for (NonNullList compartment : player.m_150109_().f_35979_) {
            for (ItemStack stack : compartment) {
                if (!stack.m_204117_(Tags.Items.GEMS)) continue;
                count += (float)stack.m_41613_();
            }
        }
        return (float)(damageBoostMultiplier.getValue() * Math.log(1.0f + count) / Math.log(64.0));
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity entity = context.entity();
        List raiders = entity.m_9236_().m_45976_(Raider.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)entity, (double)8.0));
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                return;
            }
        }
        for (Raider raider : raiders) {
            double visibility = entity.m_20968_((Entity)raider);
            double angerDistance = Math.max(8.0 * visibility, 5.0);
            if (!entity.m_142582_((Entity)raider) && !(entity.m_20270_((Entity)raider) <= 5.0f) || !(raider.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()) <= angerDistance * angerDistance)) continue;
            if (raider.m_5448_() != null && raider.m_5448_().m_6084_()) {
                if (SuperpositionHandler.hasCurio((LivingEntity)raider.m_5448_(), (Item)this)) continue;
                raider.m_6703_(entity);
                raider.m_6710_(entity);
                continue;
            }
            raider.m_6703_(entity);
            raider.m_6710_(entity);
        }
    }

    public boolean canEquip(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity;
        if (super.canEquip(context, stack) && (livingEntity = context.entity()) instanceof Player) {
            Player player = (Player)livingEntity;
            return SuperpositionHandler.isTheCursedOne((Player)player);
        }
        return false;
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack curio) {
        return super.getFortuneLevel(slotContext, lootContext, curio) + 1;
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent event) {
        Entity entity;
        Player player;
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)entity2), (Item)this) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.AVARICE_SCROLL)) {
            event.setAmount(event.getAmount() * (1.0f + this.getDamageBoost(player)));
        }
        if ((entity = event.getSource().m_7639_()) instanceof Raider) {
            Player player2;
            Raider raider = (Raider)entity;
            entity = event.getEntity();
            if (entity instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player2 = (Player)entity), (Item)this)) {
                event.setAmount(event.getAmount() * (1.0f + this.getDamageBoost(player2) / 2.0f));
            }
        }
    }

    @SubscribeEvent
    public void onTrade(TradeWithVillagerEvent event) {
        Player player = event.getEntity();
        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)this)) {
            MerchantOffer merchantOffer = event.getMerchantOffer();
            merchantOffer.m_45372_();
            if (merchantOffer.m_45378_() < 0.0f) {
                merchantOffer.m_45376_();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)livingEntity), (Item)this)) {
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.AVARICE_SCROLL)) {
                return;
            }
            for (NonNullList compartment : player.m_150109_().f_35979_) {
                for (ItemStack itemStack : compartment) {
                    this.clearEmerald(player.m_9236_(), itemStack);
                }
            }
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                int slots = handler.getEquippedCurios().getSlots();
                for (int i = 0; i < slots; ++i) {
                    this.clearEmerald(player.m_9236_(), handler.getEquippedCurios().getStackInSlot(i));
                }
            });
        }
    }

    private void clearEmerald(Level level, ItemStack stack) {
        if (stack.m_41778_().contains("emerald") || stack.m_204117_(Tags.Items.GEMS_EMERALD)) {
            stack.m_41764_(0);
        } else {
            RecipeManager manager = level.m_7465_();
            Collection recipes = manager.m_44051_();
            for (Recipe recipe : recipes) {
                if (!recipe.m_8043_(level.m_9598_()).m_150930_(stack.m_41720_())) continue;
                for (Ingredient ingredient : recipe.m_7527_()) {
                    for (ItemStack item : ingredient.m_43908_()) {
                        if (!item.m_41778_().contains("emerald") && !stack.m_204117_(Tags.Items.GEMS_EMERALD)) continue;
                        stack.m_41764_(0);
                        return;
                    }
                }
            }
        }
    }
}

