/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.client.screens.ArtificialFlowerScreen;
import auviotre.enigmatic.addon.contents.gui.ArtificialFlowerMenu;
import auviotre.enigmatic.addon.contents.objects.bookbag.AntiqueBagCapability;
import auviotre.enigmatic.addon.contents.objects.bookbag.IAntiqueBagHandler;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import auviotre.enigmatic.addon.registries.EnigmaticAddonPotions;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.registries.EnigmaticPotions;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ArtificialFlower
extends ItemBase {
    public static final List<ResourceLocation> attributeBlackList = new ArrayList<ResourceLocation>();
    public static final List<ResourceLocation> effectBlackList = new ArrayList<ResourceLocation>();
    public static final Map<ServerPlayer, Map<ImmutableMultimap<Attribute, AttributeModifier>, Integer>> PLAYER_ATTRIBUTE_MAP = new HashMap<ServerPlayer, Map<ImmutableMultimap<Attribute, AttributeModifier>, Integer>>();
    private static final String[] defaultAttributeBlackList = new String[]{"caelus:fall_flying", "goety_revelation:resistance"};
    private static final String[] defaultEffectBlackList = new String[]{"alexscaves:darkness_incarnate", "alexsmobs:oiled", "aquamirae:crystallization", "born_in_chaos_v1:light_rampage", "born_in_chaos_v1:medium_rampage", "born_in_chaos_v1:strong_rampage", "born_in_chaos_v1:furious_rampage", "born_in_chaos_v1:rampant_rampage", "cataclysm:ghost_form", "cataclysm:ghost_sickness", "enigmaticdelicacy:astral_drunkenness", "enigmaticdelicacy:abyss_corruption", "enigmaticdelicacy:fading", "enigmaticdelicacy:health_curse", "enigmaticlegacy:blazing_strength", "goety:shadow_walk", "irons_spellbooks:abyssal_shroud", "irons_spellbooks:evasion", "irons_spellbooks:heartstop", "irons_spellbooks:true_invisibility", "ltc2:undying_benediction", "more_potion_effects:extension", "more_potion_effects:immortal", "more_potion_effects:static_life", "supernatural:supernatural", "unusual_delight:crystal_aspect", "unusual_delight:ember_aspect", "unusual_delight:vitality"};
    public static Omniconfig.PerhapsParameter randomInstantaneousEffectModifier;
    public static Omniconfig.PerhapsParameter randomAttributeMaxModifier;

    public ArtificialFlower() {
        super(ItemBase.getDefaultProperties().m_41487_(1).m_41497_(Rarity.RARE));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("ArtificialFlower");
        randomAttributeMaxModifier = builder.comment("The max modifier of the Magic Quartz Flower. Measures in percentage.").max(100.0).getPerhaps("RandomAttributeMaxModifier", 16);
        randomInstantaneousEffectModifier = builder.comment("The modifier of the instantaneous effect provided by Magic Quartz Flower. Measures in percentage.").max(100.0).getPerhaps("RandomInstantaneousEffectModifier", 80);
        attributeBlackList.clear();
        builder.forceSynchronized(true);
        String[] list = builder.config.getStringList("ArtificialFlowerAttributeBlackList", "Balance Options", defaultAttributeBlackList, "List of Attributes that will never appear in Magic Quartz Flower. Changing this option required game restart to take effect.");
        Arrays.stream(list).forEach(entry -> attributeBlackList.add(new ResourceLocation(entry)));
        effectBlackList.clear();
        list = builder.config.getStringList("ArtificialFlowerEffectBlackList", "Balance Options", defaultEffectBlackList, "List of Effects that will never appear in Magic Quartz Flower. Changing this option required game restart to take effect.");
        Arrays.stream(list).forEach(entry -> effectBlackList.add(new ResourceLocation(entry)));
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        int id;
        list.add((Component)Component.m_237115_((String)"tooltip.enigmaticaddons.artificialFlowerAttribute"));
        int count = 0;
        for (id = 1; id <= 3; ++id) {
            if (Helper.getAttribute(stack, id) == null) continue;
            list.add(ArtificialFlowerScreen.getComponent(Helper.getAttribute(stack, id)));
            ++count;
        }
        if (count == 0) {
            list.add((Component)Component.m_237115_((String)"tooltip.enigmaticaddons.artificialFlowerNone"));
        }
        list.add((Component)Component.m_237115_((String)"tooltip.enigmaticaddons.artificialFlowerEffect"));
        count = 0;
        for (id = 0; id < 2; ++id) {
            MobEffect effect = Helper.getEffect(stack, id);
            if (effect == null) continue;
            ++count;
            int suffix = stack.m_41784_().m_128441_("MagicRing") ? 1 : 0;
            MutableComponent name = Component.m_237115_((String)effect.m_19481_()).m_130940_(effect.m_19486_() ? ChatFormatting.GREEN : ChatFormatting.RED);
            MutableComponent immunity = Component.m_237110_((String)"gui.enigmaticaddons.artificial_flower_immunity", (Object[])new Object[]{name});
            MutableComponent providing = Component.m_237110_((String)("gui.enigmaticaddons.artificial_flower_provide" + suffix), (Object[])new Object[]{name});
            list.add((Component)(id == 0 ? providing : immunity));
        }
        if (count == 0) {
            list.add((Component)Component.m_237115_((String)"tooltip.enigmaticaddons.artificialFlowerNone"));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41784_().m_128471_("FlowerEnable");
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int id, boolean selected) {
        IAntiqueBagHandler bagHandler;
        Pair<Attribute, AttributeModifier> attribute;
        int i;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CompoundTag tag = stack.m_41784_();
        if (player instanceof ServerPlayer) {
            UUID flowerEnableUUID = Helper.getPlayerEnableUUID(player);
            UUID flowerUUID = Helper.getFlowerUUID(stack);
            if ((flowerUUID == null || !flowerUUID.equals(flowerEnableUUID)) && tag.m_128471_("FlowerEnable")) {
                tag.m_128379_("FlowerEnable", false);
                for (i = 1; i <= 3; ++i) {
                    attribute = Helper.getAttribute(stack, i);
                    if (attribute == null) continue;
                    ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                    builder.put((Object)((Attribute)attribute.getFirst()), (Object)((AttributeModifier)attribute.getSecond()));
                    player.m_21204_().m_22161_((Multimap)builder.build());
                }
            }
        }
        boolean bagFlag = false;
        LazyOptional<IAntiqueBagHandler> capability = SuperAddonHandler.getCapability(player, AntiqueBagCapability.INVENTORY);
        if (capability != null && capability.isPresent() && (bagHandler = (IAntiqueBagHandler)capability.orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty"))).hasFlower()) {
            ItemStack bagStack = bagHandler.getBook(stack.m_41784_().m_128451_("FlowerBagEnable"));
            boolean bl = bagFlag = Helper.getFlowerUUID(bagStack) != null && Helper.getFlowerUUID(bagStack).equals(Helper.getFlowerUUID(stack));
        }
        if (tag.m_128471_("FlowerEnable") || bagFlag) {
            MobEffect effectImmuneTo;
            for (i = 1; i <= 3; ++i) {
                attribute = Helper.getAttribute(stack, i);
                if (attribute == null || !attributeBlackList.contains(ForgeRegistries.ATTRIBUTES.getKey((Object)((Attribute)attribute.getFirst())))) continue;
                Helper.removeAttribute(stack, i);
            }
            for (i = 0; i < 2; ++i) {
                MobEffect effect = Helper.getEffect(stack, i);
                if (effect == null || !effectBlackList.contains(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect))) continue;
                Helper.removeEffect(stack, i);
            }
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (int i2 = 1; i2 <= 3; ++i2) {
                if (Helper.getAttribute(stack, i2) == null) continue;
                Pair<Attribute, AttributeModifier> attribute2 = Helper.getAttribute(stack, i2);
                builder.put((Object)((Attribute)attribute2.getFirst()), (Object)((AttributeModifier)attribute2.getSecond()));
            }
            ImmutableMultimap attributeMap = builder.build();
            if (player instanceof ServerPlayer) {
                ServerPlayer server = (ServerPlayer)player;
                if (!attributeMap.isEmpty()) {
                    Map<Object, Object> attributeTickMap = PLAYER_ATTRIBUTE_MAP.containsKey(server) ? PLAYER_ATTRIBUTE_MAP.get(player) : new HashMap();
                    if (attributeTickMap.containsKey(attributeMap)) {
                        attributeTickMap.replace(attributeMap, 3);
                    } else {
                        attributeTickMap.put(attributeMap, 3);
                    }
                    PLAYER_ATTRIBUTE_MAP.put(server, attributeTickMap);
                }
            }
            if ((effectImmuneTo = Helper.getEffect(stack, 1)) != null && player.m_21023_(effectImmuneTo)) {
                player.m_21195_(effectImmuneTo);
            }
            MobEffect effectProvided = Helper.getEffect(stack, 0);
            int amplifier = 0;
            if (tag.m_128441_("MagicRing")) {
                ++amplifier;
            }
            if (effectProvided != null) {
                if (effectProvided.m_8093_()) {
                    if (player.f_19797_ % 100 == 0) {
                        effectProvided.m_19461_((Entity)player, (Entity)player, (LivingEntity)player, amplifier, (double)randomInstantaneousEffectModifier.getValue().asModifier());
                    }
                } else {
                    MobEffectInstance newInstance = new MobEffectInstance(effectProvided, 36, amplifier, true, true);
                    if (player.m_21023_(effectProvided)) {
                        MobEffectInstance instance = player.m_21124_(effectProvided);
                        if (instance.m_19564_() == amplifier && instance.m_19557_() <= 4) {
                            instance.f_19503_ = 36;
                        } else if (instance.m_19564_() < amplifier) {
                            instance.m_19558_(newInstance);
                        }
                    } else {
                        player.m_7292_(newInstance);
                    }
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        player.m_36335_().m_41524_((Item)this, 30);
        player.m_21120_(hand).m_41784_().m_128379_("FlowerEnable", false);
        if (!world.f_46443_) {
            player.m_5893_((MenuProvider)new ArtificialFlowerMenu.Provider());
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    @SubscribeEvent
    public void onEffectApply(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MobEffectInstance effect = event.getEffectInstance();
            if (effect == null) {
                return;
            }
            List<ItemStack> flowers = SuperAddonHandler.getAllItem(player, (Item)this);
            for (ItemStack flower : flowers) {
                if (!effect.m_19544_().equals(Helper.getEffect(flower, 1))) continue;
                event.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        PLAYER_ATTRIBUTE_MAP.forEach((player, attributeTickMap) -> {
            if (attributeTickMap.isEmpty()) {
                return;
            }
            List multiMapSet = attributeTickMap.keySet().stream().toList();
            for (ImmutableMultimap attribute : multiMapSet) {
                Integer tick = (Integer)attributeTickMap.get(attribute);
                if (tick <= 1) {
                    player.m_21204_().m_22161_((Multimap)attribute);
                    attributeTickMap.remove(attribute);
                    continue;
                }
                player.m_21204_().m_22178_((Multimap)attribute);
                attributeTickMap.replace(attribute, tick - 1);
            }
        });
    }

    public static class Helper {
        public static List<Attribute> attributePool;
        public static List<MobEffect> potionEffectPool;
        public static List<MobEffect> allEffectPool;

        public static void initRandomPool() {
            ImmutableList.Builder attributeBuilder = new ImmutableList.Builder();
            ForgeRegistries.ATTRIBUTES.getValues().forEach(attribute -> {
                if (!attributeBlackList.contains(ForgeRegistries.ATTRIBUTES.getKey(attribute))) {
                    attributeBuilder.add(attribute);
                }
            });
            attributePool = attributeBuilder.build();
            ImmutableList.Builder effectImmuneBuilder = new ImmutableList.Builder();
            ForgeRegistries.MOB_EFFECTS.getValues().forEach(effect -> {
                if (effectBlackList.contains(ForgeRegistries.MOB_EFFECTS.getKey(effect))) {
                    return;
                }
                if (ForgeRegistries.MOB_EFFECTS.getKey(effect).toString().contains("flight")) {
                    return;
                }
                if (ForgeRegistries.MOB_EFFECTS.getKey(effect).toString().contains("fly")) {
                    return;
                }
                effectImmuneBuilder.add(effect);
            });
            allEffectPool = effectImmuneBuilder.build();
            ImmutableList.Builder effectProvidingBuilder = new ImmutableList.Builder();
            ArrayList<MobEffect> effects = new ArrayList<MobEffect>();
            for (Potion potion2 : ForgeRegistries.POTIONS.getValues()) {
                for (MobEffectInstance instance : potion2.m_43488_()) {
                    if (effects.contains(instance.m_19544_())) continue;
                    effects.add(instance.m_19544_());
                }
            }
            EnigmaticAddonPotions.COMMON_POTIONS.forEach(potion -> potion.getEffects().forEach(effect -> {
                if (!effects.contains(effect.m_19544_())) {
                    effects.add(effect.m_19544_());
                }
            }));
            EnigmaticPotions.COMMON_POTIONS.forEach(potion -> potion.getEffects().forEach(effect -> {
                if (!effects.contains(effect.m_19544_())) {
                    effects.add(effect.m_19544_());
                }
            }));
            effects.forEach(effect -> {
                if (effectBlackList.contains(ForgeRegistries.MOB_EFFECTS.getKey(effect))) {
                    return;
                }
                if (ForgeRegistries.MOB_EFFECTS.getKey(effect).toString().contains("flight")) {
                    return;
                }
                if (ForgeRegistries.MOB_EFFECTS.getKey(effect).toString().contains("fly")) {
                    return;
                }
                effectProvidingBuilder.add(effect);
            });
            potionEffectPool = effectProvidingBuilder.build();
        }

        public static void setAttribute(ItemStack stack, int index, Attribute attribute, AttributeModifier attributeModifier) {
            String id = "AttributeId" + index;
            String modifier = "AttributeModifier" + index;
            CompoundTag modifierTag = attributeModifier.m_22219_();
            stack.m_41784_().m_128365_(modifier, (Tag)modifierTag);
            stack.m_41784_().m_128359_(id, ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString());
        }

        public static void removeAttribute(ItemStack stack, int index) {
            stack.m_41784_().m_128473_("AttributeModifier" + index);
            stack.m_41784_().m_128473_("AttributeId" + index);
        }

        public static void setEffect(ItemStack stack, int index, MobEffect effect) {
            String id = "PotionEffect" + index;
            stack.m_41784_().m_128359_(id, ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).toString());
        }

        public static void removeEffect(ItemStack stack, int index) {
            stack.m_41784_().m_128473_("PotionEffect" + index);
        }

        @Nullable
        public static Pair<Attribute, AttributeModifier> getAttribute(ItemStack stack, int index) {
            String id = "AttributeId" + index;
            if (!stack.m_41782_() || !stack.m_41783_().m_128425_(id, 8)) {
                return null;
            }
            String modifier = "AttributeModifier" + index;
            if (!stack.m_41782_() || !stack.m_41783_().m_128425_(modifier, 10)) {
                return null;
            }
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(stack.m_41783_().m_128461_(id)));
            if (attribute == null) {
                Helper.removeAttribute(stack, index);
                return null;
            }
            AttributeModifier attributeModifier = AttributeModifier.m_22212_((CompoundTag)stack.m_41783_().m_128469_(modifier));
            return Pair.of((Object)attribute, (Object)attributeModifier);
        }

        @Nullable
        public static MobEffect getEffect(ItemStack stack, int index) {
            String id = "PotionEffect" + index;
            if (!stack.m_41782_() || !stack.m_41783_().m_128425_(id, 8)) {
                return null;
            }
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(stack.m_41783_().m_128461_(id)));
            if (effect == null) {
                Helper.removeEffect(stack, index);
                return null;
            }
            return effect;
        }

        public static void randomAttribute(Player player, ItemStack stack, int index, int cost, boolean boost) {
            Attribute attribute = attributePool.get(player.m_217043_().m_188503_(attributePool.size()));
            double defaultValue = attribute.m_22082_();
            double offset = (cost == 0 ? 0.0 : (cost == 1 ? 0.3 : 0.6)) - (boost ? 0.0 : 0.125);
            double value = 0.01 * (double)((int)(Mth.m_14008_((double)(player.m_217043_().m_188583_() + offset), (double)-2.5, (double)2.5) / 2.5 * (double)randomAttributeMaxModifier.getValue().asPercentage()));
            AttributeModifier modifier = new AttributeModifier("ArtificialFlower" + index, value, AttributeModifier.Operation.MULTIPLY_BASE);
            Pair<Attribute, AttributeModifier> oldAttribute = Helper.getAttribute(stack, index);
            if (oldAttribute != null) {
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                builder.put((Object)((Attribute)oldAttribute.getFirst()), (Object)((AttributeModifier)oldAttribute.getSecond()));
                player.m_21204_().m_22161_((Multimap)builder.build());
            }
            if (value == 0.0) {
                Helper.removeAttribute(stack, index);
            } else {
                Helper.setAttribute(stack, index, attribute, modifier);
            }
        }

        public static void randomEffect(Player player, ItemStack stack, int index) {
            MobEffect effect;
            int count = stack.m_41784_().m_128441_("AllEffectCount") ? stack.m_41784_().m_128451_("AllEffectCount") : 1;
            RandomSource playerRandom = player.m_217043_();
            do {
                if (index == 1 || playerRandom.m_188503_((count + 1) / 2) == 0) {
                    effect = allEffectPool.get(playerRandom.m_188503_(allEffectPool.size()));
                    System.out.print("FlowerCount: " + count + "\n");
                    stack.m_41784_().m_128405_("AllEffectCount", count + 1);
                    continue;
                }
                effect = potionEffectPool.get(playerRandom.m_188503_(potionEffectPool.size()));
            } while (effect == Helper.getEffect(stack, 1 - index));
            MobEffect oldEffect = Helper.getEffect(stack, index);
            if (oldEffect != null && player.m_21023_(oldEffect)) {
                player.m_21195_(oldEffect);
            }
            Helper.setEffect(stack, index, effect);
        }

        public static ItemStack getFlowerStack(Player player, boolean copy) {
            ItemStack mainHandItem = player.m_21205_();
            ItemStack flower = mainHandItem.m_150930_((Item)EnigmaticAddonItems.ARTIFICIAL_FLOWER) ? mainHandItem : player.m_21206_();
            return copy ? flower.m_41777_() : flower;
        }

        @Nullable
        public static UUID getFlowerUUID(ItemStack stack) {
            CompoundTag tag = stack.m_41784_();
            return tag.m_128403_("FlowerUUID") ? tag.m_128342_("FlowerUUID") : null;
        }

        @Nullable
        public static UUID getPlayerEnableUUID(Player player) {
            CompoundTag tag = player.getPersistentData();
            return tag.m_128403_("FlowerEnableUUID") ? tag.m_128342_("FlowerEnableUUID") : null;
        }
    }
}

