/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.gui;

import auviotre.enigmatic.addon.contents.items.ArtificialFlower;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import auviotre.enigmatic.addon.registries.EnigmaticAddonMenus;
import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtificialFlowerMenu
extends AbstractContainerMenu {
    public final Player player;
    private final ItemStackHandler enchantSlot;
    private final ItemStackHandler ringSlot;
    private final ContainerLevelAccess access;
    public int costMode = 0;

    public ArtificialFlowerMenu(int syncID, Inventory playerInv) {
        this(syncID, playerInv, ContainerLevelAccess.m_39289_((Level)playerInv.f_35978_.m_9236_(), (BlockPos)playerInv.f_35978_.m_20183_()));
    }

    public ArtificialFlowerMenu(int syncID, Inventory playerInv, FriendlyByteBuf extras) {
        this(syncID, playerInv, ContainerLevelAccess.m_39289_((Level)playerInv.f_35978_.m_9236_(), (BlockPos)playerInv.f_35978_.m_20183_()));
    }

    private ArtificialFlowerMenu(int id, Inventory inventory, ContainerLevelAccess access) {
        this(EnigmaticAddonMenus.ARTIFICIAL_FLOWER_MENU, id, inventory, access);
    }

    protected ArtificialFlowerMenu(@Nullable MenuType<?> menuType, int id, @NotNull Inventory inventory, ContainerLevelAccess access) {
        super(menuType, id);
        int k;
        this.player = inventory.f_35978_;
        this.enchantSlot = new ItemStackHandler(2);
        this.ringSlot = new ItemStackHandler(1);
        this.access = access;
        ItemStack flowerStack = ArtificialFlower.Helper.getFlowerStack(this.player, true);
        if (flowerStack.m_41784_().m_128441_("MagicRing")) {
            CompoundTag magicRing = flowerStack.m_41784_().m_128469_("MagicRing");
            this.ringSlot.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)magicRing));
        }
        this.m_38897_((Slot)new ExactSlot((IItemHandler)this.enchantSlot, Items.f_42534_, 0, 17, 31));
        this.m_38897_((Slot)new ExactSlot((IItemHandler)this.enchantSlot, Items.f_42692_, 1, 106, 31));
        this.m_38897_((Slot)new RingSlot((IItemHandler)this.ringSlot, 0, 80, 27));
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + k * 9 + 9, 8 + j * 18, 84 + k * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            if (k == this.player.m_150109_().f_35977_) {
                this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142){

                    public boolean m_8010_(Player playerIn) {
                        return false;
                    }

                    public boolean m_5857_(ItemStack stack) {
                        return false;
                    }

                    public int m_6641_() {
                        return 0;
                    }
                });
                continue;
            }
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
    }

    public boolean m_6366_(Player player, int id) {
        if (id >= 0 && id < 3) {
            int cost;
            ItemStack lapis = this.enchantSlot.getStackInSlot(0);
            if (lapis.m_41619_() && !player.m_150110_().f_35937_) {
                return false;
            }
            int n = this.costMode == 0 ? 2 : (cost = this.costMode == 1 ? 4 : 8);
            if (lapis.m_41613_() < cost && !player.m_150110_().f_35937_) {
                return false;
            }
            this.access.m_39292_((level, pos) -> {
                if (!level.m_5776_()) {
                    ArtificialFlower.Helper.randomAttribute(player, ArtificialFlower.Helper.getFlowerStack(player, false), id + 1, this.costMode, !this.ringSlot.getStackInSlot(0).m_41619_());
                    level.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                    if (!player.m_150110_().f_35937_) {
                        lapis.m_41774_(cost);
                        if (lapis.m_41619_()) {
                            this.enchantSlot.setStackInSlot(0, ItemStack.f_41583_);
                        }
                    }
                }
            });
            return true;
        }
        if (id == 3) {
            this.costMode = this.costMode == 2 ? 0 : this.costMode + 1;
            return true;
        }
        if (id == 4 || id == 5) {
            ItemStack quartz = this.enchantSlot.getStackInSlot(1);
            if (quartz.m_41619_() && !player.m_150110_().f_35937_) {
                return false;
            }
            if (quartz.m_41613_() < 4 && !player.m_150110_().f_35937_) {
                return false;
            }
            this.access.m_39292_((level, pos) -> {
                if (!level.m_5776_()) {
                    ArtificialFlower.Helper.randomEffect(player, ArtificialFlower.Helper.getFlowerStack(player, false), id - 4);
                    level.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                    if (!player.m_150110_().f_35937_) {
                        quartz.m_41774_(4);
                        if (quartz.m_41619_()) {
                            this.enchantSlot.setStackInSlot(1, ItemStack.f_41583_);
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    public ItemStack m_7648_(Player player, int id) {
        ItemStack stack = ItemStack.f_41583_;
        int slotsCount = 3;
        Slot slot = (Slot)this.f_38839_.get(id);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            stack = slotItem.m_41777_();
            if (id < slotsCount ? !this.m_38903_(slotItem, slotsCount, this.f_38839_.size(), true) : !this.m_38903_(slotItem, 0, slotsCount, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotItem.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotItem);
        }
        return stack;
    }

    public boolean valid(int index) {
        if (index > 1) {
            return false;
        }
        boolean[] flag = new boolean[]{this.enchantSlot.getStackInSlot(0).m_41613_() >= (this.costMode == 0 ? 2 : (this.costMode == 1 ? 4 : 8)), this.enchantSlot.getStackInSlot(1).m_41613_() >= 4};
        return !this.enchantSlot.getStackInSlot(index).m_41619_() && flag[index];
    }

    public boolean hasRing() {
        return !this.ringSlot.getStackInSlot(0).m_41619_();
    }

    public void m_6877_(Player player) {
        if (player instanceof ServerPlayer) {
            for (int i = 0; i < 2; ++i) {
                ItemStack stack = this.enchantSlot.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                if (player.m_6084_() && !((ServerPlayer)player).m_9232_()) {
                    player.m_150109_().m_150079_(stack);
                } else {
                    player.m_36176_(stack, false);
                }
                this.enchantSlot.setStackInSlot(i, ItemStack.f_41583_);
            }
            ItemStack flowerStack = ArtificialFlower.Helper.getFlowerStack(player, false);
            UUID uuid = UUID.randomUUID();
            player.getPersistentData().m_128362_("FlowerEnableUUID", uuid);
            flowerStack.m_41784_().m_128362_("FlowerUUID", uuid);
            flowerStack.m_41784_().m_128379_("FlowerEnable", true);
            ItemStack ring = this.ringSlot.getStackInSlot(0);
            if (!ring.m_41619_()) {
                CompoundTag save = ring.m_41739_(new CompoundTag());
                flowerStack.m_41784_().m_128365_("MagicRing", (Tag)save);
            } else {
                flowerStack.m_41784_().m_128473_("MagicRing");
            }
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public static class ExactSlot
    extends SlotItemHandler {
        private final Item item;

        public ExactSlot(IItemHandler itemHandler, Item item, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.item = item;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return stack.m_150930_(this.item) && super.m_5857_(stack);
        }

        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            String location = this.item.equals(Items.f_42534_) ? "slots/empty_lapis_slot" : "slots/empty_quartz_slot";
            return Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation("enigmaticaddons", location));
        }
    }

    public static class RingSlot
    extends SlotItemHandler {
        public RingSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return stack.m_150930_((Item)EnigmaticAddonItems.QUARTZ_RING) && super.m_5857_(stack);
        }

        public void m_6654_() {
            super.m_6654_();
        }

        public boolean m_280329_() {
            return false;
        }
    }

    public static class Provider
    implements MenuProvider {
        public AbstractContainerMenu m_7208_(int syncId, Inventory playerInv, Player player) {
            return new ArtificialFlowerMenu(syncId, playerInv);
        }

        public Component m_5446_() {
            return Component.m_237119_();
        }
    }
}

