/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.entities.goal;

import auviotre.enigmatic.addon.contents.entities.CobwebBall;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;

public class SpiderRangedAttackGoal
extends Goal {
    private final Monster spider;
    private final double speedModifier;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private int seeTime;
    private boolean hasAmmo;

    public SpiderRangedAttackGoal(Monster spider, double speed, int interval, float range) {
        this(spider, speed, interval, interval, range);
    }

    public SpiderRangedAttackGoal(Monster spider, double speed, int intervalMin, int intervalMax, float range) {
        this.spider = spider;
        this.speedModifier = speed;
        this.attackIntervalMin = intervalMin;
        this.attackIntervalMax = intervalMax;
        this.attackRadius = range;
        this.attackRadiusSqr = range * range;
        this.hasAmmo = true;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.hasAmmo) {
            return false;
        }
        LivingEntity mobTarget = this.spider.m_5448_();
        if (mobTarget != null && SuperAddonHandler.isCurseBoosted((LivingEntity)this.spider) && mobTarget.m_6084_()) {
            this.target = mobTarget;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.spider.m_21573_().m_26571_()) && this.hasAmmo && this.target != null && this.target.m_6084_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double distance = this.spider.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean hasLight = this.spider.m_21574_().m_148306_((Entity)this.target);
        this.seeTime = hasLight ? ++this.seeTime : 0;
        if (!(distance > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
            this.spider.m_21573_().m_26573_();
        } else {
            this.spider.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        }
        this.spider.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!hasLight) {
                return;
            }
            float distancePer = (float)Math.sqrt(distance) / this.attackRadius;
            int difficulty = this.spider.m_9236_().m_46791_().m_19028_();
            if (difficulty > 0) {
                CobwebBall ball = new CobwebBall(this.spider.m_9236_(), this.spider);
                double dx = this.target.m_20185_() - this.spider.m_20185_();
                double dy = this.target.m_20227_(0.3333333333333333) - ball.m_20186_();
                double dz = this.target.m_20189_() - this.spider.m_20189_();
                double horDist = Math.sqrt(dx * dx + dz * dz);
                ball.m_6686_(dx, dy + horDist * 0.2, dz, 1.2f, 14 - difficulty * 3);
                this.spider.m_5496_(SoundEvents.f_12417_, 1.0f, 1.0f / (this.spider.m_217043_().m_188501_() * 0.4f + 0.8f));
                this.spider.m_9236_().m_7967_((Entity)ball);
                if (this.spider.m_217043_().m_188503_(difficulty) == 0) {
                    this.hasAmmo = false;
                }
            } else {
                this.hasAmmo = false;
            }
            this.attackTime = Mth.m_14143_((float)(distancePer * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(distance) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }
}

