/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.retrieve.mixins;

import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.items.StorageCrystal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.xewe.retrieve.Config;
import ru.xewe.retrieve.events.InventoryManager;

@Debug
@Mixin(value={StorageCrystal.class})
public abstract class MixinStorageCrystal {
    @Unique
    final String STORED_SLOT_TAG = "storedStackSlot";
    @Unique
    final String STORED_CURIO_TAG = "storedCurio";
    @Unique
    final String STORED_CURIO_STACKS = "storedCurioStacks";

    @ModifyVariable(method={"storeDropsOnCrystal"}, at=@At(value="HEAD"), argsOnly=true, remap=false)
    public Collection<ItemEntity> filterDrops(Collection<Object> originalDrops, Collection<Object> drops, Player player, @Nullable ItemStack embeddedSoulCrystal) {
        return drops.stream().filter(drop -> {
            ItemEntity itemEntity;
            return drop instanceof ItemEntity && !InventoryManager.hasCurio(player, (itemEntity = (ItemEntity)drop).m_32055_());
        }).map(ItemEntity.class::cast).collect(Collectors.toCollection(ArrayList::new));
    }

    @Inject(method={"storeDropsOnCrystal"}, at={@At(value="RETURN", target="Lcom/aizistral/enigmaticlegacy/helpers/ItemNBTHelper;getNBT(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/nbt/CompoundTag;")}, remap=false, cancellable=true)
    private void onStoreDrops(Collection<Object> rawDrops, Player player, @Nullable ItemStack embeddedSoulCrystal, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack crystal = (ItemStack)cir.getReturnValue();
        CompoundTag crystalNBT = ItemNBTHelper.getNBT((ItemStack)crystal);
        List<ItemEntity> drops = rawDrops.stream().filter(ItemEntity.class::isInstance).map(ItemEntity.class::cast).toList();
        int counter = 0;
        for (ItemEntity drop : drops) {
            ItemStack stack = drop.m_32055_();
            int indexStack = InventoryManager.findSlotMatchingItem(player, stack);
            crystalNBT.m_128405_("storedStackSlot" + counter, indexStack);
            ++counter;
        }
        ListTag listTag = InventoryManager.getCurioListTags(player);
        for (int counterCurio = 0; counterCurio < listTag.size(); ++counterCurio) {
            Tag tag = listTag.get(counterCurio);
            crystalNBT.m_128365_("storedCurio" + counterCurio, tag);
        }
        crystalNBT.m_128405_("storedCurioStacks", listTag.size());
        cir.setReturnValue((Object)crystal);
        cir.cancel();
    }

    @Inject(method={"retrieveDropsFromCrystal"}, at={@At(value="RETURN")}, remap=false)
    private void onRetrieveDrops(ItemStack crystal, Player player, ItemStack retrieveSoul, CallbackInfoReturnable<ItemStack> cir) {
        CompoundTag crystalNBT = ItemNBTHelper.getNBT((ItemStack)crystal);
        int counterCurios = crystalNBT.m_128451_("storedCurioStacks");
        ListTag listTag = new ListTag();
        for (int i = 0; i < counterCurios; ++i) {
            Tag tag = crystalNBT.m_128423_("storedCurio" + i);
            listTag.add((Object)tag);
        }
        InventoryManager.loadCurio(player, listTag);
    }

    @Redirect(method={"retrieveDropsFromCrystal"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;add(Lnet/minecraft/world/item/ItemStack;)Z"))
    private boolean onAddItem(Inventory inventory, ItemStack stack, ItemStack crystal, Player player, ItemStack retrieveSoul) {
        int originalSlot;
        CompoundTag crystalNBT = ItemNBTHelper.getNBT((ItemStack)crystal);
        int counter = crystalNBT.m_128451_("storedStacks") - 1;
        int currentIndex = -1;
        for (int c = counter; c >= 0; --c) {
            if (!crystalNBT.m_128441_("storedStack" + c)) continue;
            currentIndex = c;
            break;
        }
        if ((originalSlot = crystalNBT.m_128451_("storedStackSlot" + currentIndex)) >= 0 && originalSlot < player.m_150109_().m_6643_()) {
            ItemStack originalItem = inventory.m_8020_(originalSlot);
            if (originalItem.m_41619_()) {
                inventory.m_6836_(originalSlot, stack);
                return true;
            }
            if (!Config.SWAP_STORAGE_ITEMS) {
                player.m_213846_((Component)Component.m_237113_((String)"swapItem"));
                inventory.m_6836_(originalSlot, stack);
                if (!inventory.m_36054_(originalItem)) {
                    player.m_213846_((Component)Component.m_237113_((String)"drop"));
                    ItemEntity drop = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), originalItem);
                    player.m_9236_().m_7967_((Entity)drop);
                }
                return true;
            }
        }
        return inventory.m_36054_(stack);
    }
}

