/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.retrieve.events;

import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod.EventBusSubscriber(modid="elretrievetoslot", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class InventoryManager {
    private static final Map<UUID, List<NonNullList<ItemStack>>> savedItems = new HashMap<UUID, List<NonNullList<ItemStack>>>();
    private static final Map<UUID, ListTag> savedCurioListTags = new HashMap<UUID, ListTag>();
    private static final Map<UUID, List<ItemStack>> stacksCurio = new HashMap<UUID, List<ItemStack>>();

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            InventoryManager.saveItems(player);
            InventoryManager.saveStacksCurio(player);
            InventoryManager.saveCurio(player, event.getSource());
        }
    }

    public static int findSlotMatchingItem(Player player, ItemStack itemStack) {
        int globalSlot = -1;
        UUID playerUUID = player.m_20148_();
        List compartments = savedItems.getOrDefault(playerUUID, new ArrayList());
        for (NonNullList compartment : compartments) {
            for (int slot = 0; slot < compartment.size(); ++slot) {
                ItemStack stack = (ItemStack)compartment.get(slot);
                ++globalSlot;
                if (stack.m_41619_() || !ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemStack)) continue;
                compartment.set(slot, (Object)ItemStack.f_41583_);
                return globalSlot;
            }
        }
        return -1;
    }

    private static void saveStacksCurio(Player player) {
        LazyOptional inv = CuriosApi.getCuriosInventory((LivingEntity)player);
        ArrayList<ItemStack> equippedCurio = new ArrayList<ItemStack>();
        if (inv.resolve().isPresent()) {
            IItemHandlerModifiable equippedCurioHandler = ((ICuriosItemHandler)inv.resolve().get()).getEquippedCurios();
            for (int i = 0; i < equippedCurioHandler.getSlots(); ++i) {
                equippedCurio.add(equippedCurioHandler.getStackInSlot(i));
            }
            stacksCurio.put(player.m_20148_(), equippedCurio);
        }
    }

    private static List<ItemStack> getStacksCurio(Player player) {
        return stacksCurio.get(player.m_20148_());
    }

    public static boolean hasCurio(Player player, ItemStack itemStack) {
        return InventoryManager.getStacksCurio(player).contains(itemStack);
    }

    private static void saveCurio(Player player, DamageSource source) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inv -> {
            ListTag tagList = inv.saveInventory(false, (itemStack, slotContext) -> {
                ItemBaseCurio curioItem;
                Item patt4836$temp = itemStack.m_41720_();
                return !(patt4836$temp instanceof ItemBaseCurio) || !(curioItem = (ItemBaseCurio)patt4836$temp).getDropRule(slotContext, source, 0, false, itemStack).equals((Object)ICurio.DropRule.ALWAYS_KEEP);
            });
            savedCurioListTags.put(player.m_20148_(), tagList);
        });
    }

    public static void loadCurio(Player player, ListTag data) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInventory -> curiosInventory.loadInventory(data));
    }

    private static void loadStacks(Player player, ICuriosItemHandler curiosItemHandler, ICurioStacksHandler stacksHandler, ItemStackHandler loaded, IDynamicStackHandler stacks) {
        for (int j = 0; j < loaded.getSlots(); ++j) {
            ItemStack loadedStack = loaded.getStackInSlot(j);
            if (j < stacksHandler.getSlots() && stacks.getStackInSlot(j).m_41619_()) {
                stacks.setStackInSlot(j, loadedStack);
                continue;
            }
            curiosItemHandler.loseInvalidStack(loadedStack);
        }
    }

    public static ListTag getCurioListTags(Player player) {
        return savedCurioListTags.get(player.m_20148_());
    }

    private static void saveItems(Player player) {
        Inventory inv = player.m_150109_();
        List<NonNullList<ItemStack>> compartments = List.of(InventoryManager.copyItems((NonNullList<ItemStack>)inv.f_35974_), InventoryManager.copyItems((NonNullList<ItemStack>)inv.f_35975_), InventoryManager.copyItems((NonNullList<ItemStack>)inv.f_35976_));
        savedItems.put(player.m_20148_(), compartments);
    }

    private static NonNullList<ItemStack> copyItems(NonNullList<ItemStack> original) {
        NonNullList copy = NonNullList.m_122780_((int)original.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < original.size(); ++i) {
            copy.set(i, (Object)((ItemStack)original.get(i)).m_41777_());
        }
        return copy;
    }
}

