/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.util;

import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.api.research.Research;
import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.network.KnowledgeUpdatePacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.registries.AdvancementTriggers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class KnowledgeUtil {
    public static void grantSign(Entity entity, Sign sign) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            if (k.knowsSign(sign)) {
                return;
            }
            k.addSign(sign);
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"eidolon.title.new_sign", (Object[])new Object[]{Component.m_237115_((String)(sign.getRegistryName().m_135827_() + ".sign." + sign.getRegistryName().m_135815_()))})));
            AdvancementTriggers.triggerSign(sign, player);
            Networking.sendTo((Player)player, new KnowledgeUpdatePacket((Player)player, true));
        });
    }

    public static void grantFact(Entity entity, ResourceLocation fact) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            if (k.knowsFact(fact)) {
                return;
            }
            k.addFact(fact);
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"eidolon.title.new_fact")));
            Networking.sendTo((Player)player, new KnowledgeUpdatePacket((Player)player, true));
        });
        AdvancementTriggers.triggerResearch(fact.m_135815_(), player);
    }

    public static void grantResearch(Entity entity, @NotNull Research research) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            if (k.knowsResearch(research)) {
                return;
            }
            k.addResearch(research.getRegistryName());
            research.onLearned(serverPlayer);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"eidolon.title.new_research", (Object[])new Object[]{String.valueOf(ChatFormatting.GOLD) + research.getName()})));
            Networking.sendTo((Player)serverPlayer, new KnowledgeUpdatePacket((Player)serverPlayer, true));
        });
        AdvancementTriggers.triggerResearch(research.getRegistryName().toString(), serverPlayer);
    }

    public static void grantResearchNoToast(Entity entity, @NotNull ResourceLocation research) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            if (k.knowsResearch(research)) {
                return;
            }
            k.addResearch(research);
            Networking.sendTo((Player)serverPlayer, new KnowledgeUpdatePacket((Player)serverPlayer, true));
        });
        AdvancementTriggers.triggerResearch(research.m_135815_(), serverPlayer);
    }

    public static void grantRune(Entity entity, Rune rune) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            if (k.knowsRune(rune)) {
                return;
            }
            k.addRune(rune);
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"eidolon.title.new_rune", (Object[])new Object[]{Component.m_237115_((String)(rune.getRegistryName().m_135827_() + ".rune." + rune.getRegistryName().m_135815_()))})));
            Networking.sendTo((Player)player, new KnowledgeUpdatePacket((Player)player, true));
        });
    }

    public static List<Sign> getKnownSigns(Player player) {
        ArrayList<Sign> list = new ArrayList<Sign>();
        if (player.getCapability(IKnowledge.INSTANCE).isPresent()) {
            IKnowledge cap = (IKnowledge)player.getCapability(IKnowledge.INSTANCE).resolve().get();
            list.addAll(cap.getKnownSigns());
        }
        return list;
    }

    public static boolean knowsSign(Player player, Sign sign) {
        if (player.getCapability(IKnowledge.INSTANCE).isPresent()) {
            return ((IKnowledge)player.getCapability(IKnowledge.INSTANCE).resolve().get()).knowsSign(sign);
        }
        return false;
    }

    public static boolean knowsFact(Player player, ResourceLocation fact) {
        if (player.getCapability(IKnowledge.INSTANCE).isPresent()) {
            return ((IKnowledge)player.getCapability(IKnowledge.INSTANCE).resolve().get()).knowsFact(fact);
        }
        return false;
    }

    public static boolean knowsResearch(Player player, ResourceLocation research) {
        if (player.getCapability(IKnowledge.INSTANCE).isPresent()) {
            return ((IKnowledge)player.getCapability(IKnowledge.INSTANCE).resolve().get()).knowsResearch(research);
        }
        return false;
    }

    public static boolean knowsRune(Player player, Rune rune) {
        if (player.getCapability(IKnowledge.INSTANCE).isPresent()) {
            return ((IKnowledge)player.getCapability(IKnowledge.INSTANCE).resolve().get()).knowsRune(rune);
        }
        return false;
    }

    public static void removeSign(Entity entity, Sign sign) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            if (!k.knowsSign(sign)) {
                return;
            }
            k.removeSign(sign);
            Networking.sendTo((Player)player, new KnowledgeUpdatePacket((Player)player, true));
        });
    }

    public static void removeFact(Entity entity, ResourceLocation fact) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            if (!k.knowsFact(fact)) {
                return;
            }
            k.removeFact(fact);
            Networking.sendTo((Player)player, new KnowledgeUpdatePacket((Player)player, true));
        });
    }

    public static void removeResearch(Entity entity, ResourceLocation research) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            if (!k.knowsResearch(research)) {
                return;
            }
            k.removeResearch(research);
            Networking.sendTo((Player)player, new KnowledgeUpdatePacket((Player)player, true));
        });
    }

    public static void removeRune(Entity entity, Rune rune) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            if (!k.knowsRune(rune)) {
                return;
            }
            k.removeRune(rune);
            Networking.sendTo((Player)player, new KnowledgeUpdatePacket((Player)player, true));
        });
    }

    public static void resetSigns(Entity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            k.resetSigns();
            Networking.sendTo((Player)player, new KnowledgeUpdatePacket((Player)player, true));
        });
    }

    public static void resetFacts(Entity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            k.resetFacts();
            Networking.sendTo((Player)player, new KnowledgeUpdatePacket((Player)player, true));
        });
    }

    public static void resetResearch(Entity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            k.resetResearch();
            Networking.sendTo((Player)player, new KnowledgeUpdatePacket((Player)player, true));
        });
    }

    public static void resetRunes(Entity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        entity.getCapability(IKnowledge.INSTANCE, null).ifPresent(k -> {
            k.resetRunes();
            Networking.sendTo((Player)player, new KnowledgeUpdatePacket((Player)player, true));
        });
    }

    public static void tryFix(Player player) {
        Level level;
        if (!(player instanceof ServerPlayer) || !((level = player.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        LazyOptional devotion = server.getCapability(IReputation.INSTANCE);
        if (devotion.isPresent()) {
            IReputation d = (IReputation)devotion.resolve().get();
            Deities.getDeities().forEach(deity -> {
                Deity.Stage next;
                double rep = d.getReputation(player, deity.getId());
                Deity.Stage curStage = deity.getProgression().last(rep);
                double fakeRep = 1.0;
                int counter = 0;
                while (fakeRep < (double)curStage.rep() && counter++ < 20 && (next = deity.getProgression().next(fakeRep)) != null) {
                    deity.onReputationLock(player, next.id());
                    deity.onReputationUnlock(player, next.id());
                    fakeRep = next.rep() + 1;
                }
            });
        }
    }
}

