/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import elucent.eidolon.Eidolon;
import elucent.eidolon.api.ritual.FocusItemPresentRequirement;
import elucent.eidolon.api.ritual.HealthRequirement;
import elucent.eidolon.api.ritual.ItemRequirement;
import elucent.eidolon.api.ritual.ItemSacrifice;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.ritual.AbsorptionRitual;
import elucent.eidolon.common.ritual.AllureRitual;
import elucent.eidolon.common.ritual.CrystalRitual;
import elucent.eidolon.common.ritual.DaylightRitual;
import elucent.eidolon.common.ritual.DeceitRitual;
import elucent.eidolon.common.ritual.MoonlightRitual;
import elucent.eidolon.common.ritual.MultiItemSacrifice;
import elucent.eidolon.common.ritual.PurifyRitual;
import elucent.eidolon.common.ritual.RechargingRitual;
import elucent.eidolon.common.ritual.RepellingRitual;
import elucent.eidolon.datagen.SimpleDataProvider;
import elucent.eidolon.recipe.GenericRitualRecipe;
import elucent.eidolon.recipe.ItemRitualRecipe;
import elucent.eidolon.recipe.LocationRitualRecipe;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.recipe.SummonRitualRecipe;
import elucent.eidolon.registries.EidolonEntities;
import elucent.eidolon.registries.Registry;
import elucent.eidolon.registries.Worldgen;
import elucent.eidolon.util.RecipeUtil;
import elucent.eidolon.util.RegistryUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import org.jetbrains.annotations.NotNull;

public class EidRitualProvider
extends SimpleDataProvider {
    List<RitualRecipe> rituals = new ArrayList<RitualRecipe>();

    public EidRitualProvider(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addRituals();
        for (RitualRecipe recipe : this.rituals) {
            Path path = EidRitualProvider.getRecipePath(this.output, recipe.m_6423_().m_135815_());
            this.saveStable(pOutput, recipe.asRecipe(), path);
        }
    }

    protected void addRituals() {
        this.makeSummon(Eidolon.prefix("summon_zombie"), EntityType.f_20501_, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.f_42583_), List.of(Items.f_42583_));
        this.makeSummon(Eidolon.prefix("summon_skeleton"), EntityType.f_20524_, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.f_42500_), List.of(Items.f_42500_));
        this.makeSummon(Eidolon.prefix("summon_phantom"), EntityType.f_20509_, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.f_42714_), List.of(Items.f_42714_));
        this.makeSummon(Eidolon.prefix("summon_creeper"), EntityType.f_20558_, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.f_42403_), List.of(Items.f_42403_));
        this.makeSummon(Eidolon.prefix("summon_wither_skeleton"), EntityType.f_20497_, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.f_42500_), List.of(Blocks.f_50135_));
        this.makeSummon(Eidolon.prefix("summon_husk"), EntityType.f_20458_, (ItemLike)Items.f_42414_, RecipeUtil.ingredientsFromObjects(List.of(Registry.SOUL_SHARD.get(), Items.f_42583_)), List.of(Ingredient.m_204132_((TagKey)Tags.Items.SAND)));
        this.makeSummon(Eidolon.prefix("summon_drowned"), EntityType.f_20562_, (ItemLike)Items.f_42414_, RecipeUtil.ingredientsFromObjects(List.of(Registry.SOUL_SHARD.get(), Items.f_42583_)), List.of(Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_PRISMARINE)));
        this.makeSummon(Eidolon.prefix("summon_stray"), EntityType.f_20481_, List.of((ItemLike)Registry.SOUL_SHARD.get(), Items.f_42500_), List.of(Items.f_42401_));
        this.makeSummon(Eidolon.prefix("summon_wraith"), (EntityType)EidolonEntities.WRAITH.get(), List.of((ItemLike)Registry.SOUL_SHARD.get(), (ItemLike)Registry.TATTERED_CLOTH.get()), List.of((ItemLike)Registry.TATTERED_CLOTH.get()));
        this.makeSummon(Eidolon.prefix("summon_slugs"), (EntityType)EidolonEntities.SLIMY_SLUG.get(), 3, (ItemLike)Items.f_42577_, RecipeUtil.ingredientsFromObjects(List.of(Registry.SOUL_SHARD.get(), Items.f_42518_)), List.of());
        this.makeSummon(Eidolon.prefix("summon_ravens"), (EntityType)EidolonEntities.RAVEN.get(), 3, (ItemLike)Items.f_42733_, RecipeUtil.ingredientsFromObjects(List.of(Registry.SOUL_SHARD.get(), Items.f_42402_)), List.of());
        ItemStack HarmingPotion = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43582_);
        PartialNBTIngredient harmingIngredient = PartialNBTIngredient.of((ItemLike)HarmingPotion.m_41720_(), (CompoundTag)HarmingPotion.m_41784_());
        this.crafting(((Item)Registry.SAPPING_SWORD.get()).m_7968_(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42383_}), RecipeUtil.ingredientsFromObjects(List.of(Registry.SHADOW_GEM.get(), Registry.SOUL_SHARD.get(), Registry.SOUL_SHARD.get(), Items.f_42588_, Items.f_42588_, Items.f_42586_)), List.of(harmingIngredient), 20);
        this.crafting(((Item)Registry.SANGUINE_AMULET.get()).m_7968_(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registry.BASIC_AMULET.get()}), RecipeUtil.ingredientsFromObjects(List.of(Tags.Items.GEMS_DIAMOND, Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE, Registry.LESSER_SOUL_GEM.get())), List.of(harmingIngredient), 40);
        this.generic((ItemLike)Items.f_42499_, new CrystalRitual().setRegistryName("eidolon", "crystal").addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)));
        this.generic((TagKey<Item>)Tags.Items.GEMS_EMERALD, new DeceitRitual().setRegistryName("eidolon", "deceit").addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.GEMS_EMERALD)).addRequirement(new ItemRequirement(Items.f_42592_)).addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.MUSHROOMS)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((ItemLike)Items.f_42208_, new AllureRitual().setRegistryName("eidolon", "allure").addRequirement(new ItemRequirement(Items.f_42436_)).addRequirement(new ItemRequirement(Items.f_42497_)).addRequirement(new ItemRequirement(Items.f_42497_)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((ItemLike)Items.f_42715_, new RepellingRitual().setRegistryName("eidolon", "repelling").addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.INGOTS_IRON)).addRequirement(new ItemRequirement(Items.f_42454_)).addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.GEMS_QUARTZ)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((ItemLike)Items.f_42206_, new DaylightRitual().setRegistryName("eidolon", "daylight").addRequirement(new ItemRequirement(Items.f_42414_)).addRequirement(new ItemRequirement(Items.f_42404_)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((TagKey<Item>)Tags.Items.DYES_BLACK, new MoonlightRitual().setRegistryName("eidolon", "moonlight").addRequirement(new ItemRequirement(Items.f_42452_)).addRequirement(new ItemRequirement(Items.f_42591_)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((ItemLike)Items.f_42546_, new PurifyRitual().setRegistryName("eidolon", "purify").addRequirement(new ItemRequirement((Block)Registry.ENCHANTED_ASH.get())).addRequirement(new ItemRequirement((Block)Registry.ENCHANTED_ASH.get())).addRequirement(new ItemRequirement(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43623_))).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())));
        this.generic((ItemLike)Registry.DEATH_ESSENCE.get(), new AbsorptionRitual().setRegistryName("eidolon", "absorption").addRequirement(new ItemRequirement((Item)Registry.TATTERED_CLOTH.get())).addRequirement(new ItemRequirement((Item)Registry.TATTERED_CLOTH.get())).addRequirement(new ItemRequirement(Items.f_42500_)).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addRequirement(new ItemRequirement((Item)Registry.SOUL_SHARD.get())).addInvariant(new FocusItemPresentRequirement((ItemLike)Registry.SUMMONING_STAFF.get())));
        this.generic((ItemLike)Registry.LESSER_SOUL_GEM.get(), new RechargingRitual().setRegistryName("eidolon", "recharging_soulfire").addRequirement(new ItemRequirement(Items.f_42593_)).addRequirement(new ItemRequirement(Items.f_42593_)).addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).addInvariant(new FocusItemPresentRequirement((ItemLike)Registry.SOULFIRE_WAND.get())));
        this.generic((ItemLike)Registry.LESSER_SOUL_GEM.get(), new RechargingRitual().setRegistryName("eidolon", "recharging_chill").addRequirement(new ItemRequirement(Items.f_42452_)).addRequirement(new ItemRequirement(Items.f_42452_)).addRequirement(new ItemRequirement((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).addInvariant(new FocusItemPresentRequirement((ItemLike)Registry.BONECHILL_WAND.get())));
        this.location(Worldgen.CATACOMBS, Eidolon.prefix("ritual_catacomb_locator"), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42676_}), RecipeUtil.ingredientsFromObjects(List.of(Items.f_42522_, Registry.MAGIC_INK.get(), Registry.RAVEN_FEATHER.get())), List.of(), 0);
    }

    public void crafting(ItemStack result, Ingredient reagent, List<Ingredient> pedestal, List<Ingredient> foci, int healthCost) {
        this.rituals.add(new ItemRitualRecipe(RegistryUtil.getRegistryName(result.m_41720_()), pedestal, foci, reagent, result, true, healthCost));
    }

    public void location(TagKey<Structure> structureTagKey, ResourceLocation location, Ingredient reagent, List<Ingredient> pedestal, List<Ingredient> foci, int healthCost) {
        this.rituals.add(new LocationRitualRecipe(location, structureTagKey.f_203868_(), reagent, pedestal, foci, (float)healthCost));
    }

    public void makeSummon(ResourceLocation id, EntityType<?> type, ItemLike item, List<Ingredient> pedestal, List<Ingredient> foci) {
        this.rituals.add(new SummonRitualRecipe(id, RegistryUtil.getRegistryName(type), Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), pedestal, foci));
    }

    public void makeSummon(ResourceLocation id, EntityType<?> type, int count, ItemLike item, List<Ingredient> pedestal, List<Ingredient> foci) {
        this.rituals.add(new SummonRitualRecipe(id, RegistryUtil.getRegistryName(type), Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), pedestal, foci, count, 0.0f));
    }

    public void makeSummon(ResourceLocation id, EntityType<?> type, List<ItemLike> pedestal, List<ItemLike> foci) {
        this.makeSummon(id, type, (ItemLike)Items.f_42414_, pedestal.stream().map(xva$0 -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{xva$0})).toList(), foci.stream().map(xva$0 -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{xva$0})).toList());
    }

    public void generic(ItemLike item, Ritual ritual) {
        this.generic(new ItemSacrifice(item), ritual);
    }

    public void generic(TagKey<Item> item, Ritual ritual) {
        this.generic(new ItemSacrifice(item), ritual);
    }

    public void generic(ItemSacrifice keys, Ritual ritual) {
        List<Ingredient> list;
        List<Ingredient> pedestal = ritual.getRequirements().stream().filter(req -> req instanceof ItemRequirement).map(req -> (ItemRequirement)req).map(ItemRequirement::getMatch).toList();
        Ingredient reagent = keys.main;
        if (keys instanceof MultiItemSacrifice) {
            MultiItemSacrifice mis = (MultiItemSacrifice)keys;
            list = mis.items;
        } else {
            list = List.of();
        }
        List<Ingredient> foci = list;
        List<Ingredient> invariants = ritual.getInvariants().stream().filter(iRequirement -> iRequirement instanceof FocusItemPresentRequirement).map(iRequirement -> (FocusItemPresentRequirement)iRequirement).map(FocusItemPresentRequirement::getMatch).collect(Collectors.toList());
        float health = ritual.getRequirements().stream().filter(req -> req instanceof HealthRequirement).map(req -> (HealthRequirement)req).map(HealthRequirement::getHealth).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
        this.rituals.add(new GenericRitualRecipe(Eidolon.prefix("ritual_" + ritual.getRegistryName().m_135815_()), ritual.getRegistryName(), reagent, pedestal, foci, invariants, health));
    }

    @NotNull
    public String m_6055_() {
        return "Eidolon Rituals";
    }

    protected static Path getRecipePath(Path pathIn, Item item) {
        return EidRitualProvider.getRecipePath(pathIn, RegistryUtil.getRegistryName(item).m_135815_());
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/eidolon/recipes/rituals/" + str + ".json");
    }
}

